/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch.voxel;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.valkyrienskies.physics_api.voxel.CollisionPoint;
import org.valkyrienskies.physics_api.voxel.Lod1BeltType;
import org.valkyrienskies.physics_api.voxel.Lod1LiquidBlockState;
import org.valkyrienskies.physics_api.voxel.Lod1SolidBeltCollisionShape;
import org.valkyrienskies.physics_api.voxel.Lod1SolidBlockState;
import org.valkyrienskies.physics_api.voxel.Lod1SolidBoxesCollisionShape;
import org.valkyrienskies.physics_api.voxel.Lod1SolidCollisionShape;
import org.valkyrienskies.physics_api.voxel.Lod1SolidCollisionShapeType;
import org.valkyrienskies.physics_api.voxel.LodBlockBoundingBox;

public class Lod1BlockStateSerializer {
    private Lod1BlockStateSerializer() {
    }

    public static void serializeLod1SolidBlockState(@NotNull Lod1SolidBlockState lod1SolidBlockState, @NotNull ByteBuffer byteBuffer) {
        Lod1BlockStateSerializer.serializeLod1SolidCollisionShape(lod1SolidBlockState.getCollisionShape(), byteBuffer);
        byteBuffer.putFloat(lod1SolidBlockState.getElasticity());
        byteBuffer.putFloat(lod1SolidBlockState.getFriction());
        byteBuffer.putFloat(lod1SolidBlockState.getHardness());
        byteBuffer.putInt(lod1SolidBlockState.getLod1SolidBlockStateId());
    }

    public static Lod1SolidBlockState deserializeLod1SolidBlockState(@NotNull ByteBuffer byteBuffer) {
        Lod1SolidCollisionShape lod1SolidCollisionShape = Lod1BlockStateSerializer.deserializeLod1SolidCollisionShape(byteBuffer);
        float elasticity = byteBuffer.getFloat();
        float friction = byteBuffer.getFloat();
        float hardness = byteBuffer.getFloat();
        int id2 = byteBuffer.getInt();
        return new Lod1SolidBlockState(lod1SolidCollisionShape, elasticity, friction, hardness, id2);
    }

    public static void serializeLod1LiquidBlockState(@NotNull Lod1LiquidBlockState lod1LiquidBlockState, @NotNull ByteBuffer byteBuffer) {
        Lod1BlockStateSerializer.serializeLodBlockBoundingBox(lod1LiquidBlockState.getBoundingBox(), byteBuffer);
        byteBuffer.putFloat(lod1LiquidBlockState.getDensity());
        byteBuffer.putFloat(lod1LiquidBlockState.getDragCoefficient());
        Lod1BlockStateSerializer.serializeVector3f(lod1LiquidBlockState.getFluidVel(), byteBuffer);
        byteBuffer.putInt(lod1LiquidBlockState.getLod1LiquidBlockStateId());
    }

    public static Lod1LiquidBlockState deserializeLod1LiquidBlockState(@NotNull ByteBuffer byteBuffer) {
        LodBlockBoundingBox boundingBox = Lod1BlockStateSerializer.deserializeLodBlockBoundingBox(byteBuffer);
        float density = byteBuffer.getFloat();
        float dragCoefficient = byteBuffer.getFloat();
        Vector3f fluidVel = Lod1BlockStateSerializer.deserializeVector3f(byteBuffer);
        int id2 = byteBuffer.getInt();
        return new Lod1LiquidBlockState(boundingBox, density, dragCoefficient, fluidVel, id2);
    }

    private static void serializeLod1SolidCollisionShape(@NotNull Lod1SolidCollisionShape lod1SolidCollisionShape, @NotNull ByteBuffer byteBuffer) {
        byteBuffer.putInt(lod1SolidCollisionShape.getCollisionShapeType().ordinal());
        switch (lod1SolidCollisionShape.getCollisionShapeType()) {
            case SOLID_BOXES: {
                Lod1BlockStateSerializer.serializeLod1SolidBoxesCollisionShape((Lod1SolidBoxesCollisionShape)lod1SolidCollisionShape, byteBuffer);
                break;
            }
            case BELT: {
                Lod1BlockStateSerializer.serializeLod1SolidBeltCollisionShape((Lod1SolidBeltCollisionShape)lod1SolidCollisionShape, byteBuffer);
            }
        }
    }

    private static Lod1SolidCollisionShape deserializeLod1SolidCollisionShape(@NotNull ByteBuffer byteBuffer) {
        Lod1SolidCollisionShapeType collisionShapeType = Lod1SolidCollisionShapeType.values()[byteBuffer.getInt()];
        switch (collisionShapeType) {
            case SOLID_BOXES: {
                return Lod1BlockStateSerializer.deserializeLod1SolidBoxesCollisionShape(byteBuffer);
            }
            case BELT: {
                return Lod1BlockStateSerializer.deserializeLod1SolidBeltCollisionShape(byteBuffer);
            }
        }
        throw new RuntimeException("Failed to deserialize unknown Lod1SolidCollisionShape");
    }

    private static void serializeLod1SolidBoxesCollisionShape(@NotNull Lod1SolidBoxesCollisionShape lod1SolidBoxesCollisionShape, @NotNull ByteBuffer byteBuffer) {
        Lod1BlockStateSerializer.serializeLodBlockBoundingBox(lod1SolidBoxesCollisionShape.getOverallBoundingBox(), byteBuffer);
        Lod1BlockStateSerializer.serializeCollisionPoints(lod1SolidBoxesCollisionShape.getCollisionPoints(), byteBuffer);
        byteBuffer.putInt(lod1SolidBoxesCollisionShape.getSolidBoxes().size());
        for (LodBlockBoundingBox lodBlockBoundingBox : lod1SolidBoxesCollisionShape.getSolidBoxes()) {
            Lod1BlockStateSerializer.serializeLodBlockBoundingBox(lodBlockBoundingBox, byteBuffer);
        }
        byteBuffer.putInt(lod1SolidBoxesCollisionShape.getNegativeBoxes().size());
        for (LodBlockBoundingBox negativeBox : lod1SolidBoxesCollisionShape.getNegativeBoxes()) {
            Lod1BlockStateSerializer.serializeLodBlockBoundingBox(negativeBox, byteBuffer);
        }
    }

    private static Lod1SolidBoxesCollisionShape deserializeLod1SolidBoxesCollisionShape(@NotNull ByteBuffer byteBuffer) {
        LodBlockBoundingBox overallBoundingBox = Lod1BlockStateSerializer.deserializeLodBlockBoundingBox(byteBuffer);
        List<CollisionPoint> collisionPoints = Lod1BlockStateSerializer.deserializeCollisionPoints(byteBuffer);
        int solidBoxesSize = byteBuffer.getInt();
        ArrayList<LodBlockBoundingBox> solidBoxes = new ArrayList<LodBlockBoundingBox>(solidBoxesSize);
        for (int i2 = 0; i2 < solidBoxesSize; ++i2) {
            solidBoxes.add(Lod1BlockStateSerializer.deserializeLodBlockBoundingBox(byteBuffer));
        }
        int negativeBoxesSize = byteBuffer.getInt();
        ArrayList<LodBlockBoundingBox> negativeBoxes = new ArrayList<LodBlockBoundingBox>(negativeBoxesSize);
        for (int i3 = 0; i3 < negativeBoxesSize; ++i3) {
            negativeBoxes.add(Lod1BlockStateSerializer.deserializeLodBlockBoundingBox(byteBuffer));
        }
        return new Lod1SolidBoxesCollisionShape(overallBoundingBox, collisionPoints, solidBoxes, negativeBoxes);
    }

    private static void serializeLod1SolidBeltCollisionShape(@NotNull Lod1SolidBeltCollisionShape lod1SolidBeltCollisionShape, @NotNull ByteBuffer byteBuffer) {
        Lod1BlockStateSerializer.serializeLodBlockBoundingBox(lod1SolidBeltCollisionShape.getOverallBoundingBox(), byteBuffer);
        Lod1BlockStateSerializer.serializeCollisionPoints(lod1SolidBeltCollisionShape.getCollisionPoints(), byteBuffer);
        Lod1BlockStateSerializer.serializeLodBlockBoundingBox(lod1SolidBeltCollisionShape.getLocalBoundingBox(), byteBuffer);
        byteBuffer.putInt(lod1SolidBeltCollisionShape.getBeltType().ordinal());
        Lod1BlockStateSerializer.serializeVector3f(lod1SolidBeltCollisionShape.getTopVel(), byteBuffer);
    }

    private static Lod1SolidBeltCollisionShape deserializeLod1SolidBeltCollisionShape(@NotNull ByteBuffer byteBuffer) {
        LodBlockBoundingBox overallBoundingBox = Lod1BlockStateSerializer.deserializeLodBlockBoundingBox(byteBuffer);
        List<CollisionPoint> collisionPoints = Lod1BlockStateSerializer.deserializeCollisionPoints(byteBuffer);
        LodBlockBoundingBox localBoundingBox = Lod1BlockStateSerializer.deserializeLodBlockBoundingBox(byteBuffer);
        Lod1BeltType beltType = Lod1BeltType.values()[byteBuffer.getInt()];
        Vector3f topVel = Lod1BlockStateSerializer.deserializeVector3f(byteBuffer);
        return new Lod1SolidBeltCollisionShape(overallBoundingBox, collisionPoints, localBoundingBox, beltType, topVel);
    }

    private static void serializeLodBlockBoundingBox(@NotNull LodBlockBoundingBox lodBlockBoundingBox, @NotNull ByteBuffer byteBuffer) {
        byteBuffer.putInt(lodBlockBoundingBox.getData());
    }

    private static LodBlockBoundingBox deserializeLodBlockBoundingBox(@NotNull ByteBuffer byteBuffer) {
        return LodBlockBoundingBox.Companion.createVSBoundingBoxFromData(byteBuffer.getInt());
    }

    private static void serializeCollisionPoints(@NotNull List<CollisionPoint> collisionPoints, @NotNull ByteBuffer byteBuffer) {
        byteBuffer.putInt(collisionPoints.size());
        for (CollisionPoint collisionPoint : collisionPoints) {
            Lod1BlockStateSerializer.serializeCollisionPoint(collisionPoint, byteBuffer);
        }
    }

    private static List<CollisionPoint> deserializeCollisionPoints(@NotNull ByteBuffer byteBuffer) {
        int size = byteBuffer.getInt();
        ArrayList<CollisionPoint> toReturn = new ArrayList<CollisionPoint>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            toReturn.add(Lod1BlockStateSerializer.deserializeCollisionPoint(byteBuffer));
        }
        return toReturn;
    }

    private static void serializeCollisionPoint(@NotNull CollisionPoint collisionPoint, @NotNull ByteBuffer byteBuffer) {
        Lod1BlockStateSerializer.serializeVector3f(collisionPoint.getPos(), byteBuffer);
        byteBuffer.putFloat(collisionPoint.getRadius());
    }

    private static CollisionPoint deserializeCollisionPoint(@NotNull ByteBuffer byteBuffer) {
        Vector3f pos = Lod1BlockStateSerializer.deserializeVector3f(byteBuffer);
        float radius = byteBuffer.getFloat();
        return new CollisionPoint(pos, radius);
    }

    private static void serializeVector3f(@NotNull Vector3fc vector3fc, @NotNull ByteBuffer byteBuffer) {
        byteBuffer.putFloat(vector3fc.x());
        byteBuffer.putFloat(vector3fc.y());
        byteBuffer.putFloat(vector3fc.z());
    }

    private static Vector3f deserializeVector3f(@NotNull ByteBuffer byteBuffer) {
        float x2 = byteBuffer.getFloat();
        float y2 = byteBuffer.getFloat();
        float z2 = byteBuffer.getFloat();
        return new Vector3f(x2, y2, z2);
    }
}

