/*
 * Decompiled with CFR 0.152.
 */
package sys.exe.al;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import com.mojang.brigadier.CommandDispatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_702;
import net.minecraft.class_7157;
import net.minecraft.class_743;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import net.minecraft.class_9636;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sys.exe.al.ALAutoTrade;
import sys.exe.al.ALGoal;
import sys.exe.al.ALState;
import sys.exe.al.DummyInput;
import sys.exe.al.commands.AutoLec;
import sys.exe.al.commands.ClientCommandManager;

public class AutoLectern
implements ClientModInitializer {
    private static AutoLectern INSTANCE;
    public static final Logger LOGGER;
    public ALAutoTrade autoTrade;
    public boolean itemSync;
    public boolean breakCooldown;
    public boolean logTrade;
    public boolean preBreaking;
    public boolean preserveTool;
    public int attempts;
    private int UUID;
    private int signals;
    private int lastGoalMet;
    private int prevSelectedSlot;
    private class_2338 lecternPos;
    private class_2350 lecternSide;
    private ALState curState;
    private int tickCoolDown;
    private class_1646 updatedVillager;
    private ArrayList<ALGoal> goals;
    private File configFile;
    private float fakePitch;
    private float fakeYaw;
    private class_243 forcedPos;
    public static final int SIGNAL_PROF = 1;
    public static final int SIGNAL_TRADE = 2;
    public static final int SIGNAL_TRADE_OK = 4;
    public static final int SIGNAL_ITEM = 8;

    public static AutoLectern getInstance() {
        return INSTANCE;
    }

    public void signal(int signalType) {
        this.signals |= signalType;
    }

    public int getUUID() {
        return this.UUID;
    }

    public void incrementUUID() {
        ++this.UUID;
    }

    public ArrayList<ALGoal> getGoals() {
        return this.goals;
    }

    public static int getMostExpensiveVillagerEnchant(class_6880<class_1887> enchant) {
        int k = ((class_1887)enchant.comp_349()).method_8183();
        int minPrice = k * 3 + 2 + (4 + k * 10);
        if (enchant.method_40220(class_9636.field_51546)) {
            minPrice *= 2;
        }
        return minPrice > 64 ? 64 : minPrice;
    }

    public static int getCheapestVillagerEnchant(class_6880<class_1887> enchant) {
        int minPrice = ((class_1887)enchant.comp_349()).method_8183() * 3 + 2;
        if (enchant.method_40220(class_9636.field_51546)) {
            minPrice *= 2;
        }
        return minPrice > 64 ? 64 : minPrice;
    }

    private boolean isGoalLevelMet(int maxEncLvl, int lvlMin, int lvlMax, int lvl) {
        if (lvlMin == -1) {
            if (lvlMax == -1) {
                return true;
            }
            return lvl <= 1;
        }
        if (lvlMax == -1) {
            return lvl >= maxEncLvl;
        }
        return lvl >= lvlMin && lvl <= lvlMax;
    }

    private boolean isGoalPriceMet(class_6880<class_1887> enchant, int priceMin, int priceMax, int price) {
        if (priceMin == -1) {
            if (priceMax == -1) {
                return true;
            }
            return price <= AutoLectern.getCheapestVillagerEnchant(enchant);
        }
        if (priceMax == -1) {
            return price >= AutoLectern.getMostExpensiveVillagerEnchant(enchant);
        }
        return price >= priceMin && price <= priceMax;
    }

    @Nullable
    public static class_6880<class_1887> enchantFromIdentifier(class_1937 world, class_2960 id) {
        class_2378 enchants = world.method_30349().method_30530(class_7924.field_41265);
        class_1887 enchant = (class_1887)enchants.method_63535(id);
        if (enchant == null) {
            return null;
        }
        return enchants.method_47983((Object)enchant);
    }

    public int getGoalMet(class_1937 world, int price, class_2960 enchant, int lvl) {
        int idx = 0;
        for (ALGoal curGoal : this.goals) {
            class_6880<class_1887> enc;
            class_2960 enc_id = curGoal.enchant();
            if (enc_id == null || (enc = AutoLectern.enchantFromIdentifier(world, enc_id)) == null) continue;
            if (enchant.equals((Object)enc_id) && this.isGoalLevelMet(((class_1887)enc.comp_349()).method_8183(), curGoal.lvlMin(), curGoal.lvlMax(), lvl) && this.isGoalPriceMet(enc, curGoal.priceMin(), curGoal.priceMax(), price)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public final class_1646 getUpdatedVillager() {
        return this.updatedVillager;
    }

    public void setUpdatedVillager(class_1646 updatedVillager) {
        this.updatedVillager = updatedVillager;
    }

    public final ALState getState() {
        return this.curState;
    }

    public void setState(ALState newState) {
        this.curState = newState;
    }

    public class_2338 getLecternPos() {
        return this.lecternPos;
    }

    private static boolean toolNearBreak(class_1799 tool) {
        return tool.method_7963() && tool.method_7919() + 2 >= tool.method_7936();
    }

    private boolean equipWorkingTool(@NotNull class_746 plr) {
        class_1661 inventory = plr.method_31548();
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!(stack.method_7909() instanceof class_1743) || AutoLectern.toolNearBreak(stack)) continue;
            inventory.method_61496(i);
            return true;
        }
        return false;
    }

    private boolean checkPreserveTool(@NotNull class_746 plr) {
        class_1799 tool = plr.method_6047();
        if (!AutoLectern.toolNearBreak(tool)) {
            return false;
        }
        if (this.equipWorkingTool(plr)) {
            return false;
        }
        this.curState = ALState.STOPPING;
        return true;
    }

    @Nullable
    private class_3965 getLookingAt(class_746 plr) {
        float oldPitch = plr.method_36455();
        float oldYaw = plr.method_36454();
        plr.method_36457(this.fakePitch);
        plr.method_36456(this.fakeYaw);
        class_239 hitResult = plr.method_5745(4.5, 0.0f, false);
        plr.method_36457(oldPitch);
        plr.method_36456(oldYaw);
        if (hitResult.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        return (class_3965)hitResult;
    }

    @Nullable
    private class_1268 equipLectern(class_746 plr) {
        if (plr.method_6079().method_31574(class_1802.field_16312)) {
            return class_1268.field_5810;
        }
        if (plr.method_6047().method_31574(class_1802.field_16312)) {
            return class_1268.field_5808;
        }
        class_1661 plrInv = plr.method_31548();
        int idx = 0;
        for (class_1799 itmStk : plrInv.method_67533()) {
            if (itmStk.method_7909() != class_1802.field_16312) {
                ++idx;
                continue;
            }
            if (!class_1661.method_7380((int)idx)) break;
            this.prevSelectedSlot = plrInv.method_67532();
            plrInv.method_61496(idx);
            return class_1268.field_5808;
        }
        return null;
    }

    private void preBreak(class_746 plr, @Nullable class_636 interactionManager, @Nullable class_702 partMan) {
        if (this.prevSelectedSlot != -1) {
            plr.method_31548().method_61496(this.prevSelectedSlot);
            this.prevSelectedSlot = -1;
        }
        if (this.preserveTool) {
            this.checkPreserveTool(plr);
        } else if (plr.method_6047().method_7960()) {
            this.equipWorkingTool(plr);
        }
        if (partMan != null) {
            partMan.method_3054(this.lecternPos, this.lecternSide);
        }
        if (interactionManager == null) {
            return;
        }
        interactionManager.method_2902(this.lecternPos, this.lecternSide);
        plr.method_6104(class_1268.field_5808);
    }

    public void MinecraftTickHead(class_310 mc) {
        if (this.curState == ALState.STOPPED) {
            return;
        }
        class_746 plr = mc.field_1724;
        if (plr == null || !(plr.field_7512 instanceof class_1723)) {
            this.curState = ALState.STOPPING;
        }
        while (true) {
            switch (this.curState) {
                case STOPPING: {
                    class_638 world;
                    if (plr != null && (world = mc.field_1687) != null) {
                        if (this.lecternPos != null) {
                            plr.field_3944.method_52787((class_2596)new class_2846(class_2846.class_2847.field_12971, this.lecternPos, this.lecternSide));
                            world.method_8517(plr.method_5628(), this.lecternPos, -1);
                        }
                        plr.field_3913 = new class_743(mc.field_1690);
                    }
                    this.forcedPos = null;
                    this.prevSelectedSlot = -1;
                    this.signals = 0;
                    this.lecternPos = null;
                    this.lecternSide = null;
                    this.updatedVillager = null;
                    mc.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"[Auto Lectern] ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)"Stopped.").method_27692(class_124.field_1061)));
                    this.curState = ALState.STOPPED;
                    return;
                }
                case STARTING: {
                    class_3965 blockHitResult;
                    this.attempts = 0;
                    this.prevSelectedSlot = -1;
                    this.signals = 0;
                    this.updatedVillager = null;
                    class_638 world = mc.field_1687;
                    if (world == null) {
                        this.curState = ALState.STOPPING;
                        break;
                    }
                    class_239 crosshairTarget = mc.field_1765;
                    if (!(crosshairTarget instanceof class_3965) || world.method_8320((blockHitResult = (class_3965)crosshairTarget).method_17777()).method_26204() != class_2246.field_16330) {
                        mc.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"[Auto Lectern] ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)"Please look at a lectern before running this command.").method_27692(class_124.field_1061)));
                        this.curState = ALState.STOPPING;
                        break;
                    }
                    plr.field_3913 = new DummyInput();
                    this.fakePitch = plr.method_36455();
                    this.fakeYaw = plr.method_36454();
                    this.forcedPos = plr.method_19538();
                    this.lecternPos = blockHitResult.method_17777();
                    this.lecternSide = blockHitResult.method_17780();
                    this.curState = ALState.BREAKING;
                    break;
                }
                case BREAKING: {
                    class_702 partMan;
                    class_636 interactionManager;
                    class_638 world = mc.field_1687;
                    if (world == null || (interactionManager = mc.field_1761) == null) {
                        this.curState = ALState.STOPPING;
                        break;
                    }
                    plr.method_5784(class_1313.field_6308, new class_243(this.forcedPos.method_10216() - plr.method_23317(), -1.0E-5, this.forcedPos.method_10215() - plr.method_23321()));
                    if (this.prevSelectedSlot != -1) {
                        plr.method_31548().method_61496(this.prevSelectedSlot);
                        this.prevSelectedSlot = -1;
                    }
                    if (this.preserveTool) {
                        if (this.checkPreserveTool(plr)) {
                            break;
                        }
                    } else if (plr.method_6047().method_7960()) {
                        this.equipWorkingTool(plr);
                    }
                    if ((partMan = mc.field_1713) != null) {
                        partMan.method_3054(this.lecternPos, this.lecternSide);
                    }
                    interactionManager.method_2902(this.lecternPos, this.lecternSide);
                    plr.method_6104(class_1268.field_5808);
                    if (world.method_8320(this.lecternPos).method_26215()) {
                        this.curState = this.itemSync ? ALState.WAITING_ITEM : ALState.PLACING;
                        return;
                    }
                    return;
                }
                case WAITING_ITEM: {
                    plr.method_5784(class_1313.field_6308, new class_243(this.forcedPos.method_10216() - plr.method_23317(), -1.0E-5, this.forcedPos.method_10215() - plr.method_23321()));
                    if ((this.signals & 8) != 0) {
                        this.curState = ALState.PLACING;
                        break;
                    }
                    return;
                }
                case PLACING: {
                    class_1269.class_9860 successActionResult;
                    class_1269 actionResult;
                    class_636 interactionManager;
                    class_638 world = mc.field_1687;
                    if (world == null) {
                        this.curState = ALState.STOPPING;
                        break;
                    }
                    if (world.method_8320(this.lecternPos).method_27852(class_2246.field_16330)) {
                        this.updatedVillager = null;
                        this.tickCoolDown = 40;
                        this.signals = 0;
                        this.curState = ALState.WAITING_PROF;
                    }
                    if ((interactionManager = mc.field_1761) == null) {
                        this.curState = ALState.STOPPING;
                        break;
                    }
                    class_3965 blockHitResult = this.getLookingAt(plr);
                    if (blockHitResult == null) {
                        this.curState = ALState.STOPPING;
                        break;
                    }
                    class_1268 lecternHand = this.equipLectern(plr);
                    if (lecternHand != null && (actionResult = interactionManager.method_2896(plr, lecternHand, blockHitResult)) instanceof class_1269.class_9860 && (successActionResult = (class_1269.class_9860)actionResult).comp_2909() == class_1269.class_9861.field_52427) {
                        plr.method_6104(lecternHand);
                    }
                    if (!world.method_8320(this.lecternPos).method_27852(class_2246.field_16330)) {
                        return;
                    }
                    this.updatedVillager = null;
                    this.tickCoolDown = 40;
                    this.signals = 0;
                    this.curState = ALState.WAITING_PROF;
                    break;
                }
                case WAITING_PROF: {
                    class_638 world;
                    if ((this.signals & 1) == 0) {
                        plr.method_5784(class_1313.field_6308, new class_243(this.forcedPos.method_10216() - plr.method_23317(), -1.0E-5, this.forcedPos.method_10215() - plr.method_23321()));
                        world = mc.field_1687;
                        if (world == null) {
                            this.curState = ALState.STOPPING;
                            break;
                        }
                        class_2680 blkState = world.method_8320(this.lecternPos);
                        if (blkState.method_26215()) {
                            this.curState = ALState.PLACING;
                            break;
                        }
                        if (blkState.method_26204() != class_2246.field_16330) {
                            this.curState = ALState.BREAKING;
                            break;
                        }
                        if (this.tickCoolDown > 0) {
                            if (this.preBreaking) {
                                this.preBreak(plr, mc.field_1761, mc.field_1713);
                            }
                            --this.tickCoolDown;
                            return;
                        }
                        this.curState = ALState.BREAKING;
                        break;
                    }
                    this.curState = ALState.INTERACT_VIL;
                    break;
                }
                case INTERACT_VIL: {
                    class_1269.class_9860 successActionResult;
                    if (this.updatedVillager == null) {
                        this.curState = ALState.STOPPING;
                        break;
                    }
                    class_636 interactionManager = mc.field_1761;
                    if (interactionManager == null) {
                        this.curState = ALState.STOPPING;
                        break;
                    }
                    this.tickCoolDown = 5;
                    this.signals = 0;
                    this.curState = ALState.WAITING_TRADE;
                    class_1269 actionResult = interactionManager.method_2905((class_1657)plr, (class_1297)this.updatedVillager, class_1268.field_5808);
                    if (!(actionResult instanceof class_1269.class_9860) || (successActionResult = (class_1269.class_9860)actionResult).comp_2909() != class_1269.class_9861.field_52427) break;
                    plr.method_6104(class_1268.field_5808);
                    break;
                }
                case WAITING_TRADE: {
                    if ((this.signals & 2) != 0) {
                        if ((this.signals & 4) == 0) {
                            this.curState = ALState.BREAKING;
                            break;
                        }
                        mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14627, (float)1.0f));
                        GLFW.glfwRequestWindowAttention((long)mc.method_22683().method_4490());
                        ALGoal goal = this.goals.get(this.lastGoalMet);
                        assert (mc.field_1687 != null);
                        mc.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"[Auto Lectern] ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)"Goal met: ").method_27692(class_124.field_1068)).method_10852((class_2561)((class_1887)Objects.requireNonNull(AutoLectern.enchantFromIdentifier((class_1937)mc.field_1687, goal.enchant())).comp_349()).comp_2686().method_27661().method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" [REMOVE]").method_10862(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10609("/autolec remove " + this.lastGoalMet + " " + this.getUUID()))).method_27692(class_124.field_1061)));
                        mc.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"[Auto Lectern] ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)"Completed.").method_27692(class_124.field_1060)));
                        this.curState = ALState.STOPPING;
                        break;
                    }
                    plr.method_5784(class_1313.field_6308, new class_243(this.forcedPos.method_10216() - plr.method_23317(), -1.0E-5, this.forcedPos.method_10215() - plr.method_23321()));
                    if (this.tickCoolDown > 0) {
                        if (this.preBreaking) {
                            this.preBreak(plr, mc.field_1761, mc.field_1713);
                        }
                        --this.tickCoolDown;
                        return;
                    }
                    this.curState = ALState.INTERACT_VIL;
                }
            }
        }
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        ClientCommandManager.clearClientSideCommands();
        AutoLec.register(dispatcher, registryAccess);
    }

    public void saveConfig() {
        LOGGER.info("Saving config...");
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile), StandardCharsets.UTF_8));){
            pw.write("itemSync=");
            pw.write(this.itemSync ? "true\n" : "false\n");
            pw.write("breakCooldown=");
            pw.write(this.breakCooldown ? "true\n" : "false\n");
            pw.write("logTrade=");
            pw.write(this.logTrade ? "true\n" : "false\n");
            pw.write("preBreaking=");
            pw.write(this.preBreaking ? "true\n" : "false\n");
            pw.write("preserveTool=");
            pw.write(this.preserveTool ? "true\n" : "false\n");
            pw.write("autoTrade=");
            pw.write(this.autoTrade.name());
            pw.write(10);
            pw.write("goals=");
            for (ALGoal goal : this.goals) {
                pw.write(goal.enchant().toString());
                pw.write(44);
                pw.print(goal.lvlMin());
                pw.write(44);
                pw.print(goal.lvlMax());
                pw.write(44);
                pw.print(goal.priceMin());
                pw.write(44);
                pw.print(goal.priceMax());
                pw.write(59);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save config.", (Throwable)exception);
            return;
        }
        LOGGER.info("Config saved!");
    }

    public void onInitializeClient() {
        LOGGER.info("Loading...");
        this.configFile = FabricLoader.getInstance().getConfigDir().resolve("autolec.txt").toFile();
        this.breakCooldown = false;
        this.itemSync = false;
        this.preserveTool = true;
        this.logTrade = false;
        this.preBreaking = true;
        this.autoTrade = ALAutoTrade.OFF;
        this.goals = new ArrayList();
        try (BufferedReader bufferedReader = Files.newReader((File)this.configFile, (Charset)Charsets.UTF_8);){
            Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);
            Iterator lineIt = bufferedReader.lines().iterator();
            while (lineIt.hasNext()) {
                String line = (String)lineIt.next();
                try {
                    Iterator eIt = EQUAL_SPLITTER.split((CharSequence)line).iterator();
                    String key = (String)eIt.next();
                    String value = (String)eIt.next();
                    switch (key) {
                        case "breakCooldown": {
                            this.breakCooldown = value.equals("true");
                            break;
                        }
                        case "itemSync": {
                            this.itemSync = value.equals("true");
                            break;
                        }
                        case "preserveTool": {
                            this.preserveTool = value.equals("true");
                            break;
                        }
                        case "logTrade": {
                            this.logTrade = value.equals("true");
                            break;
                        }
                        case "preBreak": {
                            this.preBreaking = value.equals("true");
                            break;
                        }
                        case "autoTrade": {
                            this.autoTrade = value.equals("ENCHANT") ? ALAutoTrade.ENCHANT : (value.equals("CHEAPEST") ? ALAutoTrade.CHEAPEST : ALAutoTrade.OFF);
                            break;
                        }
                        case "goals": {
                            Iterator gIt = Splitter.on((char)';').split((CharSequence)value).iterator();
                            Splitter COMMA_SPLITTER = Splitter.on((char)',');
                            while (gIt.hasNext()) {
                                String goalData = (String)gIt.next();
                                if (goalData.isEmpty()) continue;
                                Iterator gdIt = COMMA_SPLITTER.split((CharSequence)goalData).iterator();
                                this.goals.add(new ALGoal(class_2960.method_60654((String)((String)gdIt.next())), Integer.parseInt((String)gdIt.next()), Integer.parseInt((String)gdIt.next()), Integer.parseInt((String)gdIt.next()), Integer.parseInt((String)gdIt.next())));
                            }
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Skipping bad option: {}", (Object)line);
                }
            }
        }
        catch (Exception e) {
            LOGGER.info("Failed to load config.");
        }
        INSTANCE = this;
        this.UUID = 0;
        this.curState = ALState.STOPPED;
        LOGGER.info("Loaded!");
    }

    public float getPitch() {
        return this.fakePitch;
    }

    public float getYaw() {
        return this.fakeYaw;
    }

    public void setLastGoalMet(int lastGoalMet) {
        this.lastGoalMet = lastGoalMet;
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"Auto Lectern");
    }
}

