/*
 * Decompiled with CFR 0.152.
 */
package net.tutla.manhuntPlus;

import java.util.Random;
import java.util.UUID;
import net.tutla.manhuntPlus.ManhuntPlus;
import net.tutla.manhuntPlus.TwistsHelper;
import net.tutla.manhuntPlus.lootpool.LootPool;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class EventListeners
implements Listener {
    private static TwistsHelper helper;

    public EventListeners(TwistsHelper helper) {
        EventListeners.helper = helper;
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (ManhuntPlus.getInstance().getPlayingSpeedrunners().contains(player.getUniqueId())) {
            Bukkit.broadcastMessage((String)("Speedrunner " + player.getName() + " has been eliminated"));
            ManhuntPlus.getInstance().removePlayingSpeedrunner(player);
            if (ManhuntPlus.getInstance().getPlayingSpeedrunners().isEmpty()) {
                Bukkit.broadcastMessage((String)"\u00a7aHunter(s) have won the Manhunt!");
                ManhuntPlus.getInstance().stopManhunt();
            }
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntityType() == EntityType.PIG) {
            if (ManhuntPlus.getInstance().getTwist() != ManhuntPlus.Twist.PIG_OP_LOOT) {
                return;
            }
            Player killer = event.getEntity().getKiller();
            if (killer == null) {
                return;
            }
            if (!ManhuntPlus.getInstance().getPlayingSpeedrunners().contains(killer.getUniqueId())) {
                return;
            }
            event.getDrops().clear();
            LootPool pool = ManhuntPlus.getInstance().getDefaultLoot();
            for (int i = 0; i < 2 + new Random().nextInt(3); ++i) {
                ItemStack drop = pool.getRandomLoot();
                if (drop == null) continue;
                event.getDrops().add(drop);
            }
        } else if (event.getEntityType() == EntityType.ENDER_DRAGON && ManhuntPlus.getInstance().getStatus().booleanValue() && !ManhuntPlus.getInstance().getPlayingSpeedrunners().isEmpty()) {
            Bukkit.broadcastMessage((String)"\u00a7aSpeedrunner(s) have won the Manhunt!");
            ManhuntPlus.getInstance().stopManhunt();
        }
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Material.COMPASS) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof CompassMeta)) {
            return;
        }
        CompassMeta meta = (CompassMeta)itemMeta;
        String id = (String)meta.getPersistentDataContainer().get(ManhuntPlus.COMPASS_ID_KEY, PersistentDataType.STRING);
        if (id == null) {
            return;
        }
        UUID compassId = UUID.fromString(id);
        Player target = ManhuntPlus.getInstance().getTrackedCompasses().get(compassId);
        ManhuntPlus.updateCompass(item, compassId, target);
        event.getPlayer().sendMessage("\u00a7aCompass calibrated to " + target.getName());
    }

    @EventHandler
    public void onPlayerConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item.getType() == Material.MILK_BUCKET) {
            Player target;
            String uuid;
            ItemMeta meta = item.getItemMeta();
            NamespacedKey key = new NamespacedKey((Plugin)ManhuntPlus.getInstance(), "milked_from");
            if (meta != null && meta.getPersistentDataContainer().has(key, PersistentDataType.STRING) && (uuid = (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING)) != null && (target = Bukkit.getPlayer((UUID)UUID.fromString(uuid))) != null) {
                helper.tortureHunter(target);
            }
        }
    }

    @EventHandler
    public void onHit(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player hitter = (Player)event.getDamager();
        Player victim = (Player)event.getEntity();
        if (ManhuntPlus.getInstance().getSpeedrunners().contains(hitter.getUniqueId()) && ManhuntPlus.getInstance().getHunters().contains(victim.getUniqueId()) && ManhuntPlus.getInstance().waitingForStart.booleanValue()) {
            ManhuntPlus.getInstance().startManhunt();
        }
    }
}

