/*
 * Decompiled with CFR 0.152.
 */
package net.tutla.manhuntPlus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import net.tutla.manhuntPlus.EventListeners;
import net.tutla.manhuntPlus.TwistsHelper;
import net.tutla.manhuntPlus.lootpool.LevellingFactory;
import net.tutla.manhuntPlus.lootpool.LootPool;
import net.tutla.manhuntPlus.lootpool.LootPoolLevelling;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public final class ManhuntPlus
extends JavaPlugin {
    private static ManhuntPlus instance;
    private Boolean started = false;
    public Boolean waitingForStart = false;
    public static final NamespacedKey COMPASS_ID_KEY;
    private final List<UUID> speedrunners = new ArrayList<UUID>();
    private final List<UUID> playingSpeedrunners = new ArrayList<UUID>();
    private final List<UUID> hunters = new ArrayList<UUID>();
    private Twist twist = Twist.DEFAULT;
    private int timer = 0;
    private int timerTaskId = -1;
    private int countdownLimitMinutes = 0;
    Map<UUID, Player> trackedCompasses = new HashMap<UUID, Player>();
    public static Map<UUID, LootPoolLevelling> playerLootPoolLevels;
    private static LootPool basicLootPool;

    public static void updateCompass(ItemStack item, UUID compassId, Player target) {
        if (item == null || item.getType() != Material.COMPASS) {
            return;
        }
        CompassMeta meta = (CompassMeta)item.getItemMeta();
        if (meta == null) {
            return;
        }
        String id = (String)meta.getPersistentDataContainer().get(COMPASS_ID_KEY, PersistentDataType.STRING);
        if (id != null && id.equals(compassId.toString()) && !target.isSneaking()) {
            meta.setLodestone(target.getLocation());
            meta.setLodestoneTracked(false);
            item.setItemMeta((ItemMeta)meta);
        }
    }

    public static LootPoolLevelling addPlayerLevellingLootPool(Player player) {
        LootPoolLevelling levelling = new LootPoolLevelling(LevellingFactory.createAllTiers(), 1.25);
        playerLootPoolLevels.put(player.getUniqueId(), levelling);
        return levelling;
    }

    public static void giveLootToLeveller(Player player) {
        LootPoolLevelling pool = playerLootPoolLevels.get(player.getUniqueId());
        if (pool == null) {
            pool = ManhuntPlus.addPlayerLevellingLootPool(player);
        }
        ItemStack loot = pool.getLoot();
        player.getInventory().addItem(new ItemStack[]{loot});
    }

    public static ManhuntPlus getInstance() {
        return instance;
    }

    public Boolean getStatus() {
        return this.started;
    }

    public void setStatus(Boolean stat) {
        this.started = stat;
    }

    public Map<UUID, Player> getTrackedCompasses() {
        return this.trackedCompasses;
    }

    public List<UUID> getPlayingSpeedrunners() {
        return this.playingSpeedrunners;
    }

    public List<UUID> getSpeedrunners() {
        return this.speedrunners;
    }

    public List<UUID> getHunters() {
        return this.hunters;
    }

    public void addSpeedrunner(Player player) {
        if (!this.speedrunners.contains(player.getUniqueId())) {
            this.speedrunners.add(player.getUniqueId());
        }
    }

    public void removeSpeedrunner(Player player) {
        if (this.speedrunners.contains(player.getUniqueId())) {
            this.speedrunners.remove(player.getUniqueId());
        }
    }

    public void removePlayingSpeedrunner(Player player) {
        if (this.playingSpeedrunners.contains(player.getUniqueId())) {
            this.playingSpeedrunners.remove(player.getUniqueId());
        }
    }

    public void addHunter(Player player) {
        if (!this.hunters.contains(player.getUniqueId())) {
            this.hunters.add(player.getUniqueId());
        }
    }

    public void removeHunter(Player player) {
        this.hunters.remove(player.getUniqueId());
    }

    public Twist getTwist() {
        return this.twist;
    }

    public void setTwist(Twist twist) {
        this.twist = twist;
    }

    public LootPool getDefaultLoot() {
        return basicLootPool;
    }

    public void startTimer() {
        if (this.timerTaskId != -1) {
            return;
        }
        this.timer = 0;
        this.timerTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            ++this.timer;
            if (this.timer % this.getConfig().getInt("broadcast-time-every") == 0 && this.getConfig().getBoolean("broadcast-time")) {
                Bukkit.broadcastMessage((String)("\u00a7eManhunt Timer: " + this.timer / 60 + " minute(s)"));
            }
            if (this.countdownLimitMinutes > 0 && this.timer >= this.countdownLimitMinutes * 60) {
                Bukkit.broadcastMessage((String)("\u00a7cTime's up! Speedrunners failed to win in " + this.countdownLimitMinutes + " minutes."));
                this.stopTimer();
            }
        }, 0L, 20L);
    }

    public void stopTimer() {
        if (this.timerTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.timerTaskId);
            this.timerTaskId = -1;
            Bukkit.broadcastMessage((String)("\u00a7cManhunt stopped at " + this.timer / 60 + " minute(s)."));
        }
    }

    public Boolean startManhunt() {
        this.waitingForStart = false;
        if (!this.started.booleanValue()) {
            this.setStatus(true);
            this.startTimer();
            Bukkit.broadcastMessage((String)"\u00a7aManhunt started!");
            this.playingSpeedrunners.addAll(this.speedrunners);
            return true;
        }
        return false;
    }

    public Boolean stopManhunt() {
        if (this.started.booleanValue()) {
            this.setStatus(false);
            this.stopTimer();
            this.playingSpeedrunners.clear();
            Bukkit.broadcastMessage((String)"\u00a7aManhunt stopped!");
            return true;
        }
        return false;
    }

    public List<Player> getOpponents(Player player) {
        if (this.hunters.contains(player.getUniqueId())) {
            return this.getPlayers(this.speedrunners);
        }
        if (this.speedrunners.contains(player.getUniqueId())) {
            return this.getPlayers(this.hunters);
        }
        return Collections.emptyList();
    }

    public List<Player> getPlayers(List<UUID> players) {
        ArrayList<Player> e = new ArrayList<Player>();
        for (UUID p : players) {
            e.add(Bukkit.getPlayer((UUID)p));
        }
        return e;
    }

    public void giveCompass(Player target, Player player) {
        if (!this.playingSpeedrunners.contains(target.getUniqueId())) {
            player.sendMessage("\u00a7cPlayer is not a playing speedrunner!");
            return;
        }
        if (target.isOnline()) {
            ItemStack compass = new ItemStack(Material.COMPASS);
            CompassMeta meta = (CompassMeta)compass.getItemMeta();
            if (meta != null) {
                Location loc = target.getLocation();
                meta.setLodestone(loc);
                meta.setLodestoneTracked(false);
                UUID compassId = UUID.randomUUID();
                meta.getPersistentDataContainer().set(COMPASS_ID_KEY, PersistentDataType.STRING, (Object)compassId.toString());
                if (this.getConfig().getBoolean("name-tracking-compass")) {
                    meta.setDisplayName("\u00a7bTracking \u00a7e" + target.getName());
                }
                compass.setItemMeta((ItemMeta)meta);
                this.trackedCompasses.put(compassId, target);
            }
            player.getInventory().addItem(new ItemStack[]{compass});
            player.sendMessage("\u00a7bTracking compass given for speedrunner " + target.getName());
        } else {
            player.sendMessage("\u00a7cPlayer is not online");
        }
    }

    public void onEnable() {
        instance = this;
        basicLootPool = LootPool.createDefault();
        TwistsHelper helper = new TwistsHelper();
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)new EventListeners(helper), (Plugin)this);
        this.getLogger().info("Manhunt plugin loaded!");
        new BukkitRunnable(){

            public void run() {
                if (ManhuntPlus.this.getConfig().getBoolean("auto-calibration")) {
                    Iterator<Map.Entry<UUID, Player>> itr = ManhuntPlus.this.trackedCompasses.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry<UUID, Player> entry = itr.next();
                        UUID compassId = entry.getKey();
                        Player target = entry.getValue();
                        if (target == null || !target.isOnline()) {
                            itr.remove();
                            continue;
                        }
                        for (Player p : Bukkit.getOnlinePlayers()) {
                            for (ItemStack item : p.getInventory().getContents()) {
                                ManhuntPlus.updateCompass(item, compassId, target);
                            }
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)this, 0L, this.getConfig().getLong("auto-calibration-interval") * 20L);
    }

    public void onDisable() {
        this.getLogger().info("Bye :(");
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (cmd.getName().equalsIgnoreCase("compass")) {
            if (this.speedrunners.isEmpty()) {
                player.sendMessage("\u00a7cNo speedrunner set.");
                return true;
            }
            Player target = args.length >= 1 ? Bukkit.getPlayer((String)args[0]) : Bukkit.getPlayer((UUID)this.speedrunners.getFirst());
            if (target != null) {
                this.giveCompass(target, player);
            } else {
                player.sendMessage("\u00a7cPlayer not found");
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("speedrunner")) {
            if (args.length == 2) {
                if (args[0].equalsIgnoreCase("add")) {
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (this.hunters.contains(target.getUniqueId())) {
                        player.sendMessage("\u00a7cPlayer is a hunter!");
                        return true;
                    }
                    if (target != null && target.isOnline()) {
                        if (!this.speedrunners.contains(target.getUniqueId())) {
                            this.addSpeedrunner(target);
                            Bukkit.broadcastMessage((String)("\u00a7a" + target.getName() + " is now a speedrunner!"));
                        } else {
                            player.sendMessage("\u00a7cPlayer is already a speedrunner!");
                        }
                    } else {
                        player.sendMessage("\u00a7cPlayer not found or not online.");
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("remove")) {
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (target != null && target.isOnline()) {
                        if (this.speedrunners.contains(target.getUniqueId())) {
                            this.removeSpeedrunner(target);
                            Bukkit.broadcastMessage((String)("\u00a7a" + target.getName() + " is no longer a speedrunner!"));
                        } else {
                            player.sendMessage("\u00a7cPlayer is not a speedrunner!");
                        }
                    } else {
                        player.sendMessage("\u00a7cPlayer not found or not online.");
                    }
                    return true;
                }
            }
            return false;
        }
        if (cmd.getName().equalsIgnoreCase("hunter")) {
            if (args.length == 2) {
                if (args[0].equalsIgnoreCase("add")) {
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (this.speedrunners.contains(target.getUniqueId())) {
                        player.sendMessage("\u00a7cPlayer is a speedrunner!");
                        return true;
                    }
                    if (target != null && target.isOnline()) {
                        if (!this.hunters.contains(target.getUniqueId())) {
                            this.addHunter(target);
                            Bukkit.broadcastMessage((String)("\u00a7a" + target.getName() + " is now a hunter!"));
                        } else {
                            player.sendMessage("\u00a7cPlayer is already a hunter!");
                        }
                    } else {
                        player.sendMessage("\u00a7cPlayer not found or not online.");
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("remove")) {
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (target != null && target.isOnline()) {
                        if (this.hunters.contains(target.getUniqueId())) {
                            this.removeHunter(target);
                            Bukkit.broadcastMessage((String)("\u00a7a" + target.getName() + " is no longer a hunter!"));
                        } else {
                            player.sendMessage("\u00a7cPlayer is not a hunter!");
                        }
                    } else {
                        player.sendMessage("\u00a7cPlayer not found or not online.");
                    }
                    return true;
                }
            }
            return false;
        }
        if (cmd.getName().equalsIgnoreCase("twist")) {
            if (args.length == 1) {
                try {
                    Twist selected = Twist.valueOf(args[0].toUpperCase());
                    this.setTwist(selected);
                    player.sendMessage("\u00a7aTwist set to: " + selected.name());
                }
                catch (IllegalArgumentException e) {
                    player.sendMessage("\u00a7cUnknown twist: " + args[0]);
                    player.sendMessage("\u00a7eAvailable twists: " + Arrays.toString((Object[])Twist.values()));
                }
                return true;
            }
            player.sendMessage("\u00a7eCurrent Twist is " + String.valueOf((Object)this.twist));
            player.sendMessage("\u00a7eUsage: /twist <twistName>");
        } else {
            if (cmd.getName().equalsIgnoreCase("manhunt")) {
                if (args.length == 0) {
                    player.sendMessage("\u00a7eUsage: /manhunt <start|stop|countdown|prepare|list|help>");
                    return true;
                }
                switch (args[0].toLowerCase()) {
                    case "start": {
                        if (this.startManhunt().booleanValue()) break;
                        player.sendMessage("\u00a7cManhunt already running.");
                        break;
                    }
                    case "stop": {
                        if (this.stopManhunt().booleanValue()) break;
                        player.sendMessage("\u00a7cManhunt is not running.");
                        break;
                    }
                    case "countdown": {
                        if (args.length == 2) {
                            try {
                                int mins;
                                this.countdownLimitMinutes = mins = Integer.parseInt(args[1]);
                                if (mins > 0) {
                                    player.sendMessage("\u00a7aCountdown set to " + mins + " minute(s).");
                                    break;
                                }
                                player.sendMessage("\u00a7eCountdown disabled.");
                            }
                            catch (NumberFormatException e) {
                                player.sendMessage("\u00a7cInvalid number.");
                            }
                            break;
                        }
                        if (this.countdownLimitMinutes > 0) {
                            player.sendMessage("\u00a7eCurrent countdown limit: " + this.countdownLimitMinutes + " minute(s).");
                        } else {
                            player.sendMessage("\u00a7eCountdown is disabled.");
                        }
                        player.sendMessage("\u00a7eUse /manhunt countdown <minutes>, set minutes to 0 to disable");
                        break;
                    }
                    case "help": {
                        player.sendMessage("To use our plugin start adding speedrunners with: /speedrunner add, use /speedrunner remove to remove a speedrunner");
                        player.sendMessage("You can then add the hunters using /hunter add & remove them using /hunter remove");
                        player.sendMessage("To start the manhunt run \u00a7e/manhunt start");
                        player.sendMessage("Manhunt countdown (max limit a manhunt can last in minutes) can be set using \u00a7e/manhunt cooldown");
                        player.sendMessage("Read full documentation on Modrinth/Discord/Website");
                        break;
                    }
                    case "prepare": {
                        this.waitingForStart = true;
                        Bukkit.broadcastMessage((String)"Waiting for speedrunner first hit");
                        break;
                    }
                    case "list": {
                        player.sendMessage("\u00a7eSpeedrunners:");
                        for (UUID id : this.speedrunners) {
                            player.sendMessage(Bukkit.getPlayer((UUID)id).getName());
                        }
                        player.sendMessage("\u00a7eHunters:");
                        for (UUID id : this.hunters) {
                            player.sendMessage(Bukkit.getPlayer((UUID)id).getName());
                        }
                        player.sendMessage("\u00a7ePlaying Speedrunners:");
                        for (UUID id : this.playingSpeedrunners) {
                            player.sendMessage(Bukkit.getPlayer((UUID)id).getName());
                        }
                        break;
                    }
                    default: {
                        player.sendMessage("\u00a7cUnknown subcommand. Use: start, stop, countdown");
                    }
                }
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("surround")) {
                if (this.speedrunners.isEmpty()) {
                    player.sendMessage("\u00a7cNo speedrunner set.");
                    return true;
                }
                if (args.length >= 1) {
                    Player target = Bukkit.getPlayer((String)args[0]);
                    if (target != null && target.isOnline()) {
                        if (!this.speedrunners.contains(target.getUniqueId())) {
                            player.sendMessage("\u00a7cPlayer is not a speedrunner!");
                            return true;
                        }
                        Location center = target.getLocation();
                        double radius = this.getConfig().getDouble("surround-radius");
                        int n = this.hunters.size();
                        for (int i = 0; i < n; ++i) {
                            Player p = Bukkit.getPlayer((UUID)this.hunters.get(i));
                            double angle = Math.PI * 2 * (double)i / (double)n;
                            double xOffset = radius * Math.cos(angle);
                            double zOffset = radius * Math.sin(angle);
                            Location newLoc = center.clone().add(xOffset, 0.0, zOffset);
                            newLoc.setDirection(center.toVector().subtract(newLoc.toVector()));
                            p.teleport(newLoc);
                        }
                        player.sendMessage("\u00a7aSurrounded  " + target.getName());
                    } else {
                        player.sendMessage("\u00a7cPlayer not found or not online");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, Command cmd, @NotNull String label, String @NotNull [] args) {
        if (cmd.getName().equalsIgnoreCase("twist") && args.length == 1) {
            return Arrays.stream(Twist.values()).map(Enum::name).map(String::toLowerCase).filter(name -> name.startsWith(args[0].toLowerCase())).toList();
        }
        if (cmd.getName().equalsIgnoreCase("speedrunner") || cmd.getName().equalsIgnoreCase("hunter")) {
            if (args.length == 1) {
                return Stream.of("add", "remove").filter(o -> o.startsWith(args[0].toLowerCase())).toList();
            }
            if (args.length == 2 && (args[0].equalsIgnoreCase("add") || args[0].equalsIgnoreCase("remove"))) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).toList();
            }
        } else if (cmd.getName().equalsIgnoreCase("manhunt")) {
            if (args.length == 1) {
                return Stream.of("help", "start", "stop", "countdown", "prepare", "list").filter(s -> s.startsWith(args[0].toLowerCase())).toList();
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("countdown")) {
                return List.of("0", "5", "10", "15", "30");
            }
        }
        return Collections.emptyList();
    }

    static {
        COMPASS_ID_KEY = new NamespacedKey("manhuntplus", "feetpics");
        playerLootPoolLevels = new HashMap<UUID, LootPoolLevelling>();
    }

    static enum Twist {
        DEFAULT,
        PIG_OP_LOOT;

    }
}

