/*
 * Decompiled with CFR 0.152.
 */
package net.tutla.manhuntPlus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class TwistsHelper {
    private static final Random random = new Random();

    public void tortureHunter(Player hunter) {
        int choice = random.nextInt(8);
        switch (choice) {
            case 0: {
                hunter.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, 2400, 4));
                break;
            }
            case 1: {
                hunter.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 2400, 4));
                break;
            }
            case 2: {
                hunter.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 1200, 0));
                break;
            }
            case 3: {
                hunter.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 4800, 7));
                break;
            }
            case 4: {
                this.createSinkhole(hunter);
                break;
            }
            case 5: {
                this.launchToSky(hunter);
                break;
            }
            case 6: {
                this.clearHalfInventory(hunter);
                break;
            }
            case 7: {
                hunter.setHealth(10.0);
            }
        }
        hunter.getWorld().playSound(hunter.getLocation(), Sound.ENTITY_ELDER_GUARDIAN_CURSE, 1.0f, 1.0f);
    }

    private void createSinkhole(Player player) {
        Location loc = player.getLocation();
        World world = loc.getWorld();
        if (world == null) {
            return;
        }
        for (int y = loc.getBlockY(); y > loc.getBlockY() - world.getMinHeight() && y >= world.getMinHeight(); --y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    Location blockLoc = loc.clone().add((double)x, (double)(y - loc.getBlockY()), (double)z);
                    world.getBlockAt(blockLoc).setType(Material.AIR);
                }
            }
        }
    }

    private void launchToSky(Player player) {
        player.setVelocity(new Vector(0, 10, 0));
    }

    private void clearHalfInventory(Player player) {
        ItemStack[] contents = player.getInventory().getContents();
        ArrayList<Integer> nonEmptySlots = new ArrayList<Integer>();
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i] == null || contents[i].getType() == Material.AIR) continue;
            nonEmptySlots.add(i);
        }
        Collections.shuffle(nonEmptySlots);
        int itemsToRemove = nonEmptySlots.size() / 2;
        for (int i = 0; i < itemsToRemove; ++i) {
            int slot = (Integer)nonEmptySlots.get(i);
            player.getInventory().setItem(slot, null);
        }
        player.sendMessage("\u00a7cHalf of your inventory has been cleared!");
    }

    public static CardinalDirection getCardinalDirection(Player player) {
        float yaw = player.getLocation().getYaw();
        if ((yaw = (yaw % 360.0f + 360.0f) % 360.0f) >= 45.0f && yaw < 135.0f) {
            return CardinalDirection.EAST;
        }
        if (yaw >= 135.0f && yaw < 225.0f) {
            return CardinalDirection.SOUTH;
        }
        if (yaw >= 225.0f && yaw < 315.0f) {
            return CardinalDirection.WEST;
        }
        return CardinalDirection.NORTH;
    }

    public static enum CardinalDirection {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

