/*
 * Decompiled with CFR 0.152.
 */
package net.tutla.manhuntPlus.lootpool;

import java.util.ArrayList;
import java.util.List;
import net.tutla.manhuntPlus.lootpool.LootPool;
import net.tutla.manhuntPlus.lootpool.LootTier;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class LevellingFactory {
    public static List<LootTier> createAllTiers() {
        ArrayList<LootTier> tiers = new ArrayList<LootTier>();
        tiers.add(new LootTier("basic", LevellingFactory.createBasicPool()));
        tiers.add(new LootTier("iron", LevellingFactory.createIronPool()));
        tiers.add(new LootTier("gold", LevellingFactory.createGoldPool()));
        tiers.add(new LootTier("diamond", LevellingFactory.createDiamondPool()));
        tiers.add(new LootTier("enchanted", LevellingFactory.createEnchantedPool()));
        tiers.add(new LootTier("netherite", LevellingFactory.createNetheritePool()));
        tiers.add(new LootTier("god", LevellingFactory.createGodPool()));
        return tiers;
    }

    private static LootPool createBasicPool() {
        LootPool pool = new LootPool();
        pool.addLoot(new ItemStack(Material.WOODEN_SWORD), 0.4);
        pool.addLoot(new ItemStack(Material.STONE_SWORD), 0.3);
        pool.addLoot(new ItemStack(Material.WOODEN_AXE), 0.2);
        pool.addLoot(new ItemStack(Material.STONE_AXE), 0.2);
        pool.addLoot(new ItemStack(Material.BREAD, 3), 0.6);
        pool.addLoot(new ItemStack(Material.COOKED_BEEF, 3), 0.5);
        pool.addLoot(new ItemStack(Material.BIRCH_BOAT, 1), 0.1);
        return pool;
    }

    private static LootPool createIronPool() {
        LootPool pool = new LootPool();
        pool.addLoot(new ItemStack(Material.IRON_SWORD), 0.4);
        pool.addLoot(new ItemStack(Material.IRON_PICKAXE), 0.2);
        pool.addLoot(new ItemStack(Material.IRON_CHESTPLATE), 0.2);
        pool.addLoot(new ItemStack(Material.IRON_LEGGINGS), 0.2);
        pool.addLoot(new ItemStack(Material.IRON_HELMET), 0.2);
        pool.addLoot(new ItemStack(Material.IRON_BOOTS), 0.2);
        pool.addLoot(new ItemStack(Material.IRON_ORE, 4), 0.2);
        pool.addLoot(new ItemStack(Material.FISHING_ROD), 0.3);
        pool.addLoot(new ItemStack(Material.COOKED_PORKCHOP, 4), 0.5);
        pool.addLoot(new ItemStack(Material.FLINT_AND_STEEL), 0.3);
        pool.addLoot(new ItemStack(Material.CROSSBOW), 0.2);
        pool.addLoot(new ItemStack(Material.ARROW, 16), 0.2);
        return pool;
    }

    private static LootPool createGoldPool() {
        LootPool pool = new LootPool();
        pool.addLoot(new ItemStack(Material.GOLDEN_SWORD), 0.3);
        pool.addLoot(new ItemStack(Material.GOLDEN_AXE), 0.2);
        pool.addLoot(new ItemStack(Material.GOLDEN_HELMET), 0.1);
        pool.addLoot(new ItemStack(Material.GOLDEN_CHESTPLATE), 0.1);
        pool.addLoot(new ItemStack(Material.GOLDEN_LEGGINGS), 0.1);
        pool.addLoot(new ItemStack(Material.GOLDEN_BOOTS), 0.1);
        pool.addLoot(new ItemStack(Material.GOLDEN_APPLE), 0.2);
        pool.addLoot(new ItemStack(Material.GOLD_INGOT, 16), 0.1);
        return pool;
    }

    private static LootPool createDiamondPool() {
        LootPool pool = new LootPool();
        pool.addLoot(LootPool.enchant(new ItemStack(Material.DIAMOND_SWORD)), 0.3);
        pool.addLoot(LootPool.enchant(new ItemStack(Material.DIAMOND_AXE)), 0.2);
        pool.addLoot(LootPool.enchant(new ItemStack(Material.DIAMOND_HELMET)), 0.1);
        pool.addLoot(LootPool.enchant(new ItemStack(Material.DIAMOND_CHESTPLATE)), 0.1);
        pool.addLoot(LootPool.enchant(new ItemStack(Material.DIAMOND_LEGGINGS)), 0.1);
        pool.addLoot(LootPool.enchant(new ItemStack(Material.DIAMOND_BOOTS)), 0.1);
        return pool;
    }

    private static LootPool createEnchantedPool() {
        LootPool pool = new LootPool();
        return pool;
    }

    private static LootPool createNetheritePool() {
        LootPool pool = new LootPool();
        pool.addLoot(new ItemStack(Material.NETHERITE_SWORD), 0.3);
        pool.addLoot(LootPool.enchant(new ItemStack(Material.NETHERITE_AXE)), 0.2);
        pool.addLoot(new ItemStack(Material.NETHERITE_HELMET), 0.1);
        pool.addLoot(new ItemStack(Material.NETHERITE_LEGGINGS), 0.1);
        pool.addLoot(LootPool.enchant(new ItemStack(Material.NETHERITE_BOOTS)), 0.1);
        return pool;
    }

    private static LootPool createGodPool() {
        LootPool pool = new LootPool();
        pool.addLoot(new ItemStack(Material.ENCHANTED_GOLDEN_APPLE), 0.2);
        pool.addLoot(LootPool.enchant(new ItemStack(Material.NETHERITE_SWORD)), 0.3);
        pool.addLoot(LootPool.enchant(new ItemStack(Material.NETHERITE_AXE)), 0.2);
        pool.addLoot(LootPool.enchant(new ItemStack(Material.NETHERITE_HELMET)), 0.1);
        pool.addLoot(LootPool.enchant(new ItemStack(Material.NETHERITE_CHESTPLATE)), 0.1);
        pool.addLoot(LootPool.enchant(new ItemStack(Material.NETHERITE_LEGGINGS)), 0.1);
        pool.addLoot(LootPool.enchant(new ItemStack(Material.NETHERITE_BOOTS)), 0.1);
        pool.addLoot(new ItemStack(Material.OBSIDIAN, 4), 0.1);
        pool.addLoot(new ItemStack(Material.END_CRYSTAL, 4), 0.1);
        pool.addLoot(new ItemStack(Material.TOTEM_OF_UNDYING), 0.1);
        pool.addLoot(new ItemStack(Material.FISHING_ROD), 0.3);
        pool.addLoot(new ItemStack(Material.COOKED_PORKCHOP, 4), 0.2);
        pool.addLoot(new ItemStack(Material.FLINT_AND_STEEL), 0.3);
        pool.addLoot(new ItemStack(Material.CROSSBOW), 0.2);
        pool.addLoot(new ItemStack(Material.ARROW, 16), 0.2);
        return pool;
    }
}

