/*
 * Decompiled with CFR 0.152.
 */
package net.tutla.manhuntPlus.lootpool;

import java.util.List;
import net.tutla.manhuntPlus.lootpool.LootTier;
import org.bukkit.inventory.ItemStack;

public class LootPoolLevelling {
    private final List<LootTier> tiers;
    private int level = 0;
    private int usageCount = 0;
    private final double difficultyMultiplier;

    public LootPoolLevelling(List<LootTier> tiers, double difficultyMultiplier) {
        this.tiers = tiers;
        this.difficultyMultiplier = difficultyMultiplier;
    }

    public ItemStack getLoot() {
        ++this.usageCount;
        int threshold = (int)Math.ceil((double)(this.level + 1) * this.difficultyMultiplier * 5.0);
        if (this.usageCount >= threshold && this.level < this.tiers.size() - 1) {
            ++this.level;
            this.usageCount = 0;
        }
        return this.tiers.get(this.level).getPool().getRandomLoot();
    }

    public int getLevel() {
        return this.level;
    }

    public String getTierName() {
        return this.tiers.get(this.level).getName();
    }

    public void setLevel(int newLevel) {
        if (newLevel >= 0 && newLevel < this.tiers.size()) {
            this.level = newLevel;
        }
    }

    public void reset() {
        this.level = 0;
        this.usageCount = 0;
    }
}

