/*
 * Decompiled with CFR 0.152.
 */
package net.tutla.manhuntPlus.lootpool;

import java.util.ArrayList;
import java.util.List;
import net.tutla.manhuntPlus.lootpool.LootPool;
import net.tutla.manhuntPlus.lootpool.LootPoolLevelling;
import net.tutla.manhuntPlus.lootpool.LootTier;

public class TierBuilder {
    private final List<LootTier> tiers = new ArrayList<LootTier>();

    public TierBuilder addTier(String name, LootPool pool) {
        this.tiers.add(new LootTier(name, pool));
        return this;
    }

    public TierBuilder removeTier(String name) {
        this.tiers.removeIf(t -> t.getName().equalsIgnoreCase(name));
        return this;
    }

    public TierBuilder replaceTier(String name, LootPool newPool) {
        for (int i = 0; i < this.tiers.size(); ++i) {
            if (!this.tiers.get(i).getName().equalsIgnoreCase(name)) continue;
            this.tiers.set(i, new LootTier(name, newPool));
            break;
        }
        return this;
    }

    public LootPoolLevelling build(double difficultyMultiplier) {
        return new LootPoolLevelling(this.tiers, difficultyMultiplier);
    }
}

