/*
 * Decompiled with CFR 0.152.
 */
package me.zacharias.speedometer;

import dev.architectury.platform.Platform;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import me.zacharias.speedometer.SpeedTypes;
import me.zacharias.speedometer.Speedometer;
import speedometer.shaded.org.json.JSONException;
import speedometer.shaded.org.json.JSONObject;

public class Config {
    private static JSONObject config;
    public static final float configVersion = 4.0f;
    private static int counter;
    private static String configPath;
    private static BufferedImage speedometer;
    private static boolean disableVisualSpeedometer;
    public static final String xRegex = "W*w*S*s*\\+*-*\\**/*[0-9]*";
    public static final String yRegex = "H*h*S*s*\\+*-*\\**/*[0-9]*";
    public static final int MIN_IMAGE_SIZE = 10;
    public static final int MAX_IMAGE_SIZE = 200;

    public static void initialize() {
        if (config != null) {
            throw new RuntimeException("Already Initialized");
        }
        configPath = Platform.getConfigFolder().toString() + "/speedometer/config.json";
        File configFile = new File((String)configPath);
        if (!configFile.exists()) {
            try {
                configFile.getParentFile().mkdir();
                configFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            config = new JSONObject();
            Config.defaultValues();
        } else {
            try {
                String tmp;
                BufferedReader in = new BufferedReader(new FileReader(configFile));
                StringBuilder builder = new StringBuilder();
                while ((tmp = in.readLine()) != null) {
                    builder.append(tmp);
                }
                try {
                    config = new JSONObject(builder.toString());
                    Config.validate(config);
                }
                catch (JSONException e) {
                    Config.dump();
                    config = new JSONObject();
                    Config.defaultValues();
                    return;
                }
                Speedometer.LOGGER.info("Loaded config successfully");
                if (config.has("version")) {
                    if (config.getFloat("version") != 4.0f) {
                        if (config.getFloat("version") > 4.0f) {
                            Speedometer.LOGGER.warn("Config version is too new, resting");
                            Config.defaultValues();
                            Config.save();
                        } else if (config.getFloat("version") < 4.0f) {
                            config = new JSONObject();
                            Speedometer.LOGGER.warn("Config version is outdated, resting");
                            Config.defaultValues();
                            Config.save();
                        }
                    }
                } else {
                    config = new JSONObject();
                    Config.defaultValues();
                    Config.save();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void dump() throws IOException {
        File dump = new File(Platform.getConfigFolder().toString() + "/speedometer/config-dump_" + Speedometer.formatMillisToDHMS(System.currentTimeMillis()) + "_.json");
        Speedometer.LOGGER.error("Config is reset due to invalid content, dumping old content to {}", (Object)dump.getPath());
        if (!dump.exists()) {
            dump.createNewFile();
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(dump));
            out.write(config.toString(4));
            out.close();
        }
        catch (IOException ex) {
            Speedometer.LOGGER.error("Failed to create a dump file and write to it.", (Throwable)ex);
            Speedometer.LOGGER.warn("Dump content: \n{{}}", (Object)config.toString());
        }
    }

    private static void validate(JSONObject config) throws JSONException {
        if (config.has("READ_ME!")) {
            config.remove("READ_ME!");
        }
        if (config.has("version") && config.get("version") instanceof Number) {
            float version = config.getFloat("version");
            if (version > 4.0f || version < 4.0f) {
                Config.validationError("Config version is outdated or too new, resetting to default values");
                return;
            }
        } else {
            Config.validationError("Config version is missing or invalid, resetting to default values");
            return;
        }
        if (config.has("speed") && config.get("speed") instanceof String) {
            try {
                SpeedTypes.valueOf(config.getString("speed"));
            }
            catch (IllegalArgumentException e) {
                Config.validationError("Speed type is invalid, resetting to default values");
                return;
            }
        } else {
            Config.validationError("Speed type is missing or invalid, resetting to default values");
            return;
        }
        if (!config.has("useKnot") || !(config.get("useKnot") instanceof Boolean)) {
            Config.validationError("Use knot is missing or invalid, resetting to default values");
            return;
        }
        if (!config.has("color") || !(config.get("color") instanceof JSONObject)) {
            Config.validationError("Color is missing or invalid, resetting to default values");
            return;
        }
        JSONObject color = config.getJSONObject("color");
        if (!(color.has("r") && color.has("g") && color.has("b") && color.get("r") instanceof Number && color.get("g") instanceof Number && color.get("b") instanceof Number)) {
            Config.validationError("Color is missing or invalid, resetting to default values");
            return;
        }
        if (!config.has("visualSpeedometer") || !(config.get("visualSpeedometer") instanceof Boolean)) {
            Config.validationError("Visual speedometer is missing or invalid, resetting to default values");
            return;
        }
        if (!config.has("xPosition") || !(config.get("xPosition") instanceof String) || config.getString("xPosition").isEmpty() || !config.getString("xPosition").matches(xRegex)) {
            Config.validationError("X position is missing or invalid, resetting to default values");
            return;
        }
        if (!config.has("yPosition") || !(config.get("yPosition") instanceof String) || config.getString("yPosition").isEmpty() || !config.getString("yPosition").matches(yRegex)) {
            Config.validationError("Y position is missing or invalid, resetting to default values");
            return;
        }
        if (!config.has("debug") || !(config.get("debug") instanceof Boolean)) {
            Config.validationError("Debug is missing or invalid, resetting to default values");
            return;
        }
        if (!config.has("imageSize") || !(config.get("imageSize") instanceof Number) || config.getInt("imageSize") < 10 || config.getInt("imageSize") > 200) {
            Config.validationError("Image size is missing or invalid, resetting to default values");
            return;
        }
        if (!config.has("showVisualSpeedType") || !(config.get("showVisualSpeedType") instanceof Boolean)) {
            Config.validationError("Show visual speed type is missing or invalid, resetting to default values");
            return;
        }
        if (!config.has("showSpeedType") || !(config.get("showSpeedType") instanceof Boolean)) {
            Config.validationError("Show speed type is missing or invalid, resetting to default values");
            return;
        }
        if (!config.has("overrideColor") || !(config.get("overrideColor") instanceof Boolean)) {
            Config.validationError("Override color is missing or invalid, resetting to default values");
            return;
        }
        if (!config.has("speedAvrageSampleCount") || !(config.get("speedAvrageSampleCount") instanceof Number)) {
            Speedometer.LOGGER.warn("Speed average sample count is missing or invalid, resetting to default value");
            config.put("speedAvrageSampleCount", 100);
        }
        Speedometer.LOGGER.info("Validated config successfully");
    }

    private static void validationError(String message) {
        Speedometer.LOGGER.warn(message);
        try {
            Config.dump();
        }
        catch (IOException e) {
            Speedometer.LOGGER.error("Failed to dump old config.", (Throwable)e);
        }
        config = new JSONObject();
        Config.defaultValues();
    }

    private static void defaultValues() {
        if (!config.has("speed")) {
            config.put("speed", (Object)SpeedTypes.BlockPS);
        }
        if (!config.has("useKnot")) {
            config.put("useKnot", false);
        }
        if (!config.has("color")) {
            config.put("color", new JSONObject().put("r", 16).put("g", 146).put("b", 158));
        }
        if (!config.has("visualSpeedometer")) {
            config.put("visualSpeedometer", false);
        }
        if (!config.has("xPosition")) {
            config.put("xPosition", "W-3");
        }
        if (!config.has("yPosition")) {
            config.put("yPosition", "H-3");
        }
        if (!config.has("debug")) {
            config.put("debug", false);
        }
        if (!config.has("imagSize")) {
            config.put("imageSize", 19);
        }
        if (!config.has("version")) {
            config.put("version", 4.0f);
        }
        if (!config.has("showVisualSpeedType")) {
            config.put("showVisualSpeedType", false);
        }
        if (!config.has("showSpeedType")) {
            config.put("showSpeedType", false);
        }
        if (!config.has("overrideColor")) {
            config.put("overrideColor", false);
        }
        if (!config.has("speedAvrageSampleCount")) {
            config.put("speedAvrageSampleCount", 150);
        }
    }

    public static void save() {
        File config = new File(configPath);
        if (!config.exists()) {
            try {
                config.getParentFile().mkdir();
                config.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(config));
            out.write(Config.config.put("READ_ME!", "If you reed this, you are most likely not in the about 5% of people who knows how to correctly edit this file. So please go and get Cloth Config API instead and use that, Best regards the dev. For those about 5% who do know how to edit this file, please study the Config.java file, best regards the dev").toString(4));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        counter = 0;
    }

    public static SpeedTypes getSpeedType() {
        if (config.has("speed")) {
            return config.getEnum(SpeedTypes.class, "speed");
        }
        return SpeedTypes.BlockPS;
    }

    public static boolean getUseKnot() {
        if (config.has("useKnot")) {
            return config.getBoolean("useKnot");
        }
        return false;
    }

    public static Color getColor() {
        if (config.has("color")) {
            JSONObject color = config.getJSONObject("color");
            return new Color(color.getInt("r"), color.getInt("g"), color.getInt("b"));
        }
        return new Color(16, 146, 158);
    }

    public static int getColorRGB() {
        return Config.getColor().getRGB() & 0xFFFFFF;
    }

    public static boolean isDebug() {
        if (config.has("debug")) {
            return config.getBoolean("debug");
        }
        return false;
    }

    public static boolean getVisualSpeedometer() {
        if (config.has("visualSpeedometer")) {
            return config.getBoolean("visualSpeedometer");
        }
        return false;
    }

    public static int getCounter() {
        return counter;
    }

    public static void addCounter() {
        ++counter;
    }

    public static String getYPosition() {
        if (config.has("yPosition")) {
            return config.getString("yPosition");
        }
        return "H-3";
    }

    public static String getXPosition() {
        if (config.has("xPosition")) {
            return config.getString("xPosition");
        }
        return "W-3";
    }

    public static int getImageSize() {
        if (config.has("imageSize")) {
            return config.getInt("imageSize");
        }
        return 19;
    }

    public static boolean getShowSpeedType() {
        if (config.has("getShowSpeedType")) {
            return config.getBoolean("showSpeedType");
        }
        return true;
    }

    public static String getConfigPath() {
        return configPath;
    }

    public static BufferedImage getSpeedometer() {
        return speedometer;
    }

    public static boolean isDisableVisualSpeedometer() {
        return disableVisualSpeedometer;
    }

    public static boolean isOverrideColor() {
        if (config.has("overrideColor")) {
            return config.getBoolean("overrideColor");
        }
        return false;
    }

    public static int getSpeedAvrageSampleCount() {
        if (config.has("speedAvrageSampleCount")) {
            return config.getInt("speedAvrageSampleCount");
        }
        return 150;
    }

    public static void setColor(int r, int g, int b) {
        config.put("color", new JSONObject().put("r", r).put("g", g).put("b", b));
    }

    public static void setUseKnot(boolean useKnot) {
        config.put("useKnot", useKnot);
    }

    public static void setSpeedType(SpeedTypes speedType) {
        config.put("speed", (Object)speedType);
    }

    public static void setVisualSpeedometer(boolean visualSpeedometer) {
        config.put("visualSpeedometer", visualSpeedometer);
    }

    public static void setXPosition(String xPosition) {
        config.put("xPosition", xPosition);
    }

    public static void setYPosition(String yPosition) {
        config.put("yPosition", yPosition);
    }

    public static void setDebug(boolean debug) {
        config.put("debug", debug);
    }

    public static void setImageSize(int imageSize) {
        config.put("imageSize", imageSize);
    }

    public static void setShowSpeedType(boolean showSpeedType) {
        config.put("showSpeedType", showSpeedType);
    }

    public static void setSpeedometer(BufferedImage speedometer) {
        Config.speedometer = speedometer;
    }

    public static void setDisableVisualSpeedometer(boolean disableVisualSpeedometer) {
        Config.disableVisualSpeedometer = disableVisualSpeedometer;
    }

    public static void setOverrideColor(boolean overrideColor) {
        config.put("overrideColor", overrideColor);
    }

    public static void setSpeedAvrageSampleCount(int speedAvrageSampleCount) {
        config.put("speedAvrageSampleCount", speedAvrageSampleCount);
    }

    static {
        counter = 0;
        disableVisualSpeedometer = false;
    }
}

