/*
 * Decompiled with CFR 0.152.
 */
package me.zacharias.speedometer;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import me.zacharias.speedometer.Config;
import me.zacharias.speedometer.ConfigMenu;
import me.zacharias.speedometer.Debugger;
import me.zacharias.speedometer.ImageHandler;
import me.zacharias.speedometer.SpeedTypes;
import me.zacharias.speedometer.Speedometer;
import net.minecraft.class_124;
import net.minecraft.class_128;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_9779;

public class Client {
    public static final class_304 CONFIG_KEY = new class_304("speedometer.key.configKey", class_3675.class_307.field_1668, 79, "speedometer.key.category");
    public static final class_304 DEBUG_KEY = new class_304("speedometer.key.debugKey", class_3675.class_307.field_1668, 295, "speedometer.key.category");
    private static final ArrayList<Double> speeds = new ArrayList();

    public static void init() {
        boolean isClothLoaded;
        boolean bl = isClothLoaded = Platform.isModLoaded((String)"cloth_config") || Platform.isModLoaded((String)"cloth-config");
        if (isClothLoaded) {
            Platform.getMod((String)"speedometer").registerConfigurationScreen(parent -> ConfigMenu.getConfig(parent).build());
        } else {
            Speedometer.LOGGER.warn("Missing Cloth Config API, In game config menu will not be available");
        }
        KeyMappingRegistry.register((class_304)CONFIG_KEY);
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            if (CONFIG_KEY.method_1436()) {
                if (isClothLoaded) {
                    class_310.method_1551().method_1507(ConfigMenu.getConfig(class_310.method_1551().field_1755).build());
                } else if (class_310.method_1551().field_1724 != null) {
                    class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"speedometer.error.missing_cloth").method_54663(new Color(190, 0, 0).getRGB()).method_10852((class_2561)class_2561.method_43471((String)"speedometer.error.missing_cloth.open_config").method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, Config.getConfigPath())))), false);
                    Speedometer.LOGGER.warn(class_2561.method_43471((String)"speedometer.error.missing_cloth").getString());
                } else {
                    Speedometer.LOGGER.warn(class_2561.method_43471((String)"speedometer.error.missing_cloth").getString());
                }
            }
        });
        KeyMappingRegistry.register((class_304)DEBUG_KEY);
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            if (DEBUG_KEY.method_1436()) {
                Config.setDebug(!Config.isDebug());
            }
        });
        Config.initialize();
        Config.save();
        ClientGuiEvent.RENDER_HUD.register(Client::render);
        Speedometer.LOGGER.info("Finished loading speedometer");
    }

    private static void render(class_332 graphics, class_9779 deltaTracker) {
        double speed;
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        if (class_310.method_1551().field_1690.field_1842) {
            return;
        }
        class_1297 entity = class_310.method_1551().field_1724.method_5668();
        class_243 vec = new class_243(entity.method_23317() - entity.field_6038, entity.method_23318() - entity.field_5971, entity.method_23321() - entity.field_5989);
        double yOffset = 0.0;
        double xOffset = 0.0;
        double zOffset = 0.0;
        double vOffset = 0.0;
        double lSpeed = speed = Math.sqrt(Math.pow(vec.field_1352 + xOffset, 2.0) + Math.pow(vec.field_1351 + yOffset, 2.0) + Math.pow(vec.field_1350 + zOffset, 2.0)) * 20.0 + vOffset;
        if (speeds.size() >= 30) {
            speeds.removeFirst();
        }
        speeds.add(speed);
        speed = 0.0;
        for (Double aDouble : speeds) {
            speed += aDouble.doubleValue();
        }
        SpeedTypes speedType = Config.getSpeedType();
        double speedTypeSpeed = speedType == SpeedTypes.KNOT || entity instanceof class_1690 && Config.getUseKnot() ? speed * 1.94384449 : (speedType == SpeedTypes.KMPH ? speed * 3.6 : (speedType == SpeedTypes.MPH ? speed * 2.23693629 : (speed /= (double)speeds.size())));
        String format = String.format("%.2f", speedTypeSpeed);
        String speedString = format + " " + SpeedTypes.getName(speedType).getString();
        int width = switch (Config.getVisualSpeedometer() && !Config.isDisableVisualSpeedometer() ? 1 : 0) {
            case 1 -> Config.getImageSize();
            case 0 -> class_310.method_1551().field_1772.method_1727(speedString);
            default -> 0;
        };
        int yPos = Client.getPosImp(graphics, width, Config.getYPosition(), false);
        int xPos = Client.getPosImp(graphics, width, Config.getXPosition(), true);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int lineHeight = 9;
        if (Config.getVisualSpeedometer() && !Config.isDisableVisualSpeedometer()) {
            BufferedImage img = ImageHandler.scale(Speedometer.ICON.getSpeedometerIcon(speedTypeSpeed), Config.getImageSize(), Config.getImageSize());
            ImageHandler.register(class_2960.method_60655((String)"speedometer", (String)"speedometer_icon_tmp"), img);
            for (int x1 = 0; x1 < img.getWidth(); ++x1) {
                for (int y1 = 0; y1 < img.getHeight(); ++y1) {
                    int x2 = x1 + xPos - img.getWidth();
                    int y2 = y1 + yPos - img.getHeight();
                    int rgb = img.getRGB(x1, y1);
                    if (new Color(rgb).equals(Color.black)) continue;
                    graphics.method_25294(x2, y2, x2 + 1, y2 + 1, rgb);
                }
            }
        } else {
            graphics.method_25303(class_310.method_1551().field_1772, speedString, xPos - width, yPos - lineHeight, Config.getColor().getRGB());
        }
        if (Config.isDebug()) {
            String debugData = "Speedometer: " + Speedometer.VERSION + "\nVelocity raw:\n  X: " + vec.field_1352 + "\n  Y: " + vec.field_1351 + "\n  Z: " + vec.field_1350 + "\nOffsets:\n  X: " + xOffset + "\n  Y: " + yOffset + "\n  Z: " + zOffset + "\n  Total: " + vOffset + "\nVelocity modified:\n  X: " + (vec.field_1352 + xOffset) + "\n  Y: " + (vec.field_1351 + yOffset) + "\n  Z: " + (vec.field_1350 + zOffset) + "\n  Total: " + lSpeed + "\nVelocity total average: " + speed + "\nVelocity total in " + speedType.name() + ": " + speedTypeSpeed + "\nEndpoint position: (" + Debugger.x + ", " + Debugger.y + ")\nPercentage point of visual speedometer: " + Debugger.angle + "\n" + (String)(Config.getVisualSpeedometer() ? "Visual Size: " + Config.getImageSize() : "Textual display") + "\n" + (String)(Config.getVisualSpeedometer() ? "Creating visual speedometer: " + Debugger.avrage40SizingTime + " ms" : "");
            Color color = new Color(255, 255, 255);
            int y = 0;
            for (String s : debugData.split("\n")) {
                Client.drawString(graphics, 0, y, s, color.getRGB());
                Objects.requireNonNull(class_310.method_1551().field_1772);
                y += 9 + 1;
            }
        }
    }

    private static void drawString(class_332 graphics, int x, int y, String text, int colorRGB) {
        graphics.method_25303(class_310.method_1551().field_1772, text, x, y, colorRGB);
    }

    private static int getPosImp(class_332 event, int width, String input, boolean isXPosition) {
        input = input.trim();
        input = input.replaceAll("(W+)|(H+)", String.valueOf(isXPosition ? event.method_51421() : event.method_51443())).replaceAll("(w+)|(h+)", String.valueOf(isXPosition ? event.method_51421() / 2 : event.method_51443() / 2)).replaceAll("(S+)|(s+)", String.valueOf(width));
        if (Config.isDebug() && Config.getCounter() < 2) {
            Speedometer.LOGGER.info("Selected speed type(DEBUG): {}\n{}\n\n\n", (Object)isXPosition, (Object)input);
            Config.addCounter();
        }
        return Client.getPos(event, width, input, isXPosition);
    }

    private static int getPos(class_332 event, int width, String input, boolean isXPosition) {
        int position;
        ArrayList<String> tokens = new ArrayList<String>();
        char[] s = input.toCharArray();
        try {
            for (int i = 0; i < s.length; ++i) {
                char c = s[i];
                if (c == '+' || c == '-' || c == '*' || c == '/') {
                    tokens.add(Character.toString(c));
                    continue;
                }
                if (Character.isDigit(c)) {
                    int lastIndex = i - 1;
                    if (lastIndex >= 0 && tokens.get(lastIndex).matches("^[0-9]+$")) {
                        tokens.set(tokens.size() - 1, tokens.get(tokens.size() - 1) + c);
                        continue;
                    }
                    tokens.add(Character.toString(c));
                    continue;
                }
                throw new IllegalArgumentException("Invalid character in input string: " + c);
            }
        }
        catch (Exception e) {
            tokens.clear();
            Client.defaultValues(event, isXPosition, tokens);
        }
        try {
            position = Integer.parseInt(tokens.getFirst());
        }
        catch (NumberFormatException e) {
            tokens.clear();
            Client.defaultValues(event, isXPosition, tokens);
            position = Integer.parseInt(tokens.getFirst());
        }
        block19: for (int i = 1; i < tokens.size(); i += 2) {
            int value;
            String operator = tokens.get(i);
            if (i + 1 >= tokens.size()) {
                Speedometer.LOGGER.error("Invalid expression: missing operand after operator '{}'", (Object)operator);
                break;
            }
            String operand = tokens.get(i + 1);
            try {
                value = Integer.parseInt(operand);
            }
            catch (NumberFormatException e) {
                Speedometer.LOGGER.error("Invalid operand: '{}'. Using default value. REPORT THIS! https://github.com/zaze06/Speedometer/issues/new/choose", (Object)operand);
                class_310.method_1551().method_54580(new class_128("Invalid operand in speedometer position calculation. REPORT THIS! https://github.com/zaze06/Speedometer/issues/new/choose", (Throwable)e));
                return -1;
            }
            switch (operator) {
                case "+": {
                    position += value;
                    continue block19;
                }
                case "-": {
                    position -= value;
                    continue block19;
                }
                case "*": {
                    position *= value;
                    continue block19;
                }
                case "/": {
                    position /= value;
                }
            }
        }
        if (Config.isDebug() && Config.getCounter() < 2) {
            Speedometer.LOGGER.info("Selected speed type: {}\n{}\n\n{}\n\n{}", (Object)SpeedTypes.getName(Config.getSpeedType()).getString(), (Object)Arrays.toString(tokens.toArray()), (Object)position, (Object)(isXPosition ? Config.getXPosition() : Config.getYPosition()));
            Config.addCounter();
        }
        return position;
    }

    private static void defaultValues(class_332 event, boolean isXPosition, ArrayList<String> passerPose) {
        if (isXPosition) {
            passerPose.add(String.valueOf(event.method_51421()));
            passerPose.add("-");
            passerPose.add("3");
        } else {
            passerPose.add(String.valueOf(event.method_51443()));
            passerPose.add("-");
            passerPose.add("3");
        }
    }
}

