/*
 * Decompiled with CFR 0.152.
 */
package me.zacharias.speedometer;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import me.zacharias.speedometer.Config;
import me.zacharias.speedometer.ConfigMenu;
import me.zacharias.speedometer.Debugger;
import me.zacharias.speedometer.ImageHandler;
import me.zacharias.speedometer.SpeedTypes;
import me.zacharias.speedometer.Speedometer;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.phys.Vec3;

public class Client {
    public static final KeyMapping CONFIG_KEY = new KeyMapping("speedometer.key.configKey", InputConstants.Type.KEYSYM, 79, "speedometer.key.category");
    public static final KeyMapping DEBUG_KEY = new KeyMapping("speedometer.key.debugKey", InputConstants.Type.KEYSYM, 295, "speedometer.key.category");
    private static final ArrayList<Double> speeds = new ArrayList();

    public static void init() {
        boolean isClothLoaded;
        boolean bl = isClothLoaded = Platform.isModLoaded((String)"cloth_config") || Platform.isModLoaded((String)"cloth-config");
        if (isClothLoaded) {
            Platform.getMod((String)"speedometer").registerConfigurationScreen(parent -> ConfigMenu.getConfig(parent).build());
        } else {
            Speedometer.LOGGER.warn("Missing Cloth Config API, In game config menu will not be available");
        }
        KeyMappingRegistry.register((KeyMapping)CONFIG_KEY);
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            if (CONFIG_KEY.consumeClick()) {
                if (isClothLoaded) {
                    Minecraft.getInstance().setScreen(ConfigMenu.getConfig(Minecraft.getInstance().screen).build());
                } else if (Minecraft.getInstance().player != null) {
                    Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"speedometer.error.missing_cloth").withColor(new Color(190, 0, 0).getRGB()).append((Component)Component.translatable((String)"speedometer.error.missing_cloth.open_config").withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, Config.getConfigPath())))), false);
                    Speedometer.LOGGER.warn(Component.translatable((String)"speedometer.error.missing_cloth").getString());
                } else {
                    Speedometer.LOGGER.warn(Component.translatable((String)"speedometer.error.missing_cloth").getString());
                }
            }
        });
        KeyMappingRegistry.register((KeyMapping)DEBUG_KEY);
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            if (DEBUG_KEY.consumeClick()) {
                Config.setDebug(!Config.isDebug());
            }
        });
        Config.initialize();
        Config.save();
        ClientGuiEvent.RENDER_HUD.register(Client::render);
        Speedometer.LOGGER.info("Finished loading speedometer");
    }

    private static void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        double speed;
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        Entity entity = Minecraft.getInstance().player.getRootVehicle();
        Vec3 vec = new Vec3(entity.getX() - entity.xOld, entity.getY() - entity.yOld, entity.getZ() - entity.zOld);
        double yOffset = 0.0;
        double xOffset = 0.0;
        double zOffset = 0.0;
        double vOffset = 0.0;
        double lSpeed = speed = Math.sqrt(Math.pow(vec.x + xOffset, 2.0) + Math.pow(vec.y + yOffset, 2.0) + Math.pow(vec.z + zOffset, 2.0)) * 20.0 + vOffset;
        if (speeds.size() >= 30) {
            speeds.removeFirst();
        }
        speeds.add(speed);
        speed = 0.0;
        for (Double aDouble : speeds) {
            speed += aDouble.doubleValue();
        }
        SpeedTypes speedType = Config.getSpeedType();
        double speedTypeSpeed = speedType == SpeedTypes.KNOT || entity instanceof Boat && Config.getUseKnot() ? speed * 1.94384449 : (speedType == SpeedTypes.KMPH ? speed * 3.6 : (speedType == SpeedTypes.MPH ? speed * 2.23693629 : (speed /= (double)speeds.size())));
        String format = String.format("%.2f", speedTypeSpeed);
        String speedString = format + " " + SpeedTypes.getName(speedType).getString();
        int width = switch (Config.getVisualSpeedometer() && !Config.isDisableVisualSpeedometer() ? 1 : 0) {
            case 1 -> Config.getImageSize();
            case 0 -> Minecraft.getInstance().font.width(speedString);
            default -> 0;
        };
        int yPos = Client.getPosImp(graphics, width, Config.getYPosition(), false);
        int xPos = Client.getPosImp(graphics, width, Config.getXPosition(), true);
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lineHeight = 9;
        if (Config.getVisualSpeedometer() && !Config.isDisableVisualSpeedometer()) {
            BufferedImage img = ImageHandler.scale(Speedometer.ICON.getSpeedometerIcon(speedTypeSpeed), Config.getImageSize(), Config.getImageSize());
            ImageHandler.register(ResourceLocation.fromNamespaceAndPath((String)"speedometer", (String)"speedometer_icon_tmp"), img);
            for (int x1 = 0; x1 < img.getWidth(); ++x1) {
                for (int y1 = 0; y1 < img.getHeight(); ++y1) {
                    int x2 = x1 + xPos - img.getWidth();
                    int y2 = y1 + yPos - img.getHeight();
                    int rgb = img.getRGB(x1, y1);
                    if (new Color(rgb).equals(Color.black)) continue;
                    graphics.fill(x2, y2, x2 + 1, y2 + 1, rgb);
                }
            }
        } else {
            graphics.drawString(Minecraft.getInstance().font, speedString, xPos - width, yPos - lineHeight, Config.getColor().getRGB());
        }
        if (Config.isDebug()) {
            String debugData = "Speedometer: " + Speedometer.VERSION + "\nVelocity raw:\n  X: " + vec.x + "\n  Y: " + vec.y + "\n  Z: " + vec.z + "\nOffsets:\n  X: " + xOffset + "\n  Y: " + yOffset + "\n  Z: " + zOffset + "\n  Total: " + vOffset + "\nVelocity modified:\n  X: " + (vec.x + xOffset) + "\n  Y: " + (vec.y + yOffset) + "\n  Z: " + (vec.z + zOffset) + "\n  Total: " + lSpeed + "\nVelocity total average: " + speed + "\nVelocity total in " + speedType.name() + ": " + speedTypeSpeed + "\nEndpoint position: (" + Debugger.x + ", " + Debugger.y + ")\nPercentage point of visual speedometer: " + Debugger.angle + "\n" + (String)(Config.getVisualSpeedometer() ? "Visual Size: " + Config.getImageSize() : "Textual display") + "\n" + (String)(Config.getVisualSpeedometer() ? "Creating visual speedometer: " + Debugger.avrage40SizingTime + " ms" : "");
            Color color = new Color(255, 255, 255);
            int y = 0;
            for (String s : debugData.split("\n")) {
                Client.drawString(graphics, 0, y, s, color.getRGB());
                Objects.requireNonNull(Minecraft.getInstance().font);
                y += 9 + 1;
            }
        }
    }

    private static void drawString(GuiGraphics graphics, int x, int y, String text, int colorRGB) {
        graphics.drawString(Minecraft.getInstance().font, text, x, y, colorRGB);
    }

    private static int getPosImp(GuiGraphics event, int width, String input, boolean isXPosition) {
        input = input.trim();
        input = input.replaceAll("(W+)|(H+)", String.valueOf(isXPosition ? event.guiWidth() : event.guiHeight())).replaceAll("(w+)|(h+)", String.valueOf(isXPosition ? event.guiWidth() / 2 : event.guiHeight() / 2)).replaceAll("(S+)|(s+)", String.valueOf(width));
        if (Config.isDebug() && Config.getCounter() < 2) {
            Speedometer.LOGGER.info("Selected speed type(DEBUG): {}\n{}\n\n\n", (Object)isXPosition, (Object)input);
            Config.addCounter();
        }
        return Client.getPos(event, width, input, isXPosition);
    }

    private static int getPos(GuiGraphics event, int width, String input, boolean isXPosition) {
        int position;
        ArrayList<String> tokens = new ArrayList<String>();
        char[] s = input.toCharArray();
        try {
            for (int i = 0; i < s.length; ++i) {
                char c = s[i];
                if (c == '+' || c == '-' || c == '*' || c == '/') {
                    tokens.add(Character.toString(c));
                    continue;
                }
                if (Character.isDigit(c)) {
                    int lastIndex = i - 1;
                    if (lastIndex >= 0 && tokens.get(lastIndex).matches("^[0-9]+$")) {
                        tokens.set(tokens.size() - 1, tokens.get(tokens.size() - 1) + c);
                        continue;
                    }
                    tokens.add(Character.toString(c));
                    continue;
                }
                throw new IllegalArgumentException("Invalid character in input string: " + c);
            }
        }
        catch (Exception e) {
            tokens.clear();
            Client.defaultValues(event, isXPosition, tokens);
        }
        try {
            position = Integer.parseInt(tokens.getFirst());
        }
        catch (NumberFormatException e) {
            tokens.clear();
            Client.defaultValues(event, isXPosition, tokens);
            position = Integer.parseInt(tokens.getFirst());
        }
        block19: for (int i = 1; i < tokens.size(); i += 2) {
            int value;
            String operator = tokens.get(i);
            if (i + 1 >= tokens.size()) {
                Speedometer.LOGGER.error("Invalid expression: missing operand after operator '{}'", (Object)operator);
                break;
            }
            String operand = tokens.get(i + 1);
            try {
                value = Integer.parseInt(operand);
            }
            catch (NumberFormatException e) {
                Speedometer.LOGGER.error("Invalid operand: '{}'. Using default value. REPORT THIS! https://github.com/zaze06/Speedometer/issues/new/choose", (Object)operand);
                Minecraft.getInstance().emergencySaveAndCrash(new CrashReport("Invalid operand in speedometer position calculation. REPORT THIS! https://github.com/zaze06/Speedometer/issues/new/choose", (Throwable)e));
                return -1;
            }
            switch (operator) {
                case "+": {
                    position += value;
                    continue block19;
                }
                case "-": {
                    position -= value;
                    continue block19;
                }
                case "*": {
                    position *= value;
                    continue block19;
                }
                case "/": {
                    position /= value;
                }
            }
        }
        if (Config.isDebug() && Config.getCounter() < 2) {
            Speedometer.LOGGER.info("Selected speed type: {}\n{}\n\n{}\n\n{}", (Object)SpeedTypes.getName(Config.getSpeedType()).getString(), (Object)Arrays.toString(tokens.toArray()), (Object)position, (Object)(isXPosition ? Config.getXPosition() : Config.getYPosition()));
            Config.addCounter();
        }
        return position;
    }

    private static void defaultValues(GuiGraphics event, boolean isXPosition, ArrayList<String> passerPose) {
        if (isXPosition) {
            passerPose.add(String.valueOf(event.guiWidth()));
            passerPose.add("-");
            passerPose.add("3");
        } else {
            passerPose.add(String.valueOf(event.guiHeight()));
            passerPose.add("-");
            passerPose.add("3");
        }
    }
}

