/*
 * Decompiled with CFR 0.152.
 */
package me.zacharias.speedometer;

import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.api.Requirement;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.zacharias.speedometer.Config;
import me.zacharias.speedometer.SpeedTypes;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigMenu {
    public static ConfigBuilder getConfig(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.translatable((String)"speedometer.config.name"));
        ConfigCategory category = builder.getOrCreateCategory((Component)Component.translatable((String)"speedometer.config.category.name"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        category.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((Component)Component.translatable((String)"speedometer.config.speed"), SpeedTypes.class, (Enum)Config.getSpeedType()).setEnumNameProvider(SpeedTypes::getName).setSaveConsumer(Config::setSpeedType).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startColorField((Component)Component.translatable((String)"speedometer.config.color"), Config.getColorRGB()).setSaveConsumer2(color -> Config.setColor(color.getRed(), color.getGreen(), color.getBlue())).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"speedometer.config.knot"), Config.getUseKnot()).setSaveConsumer(Config::setUseKnot).setYesNoTextSupplier(useKnot -> Component.translatable((String)("speedometer.useKnot." + useKnot))).build());
        category.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"speedometer.config.visualSpeedometer"), Config.getVisualSpeedometer()).setSaveConsumer(Config::setVisualSpeedometer).setYesNoTextSupplier(visualSpeedometer -> Component.translatable((String)("speedometer.visualSpeedometer." + visualSpeedometer))).setRequirement(Requirement.isFalse(Config::isDisableVisualSpeedometer))).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startStringDropdownMenu((Component)Component.translatable((String)"speedometer.config.xPosition"), Config.getXPosition()).setSaveConsumer(Config::setXPosition).setErrorSupplier(xPosition -> {
            if (xPosition.matches("W*w*S*s*\\+*-*\\**/*[0-9]*") && !xPosition.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(Component.translatable((String)"speedometer.invalid"));
        }).setTooltip(new Component[]{Component.translatable((String)"speedometer.config.tooltip.xPosition.line1"), Component.translatable((String)"speedometer.config.tooltip.xPosition.line2"), Component.translatable((String)"speedometer.config.tooltip.xPosition.line3")}).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startStringDropdownMenu((Component)Component.translatable((String)"speedometer.config.yPosition"), Config.getYPosition()).setSaveConsumer(Config::setYPosition).setErrorSupplier(yPosition -> {
            if (yPosition.matches("H*h*S*s*\\+*-*\\**/*[0-9]*") && !yPosition.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(Component.translatable((String)"speedometer.invalid"));
        }).setTooltip(new Component[]{Component.translatable((String)"speedometer.config.tooltip.yPosition.line1"), Component.translatable((String)"speedometer.config.tooltip.yPosition.line2"), Component.translatable((String)"speedometer.config.tooltip.yPosition.line3")}).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.translatable((String)"speedometer.config.imageSize"), Config.getImageSize(), 10, 200).setSaveConsumer(Config::setImageSize).setTooltip(new Component[]{Component.translatable((String)"speedometer.config.tooltip.imageSize")}).setErrorSupplier(size -> {
            if (size > 200 || size < 10) {
                return Optional.of(Component.translatable((String)"speedometer.config.error.size_outofbounds"));
            }
            return Optional.empty();
        }).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"speedometer.config.showSpeedType"), Config.getShowSpeedType()).setSaveConsumer(Config::setShowSpeedType).setYesNoTextSupplier(showSpeedType -> Component.translatable((String)("speedometer." + (showSpeedType != false ? "show" : "hide")))).setTooltip(new Component[]{Component.translatable((String)"speedometer.config.tooltip.showSpeedType.line1")}).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"speedometer.config.override_color"), Config.isOverrideColor()).setSaveConsumer(Config::setOverrideColor).setTooltip(new Component[]{Component.translatable((String)"speedometer.config.tooltip.override_color.line1"), Component.translatable((String)"speedometer.config.tooltip.override_color.line2")}).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"speedometer.config.debug"), Config.isDebug()).setSaveConsumer(Config::setDebug).setYesNoTextSupplier(isDebug -> Component.translatable((String)("speedometer.debug." + isDebug))).setTooltip(new Component[]{Component.translatable((String)"speedometer.config.tooltip.debug")}).build());
        builder.setSavingRunnable(Config::save);
        return builder;
    }
}

