/*
 * Decompiled with CFR 0.152.
 */
package me.zacharias.speedometer;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.io.BufferedReader;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import me.zacharias.speedometer.Client;
import me.zacharias.speedometer.Config;
import me.zacharias.speedometer.SpeedometerIcon;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import speedometer.shaded.org.json.JSONObject;

public class Speedometer {
    public static final String MOD_ID = "speedometer";
    public static final Logger LOGGER = LogManager.getLogger((String)"speedometer");
    public static final String VERSION = Platform.getMod((String)"speedometer").getVersion();
    public static SpeedometerIcon ICON = null;

    public static void init() {
        LOGGER.info("Loading speedometer by Allen");
        if (Platform.getEnvironment() != Env.CLIENT) {
            LOGGER.error("You're running speedometer on something other then a client, this is not supported");
            try {
                for (File f : Objects.requireNonNull(Platform.getModsFolder().toFile().listFiles())) {
                    if (!f.getName().startsWith(MOD_ID)) continue;
                    String fileName = "speedometer-" + VERSION + ".jar.disable";
                    if (f.renameTo(new File(f.getParent(), fileName))) {
                        LOGGER.warn("Successfully in renaming the mod jar file to {}", (Object)fileName);
                        LOGGER.warn("You should remove the file from {}", (Object)Platform.getModsFolder().toString());
                        continue;
                    }
                    LOGGER.warn("Unsuccessful in renaming mod jar");
                    LOGGER.warn("You should remove the mod from {} to no longer receive this message", (Object)Platform.getModsFolder().toString());
                }
            }
            catch (NullPointerException e) {
                LOGGER.warn("Can't disable the mod. Please delete the file!");
            }
            return;
        }
        Client.init();
    }

    public static void loadSpeedometers(ResourceManager resourceManager) {
        Optional resource = resourceManager.getResource(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"models/speedometer.json"));
        if (resource.isEmpty()) {
            Config.setDisableVisualSpeedometer(true);
            LOGGER.error("Failed to load speedometer config");
            return;
        }
        try (BufferedReader stream = ((Resource)resource.get()).openAsReader();){
            String tmp;
            StringBuilder builder = new StringBuilder();
            while ((tmp = stream.readLine()) != null) {
                builder.append(tmp);
            }
            JSONObject data = new JSONObject(builder.toString());
            if (Config.isDebug()) {
                LOGGER.info("Loaded speedometer from {}, with speedometer name: {}", (Object)((Resource)resource.get()).source().packId(), data.get("name"));
            }
            ICON = new SpeedometerIcon(data, resourceManager);
        }
        catch (Exception e) {
            Config.setDisableVisualSpeedometer(true);
            LOGGER.error("Failed to load speedometer config", (Throwable)e);
            return;
        }
        LOGGER.info("Successfully loaded speedometer config from {}", (Object)((Resource)resource.get()).source().packId());
    }

    public static String formatMillisToDHMS(long millis) {
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis) % 60L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) % 60L;
        long hours = TimeUnit.MILLISECONDS.toHours(millis) % 24L;
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        return String.format("%02d+%02d-%02d-%02d", days, hours, minutes, seconds);
    }
}

