/*
 * Decompiled with CFR 0.152.
 */
package me.zacharias.speedometer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import me.zacharias.speedometer.Config;
import me.zacharias.speedometer.Speedometer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ImageHandler {
    public static BufferedImage scale(BufferedImage img, int width, int height) {
        Image img1 = img.getScaledInstance(width, height, 1);
        BufferedImage out = new BufferedImage(width, height, 2);
        Graphics2D g2d = out.createGraphics();
        g2d.drawImage(img1, 0, 0, null);
        return out;
    }

    public static BufferedImage clone(BufferedImage image) {
        BufferedImage out = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2d = out.createGraphics();
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getWidth(); ++y) {
                g2d.setColor(new Color(image.getRGB(x, y)));
                g2d.fillRect(x, y, 1, 1);
            }
        }
        return out;
    }

    public static BufferedImage rotateImage(BufferedImage image, double angle, int x, int y) {
        double radians = Math.toRadians(angle);
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage rotatedImage = new BufferedImage(width, height, image.getType());
        Graphics2D g2d = rotatedImage.createGraphics();
        AffineTransform transform = new AffineTransform();
        transform.translate(x, y);
        transform.rotate(radians);
        transform.translate(-x, -y);
        g2d.setTransform(transform);
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return rotatedImage;
    }

    public static void register(class_2960 location, BufferedImage img) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", out);
            class_1043 dt = new class_1043(() -> "png", class_1011.method_49277((byte[])out.toByteArray()));
            class_310.method_1551().method_1531().method_4616(location, (class_1044)dt);
            out.close();
        }
        catch (Exception ex) {
            Speedometer.LOGGER.error("Failed to register image for " + location.toString());
            Speedometer.LOGGER.error(ex.getMessage());
            Config.setDisableVisualSpeedometer(true);
        }
    }
}

