/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.inventory.container;

import com.google.common.collect.Lists;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.cyclops.colossalchests.ColossalChestsInstance;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.network.packet.ClientboundContainerSetContentPacketWindow;
import org.cyclops.colossalchests.network.packet.ClientboundContainerSetSlotPacketLarge;
import org.cyclops.cyclopscore.inventory.LargeInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.PacketBase;

public class ContainerColossalChest
extends ScrollingInventoryContainer<Slot> {
    private static final int INVENTORY_OFFSET_X = 9;
    private static final int INVENTORY_OFFSET_Y = 112;
    private static final int CHEST_INVENTORY_OFFSET_X = 9;
    private static final int CHEST_INVENTORY_OFFSET_Y = 18;
    public static final int CHEST_INVENTORY_ROWS = 5;
    public static final int CHEST_INVENTORY_COLUMNS = 9;
    private final List<Slot> chestSlots = Lists.newArrayListWithCapacity((int)this.getSizeInventory());
    private final NonNullList<ItemStack> inventoryItemStacks = NonNullList.withSize((int)this.getSizeInventory(), (Object)ItemStack.EMPTY);
    private int lastInventoryState = -2;
    private boolean firstDetectionCheck = true;

    public ContainerColossalChest(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, (Container)new LargeInventory(data.readInt(), 64));
    }

    public ContainerColossalChest(int id, Inventory playerInventory, Container inventory) {
        super((MenuType)RegistryEntries.CONTAINER_COLOSSAL_CHEST.value(), id, playerInventory, inventory, Collections.emptyList(), (item, pattern) -> true);
        this.addChestSlots(this.getSizeInventory() / 9, 9);
        this.addPlayerInventory(playerInventory, 9, 112);
        this.updateFilter("");
    }

    protected List<Slot> getUnfilteredItems() {
        return this.chestSlots;
    }

    protected void addChestSlots(int rows, int columns) {
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                Slot slot = this.makeSlot(this.inventory, column + row * columns, 9 + column * 18, 18 + row * 18);
                this.addSlot(slot);
                this.chestSlots.add(slot);
            }
        }
    }

    protected Slot makeSlot(Container inventory, int index, int row, int column) {
        return new SlotExtended(inventory, index, row, column);
    }

    public int getColumns() {
        return 9;
    }

    public int getPageSize() {
        return 5;
    }

    protected void disableSlot(int slotIndex) {
        Slot slot = this.getSlot(slotIndex);
        ContainerExtended.setSlotPosX((Slot)slot, (int)Integer.MIN_VALUE);
        ContainerExtended.setSlotPosY((Slot)slot, (int)Integer.MIN_VALUE);
    }

    protected void enableSlot(int slotIndex, int row, int column) {
        Slot slot = this.getSlot(slotIndex);
        ContainerExtended.setSlotPosX((Slot)slot, (int)(9 + column * 18));
        ContainerExtended.setSlotPosY((Slot)slot, (int)(18 + row * 18));
    }

    public void onScroll(int firstRow) {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.disableSlot(i);
        }
        super.onScroll(firstRow);
    }

    protected void enableElementAt(int visibleIndex, int elementIndex, Slot element) {
        super.enableElementAt(visibleIndex, elementIndex, (Object)element);
        int column = visibleIndex % this.getColumns();
        int row = (visibleIndex - column) / this.getColumns();
        this.enableSlot(elementIndex, row, column);
    }

    public void addSlotListener(ContainerListener listener) {
        if (this.containerListeners.contains(listener)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.containerListeners.add(listener);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.containerListener == listener) {
                this.updateCraftingInventory(serverPlayer, (List<ItemStack>)this.getItems());
            }
        }
        this.broadcastChanges();
    }

    public void broadcastChanges() {
        int newState = ((SimpleInventory)this.inventory).getState();
        if (this.lastInventoryState != newState) {
            this.lastInventoryState = newState;
            this.detectAndSendChangesOverride();
        }
    }

    protected void detectAndSendChangesOverride() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            ItemStack itemstack = ((Slot)this.slots.get(i)).getItem();
            ItemStack itemstack1 = (ItemStack)this.inventoryItemStacks.get(i);
            if (ItemStack.matches((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            itemstack1 = itemstack.isEmpty() ? ItemStack.EMPTY : itemstack.copy();
            this.inventoryItemStacks.set(i, (Object)itemstack1);
            if (this.firstDetectionCheck) continue;
            for (int j = 0; j < this.containerListeners.size(); ++j) {
                ContainerListener listener = (ContainerListener)this.containerListeners.get(j);
                Player player = this.player;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (serverPlayer.containerListener == listener) {
                        this.sendSlotContentsToPlayer(serverPlayer, (AbstractContainerMenu)this, i, itemstack1);
                        continue;
                    }
                }
                listener.slotChanged((AbstractContainerMenu)this, i, itemstack1);
            }
        }
        this.firstDetectionCheck = false;
    }

    protected void sendSlotContentsToPlayer(ServerPlayer player, AbstractContainerMenu containerToSend, int slotInd, ItemStack stack) {
        if (!(containerToSend.getSlot(slotInd) instanceof ResultSlot)) {
            ColossalChestsInstance.MOD.getPacketHandler().sendToPlayer((PacketBase)new ClientboundContainerSetSlotPacketLarge(containerToSend.containerId, this.getStateId(), slotInd, stack), player);
        }
    }

    protected int getTagSize(Tag tag) {
        if (tag instanceof NumericTag || tag instanceof EndTag) {
            return 1;
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            int size = 0;
            for (String key : compound.keySet()) {
                try {
                    size += key.getBytes("UTF-8").length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                size += this.getTagSize(compound.get(key));
            }
            return size;
        }
        if (tag instanceof ByteArrayTag) {
            return ((ByteArrayTag)tag).getAsByteArray().length;
        }
        if (tag instanceof IntArrayTag) {
            return ((IntArrayTag)tag).getAsIntArray().length * 32;
        }
        if (tag instanceof ListTag) {
            ListTag list = (ListTag)tag;
            int size = 0;
            for (int i = 0; i < list.size(); ++i) {
                size += this.getTagSize(list.get(i));
            }
            return size;
        }
        if (tag instanceof StringTag) {
            try {
                return ((String)tag.asString().orElseThrow()).getBytes("UTF-8").length + 1;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return tag.toString().length();
    }

    public void updateCraftingInventory(ServerPlayer player, List<ItemStack> allItems) {
        int maxBufferSize = GeneralConfig.maxPacketBufferSize;
        ServerGamePacketListenerImpl playerNetServerHandler = player.connection;
        CompoundTag sendBuffer = new CompoundTag();
        ListTag sendList = new ListTag();
        sendBuffer.put("stacks", (Tag)sendList);
        int i = 0;
        int bufferSize = 0;
        boolean sent = false;
        for (ItemStack itemStack : allItems) {
            if (itemStack != null) {
                CompoundTag tag = new CompoundTag();
                tag.putInt("slot", i);
                try {
                    tag.put("stack", (Tag)ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)player.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)itemStack).getOrThrow(JsonParseException::new));
                }
                catch (JsonParseException e) {
                    ColossalChestsInstance.MOD.log(Level.ERROR, "Error while attempting to send a stack to a client " + String.valueOf(itemStack));
                    e.printStackTrace();
                }
                int tagSize = this.getTagSize((Tag)tag);
                if (bufferSize + tagSize + 100 < maxBufferSize) {
                    sendList.add((Object)tag);
                    bufferSize += tagSize;
                } else {
                    ColossalChestsInstance.MOD.getPacketHandler().sendToPlayer((PacketBase)new ClientboundContainerSetContentPacketWindow(this.containerId, this.getStateId(), sendBuffer), player);
                    sendBuffer = new CompoundTag();
                    sendList = new ListTag();
                    sendList.add((Object)tag);
                    sendBuffer.put("stacks", (Tag)sendList);
                    bufferSize = tagSize;
                }
            }
            ++i;
        }
        if (sendList.size() > 0) {
            ColossalChestsInstance.MOD.getPacketHandler().sendToPlayer((PacketBase)new ClientboundContainerSetContentPacketWindow(this.containerId, this.getStateId(), sendBuffer), player);
        }
        playerNetServerHandler.send((Packet)new ClientboundContainerSetSlotPacket(-1, this.getStateId(), -1, this.getCarried()));
    }
}

