/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_3917;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.Interface;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChest;
import org.cyclops.cyclopscore.block.multi.AllowedBlock;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.CubeSizeValidator;
import org.cyclops.cyclopscore.block.multi.ExactBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.HollowCubeDetector;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.block.multi.MaximumSizeValidator;
import org.cyclops.cyclopscore.block.multi.MinimumSizeValidator;

public class ChestMaterial {
    public static final Codec<ChestMaterial> CODEC = Codec.stringResolver(ChestMaterial::getName, ChestMaterial::valueOfSafe);
    public static final List<ChestMaterial> VALUES = Lists.newArrayList();
    public static final Map<String, ChestMaterial> KEYED_VALUES = Maps.newHashMap();
    public static final ChestMaterial WOOD = new ChestMaterial("wood", () -> GeneralConfig.chestInventoryMaterialFactorWood);
    public static final ChestMaterial COPPER = new ChestMaterial("copper", () -> GeneralConfig.chestInventoryMaterialFactorCopper);
    public static final ChestMaterial IRON = new ChestMaterial("iron", () -> GeneralConfig.chestInventoryMaterialFactorIron);
    public static final ChestMaterial SILVER = new ChestMaterial("silver", () -> GeneralConfig.chestInventoryMaterialFactorSilver);
    public static final ChestMaterial GOLD = new ChestMaterial("gold", () -> GeneralConfig.chestInventoryMaterialFactorGold);
    public static final ChestMaterial DIAMOND = new ChestMaterial("diamond", () -> GeneralConfig.chestInventoryMaterialFactorDiamond);
    public static final ChestMaterial OBSIDIAN = new ChestMaterial("obsidian", () -> GeneralConfig.chestInventoryMaterialFactorObsidian);
    private final String name;
    private final Supplier<Double> inventoryMultiplier;
    private final int index;
    private ColossalChest blockCore;
    private Interface blockInterface;
    private ChestWall blockWall;
    private CubeDetector chestDetector = null;
    private class_3917<ContainerColossalChest> container;

    public ChestMaterial(String name, Supplier<Double> inventoryMultiplier) {
        this.name = name;
        this.inventoryMultiplier = inventoryMultiplier;
        this.index = VALUES.size();
        VALUES.add(this);
        KEYED_VALUES.put(this.getName(), this);
    }

    public static ChestMaterial valueOf(String materialString) {
        return KEYED_VALUES.get(materialString.toLowerCase());
    }

    public static ChestMaterial valueOfSafe(String materialString) {
        ChestMaterial ret = ChestMaterial.valueOf(materialString);
        if (ret == null) {
            throw new JsonSyntaxException("Could not find a colossal chest material by name " + materialString + ". Allowed values: " + String.valueOf(VALUES.stream().map(ChestMaterial::getName).collect(Collectors.toList())));
        }
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public double getInventoryMultiplier() {
        return this.inventoryMultiplier.get();
    }

    public String getUnlocalizedName() {
        return "material.colossalchests." + this.getName();
    }

    public boolean isExplosionResistant() {
        return this == OBSIDIAN;
    }

    public int ordinal() {
        return this.index;
    }

    public ColossalChest getBlockCore() {
        return this.blockCore;
    }

    public void setBlockCore(ColossalChest blockCore) {
        if (this.blockCore != null) {
            throw new IllegalStateException("Tried registering multiple core blocks for " + this.getName());
        }
        this.blockCore = blockCore;
    }

    public Interface getBlockInterface() {
        return this.blockInterface;
    }

    public void setBlockInterface(Interface blockInterface) {
        if (this.blockInterface != null) {
            throw new IllegalStateException("Tried registering multiple core blocks for " + this.getName());
        }
        this.blockInterface = blockInterface;
    }

    public ChestWall getBlockWall() {
        return this.blockWall;
    }

    public void setBlockWall(ChestWall blockWall) {
        if (this.blockWall != null) {
            throw new IllegalStateException("Tried registering multiple core blocks for " + this.getName());
        }
        this.blockWall = blockWall;
    }

    public void setContainer(class_3917<ContainerColossalChest> container) {
        if (this.container != null) {
            throw new IllegalStateException("Tried registering multiple containers for " + this.getName());
        }
        this.container = container;
    }

    public class_3917<ContainerColossalChest> getContainer() {
        return this.container;
    }

    public CubeDetector getChestDetector() {
        if (this.chestDetector == null) {
            this.chestDetector = new HollowCubeDetector(new AllowedBlock[]{new AllowedBlock((class_2248)this.getBlockWall()), new AllowedBlock((class_2248)this.getBlockCore()).addCountValidator((IBlockCountValidator)new ExactBlockCountValidator(1)), new AllowedBlock((class_2248)this.getBlockInterface())}, (List)Lists.newArrayList((Object[])new class_2248[]{this.getBlockCore(), this.getBlockWall(), this.getBlockInterface()})).addSizeValidator((ISizeValidator)new MinimumSizeValidator(new class_2382(1, 1, 1))).addSizeValidator((ISizeValidator)new CubeSizeValidator()).addSizeValidator((ISizeValidator)new MaximumSizeValidator(this, BlockEntityColossalChest.getMaxSize()){

                public class_2382 getMaximumSize() {
                    return BlockEntityColossalChest.getMaxSize();
                }
            });
        }
        return this.chestDetector;
    }
}

