/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiFunction;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_9334;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.advancement.criterion.ChestFormedTrigger;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.IBlockChestMaterial;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.cyclopscore.block.BlockWithEntityGui;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.DetectionResult;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.IBlockEntityHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Interface;

public class ColossalChest
extends BlockWithEntityGui
implements CubeDetector.IDetectionListener,
IBlockChestMaterial {
    public static final class_2746 ENABLED = class_2741.field_12515;
    protected final ChestMaterial material;
    public final MapCodec<ColossalChest> codec;

    public ColossalChest(class_4970.class_2251 properties, ChestMaterial material, BiFunction<class_2338, class_2680, ? extends CyclopsBlockEntity> blockEntitySupplier) {
        super(properties, blockEntitySupplier);
        this.material = material;
        this.codec = class_4970.method_54094(props -> new ColossalChest((class_4970.class_2251)props, material, blockEntitySupplier));
        material.setBlockCore(this);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public class_3908 method_17454(class_2680 p_49234_, class_1937 p_49235_, class_2338 p_49236_) {
        return super.method_17454(p_49234_, p_49235_, p_49236_);
    }

    @javax.annotation.Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        return level.field_9236 ? class_2237.method_31618(blockEntityType, (class_2591)((class_2591)RegistryEntries.BLOCK_ENTITY_COLOSSAL_CHEST.comp_349()), BlockEntityColossalChest::lidAnimateTick) : null;
    }

    public void method_9588(class_2680 blockState, class_3218 level, class_2338 pos, class_5819 random) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BlockEntityColossalChest) {
            BlockEntityColossalChest uncolossalChest = (BlockEntityColossalChest)class_25862;
            uncolossalChest.recheckOpen();
        }
    }

    @Override
    public ChestMaterial getMaterial() {
        return this.material;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ENABLED});
    }

    public static boolean canPlace(class_4538 world, class_2338 pos) {
        for (class_2350 side : class_2350.values()) {
            class_2680 blockState = world.method_8320(pos.method_10093(side));
            class_2248 block = blockState.method_26204();
            if (!(block instanceof ColossalChest) && !(block instanceof ChestWall) && !(block instanceof Interface) || !blockState.method_28501().contains(ENABLED) || !((Boolean)blockState.method_11654((class_2769)ENABLED)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return this.codec;
    }

    public class_2464 method_9604(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)ENABLED) != false ? class_2464.field_11458 : super.method_9604(blockState);
    }

    public boolean method_9579(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)ENABLED);
    }

    public static DetectionResult triggerDetector(ChestMaterial material, class_1936 world, class_2338 blockPos, boolean valid, @javax.annotation.Nullable class_1657 player, boolean changeState) {
        class_2680 blockState;
        DetectionResult detectionResult = material.getChestDetector().detect((class_4538)world, blockPos, valid ? null : blockPos, (CubeDetector.IValidationAction)new MaterialValidationAction(), changeState);
        if (player instanceof class_3222 && detectionResult.getError() == null && ((Boolean)(blockState = world.method_8320(blockPos)).method_11654((class_2769)ENABLED)).booleanValue()) {
            BlockEntityColossalChest tile = IModHelpers.get().getBlockEntityHelpers().get((class_1922)world, blockPos, BlockEntityColossalChest.class).orElse(null);
            if (tile == null) {
                class_2338 corePos = ColossalChest.getCoreLocation(material, (class_4538)world, blockPos);
                tile = IModHelpers.get().getBlockEntityHelpers().get((class_1922)world, corePos, BlockEntityColossalChest.class).orElse(null);
            }
            ((ChestFormedTrigger)((Object)RegistryEntries.TRIGGER_CHEST_FORMED.comp_349())).test((class_3222)player, material, tile.getSizeSingular());
        }
        return detectionResult;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        BlockEntityColossalChest tile;
        super.method_9567(world, pos, state, placer, stack);
        if (stack.method_57826(class_9334.field_49631) && (tile = (BlockEntityColossalChest)IModHelpers.get().getBlockEntityHelpers().get((class_1922)world, pos, BlockEntityColossalChest.class).orElse(null)) != null) {
            tile.setCustomName(stack.method_7964());
            tile.setSize(class_2382.field_11176);
        }
        ColossalChest.triggerDetector(this.material, (class_1936)world, pos, true, placer instanceof class_1657 ? (class_1657)placer : null, true);
    }

    public void method_9615(class_2680 blockStateNew, class_1937 world, class_2338 blockPos, class_2680 blockStateOld, boolean isMoving) {
        super.method_9615(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!this.isCaptureBlockSnapshots(world) && blockStateNew.method_26204() != blockStateOld.method_26204() && !((Boolean)blockStateNew.method_11654((class_2769)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, (class_1936)world, blockPos, true, null, true);
        }
    }

    protected boolean isCaptureBlockSnapshots(class_1937 level) {
        return false;
    }

    public void onDetect(class_4538 world, class_2338 location, class_2382 size, boolean valid, class_2338 originCorner) {
        class_2248 block = world.method_8320(location).method_26204();
        if (block == this) {
            ((class_1945)world).method_8652(location, (class_2680)world.method_8320(location).method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(valid)), IModHelpers.get().getMinecraftHelpers().getBlockNotifyClient());
            BlockEntityColossalChest tile = IModHelpers.get().getBlockEntityHelpers().get((class_1922)world, location, BlockEntityColossalChest.class).orElse(null);
            if (tile != null) {
                tile.setMaterial(this.material);
                tile.setSize(valid ? size : class_2382.field_11176);
                tile.setCenter(new class_243((double)originCorner.method_10263() + (double)size.method_10263() / 2.0, (double)originCorner.method_10264() + (double)size.method_10264() / 2.0, (double)originCorner.method_10260() + (double)size.method_10260() / 2.0));
                tile.addInterface((class_2382)location);
            }
        }
    }

    @javax.annotation.Nullable
    public static class_2338 getCoreLocation(ChestMaterial material, class_4538 world, class_2338 blockPos) {
        Wrapper tileLocationWrapper = new Wrapper();
        material.getChestDetector().detect(world, blockPos, null, (location, blockState) -> {
            if (blockState.method_26204() instanceof ColossalChest) {
                tileLocationWrapper.set((Object)location);
            }
            return null;
        }, false);
        return (class_2338)tileLocationWrapper.get();
    }

    public static void addPlayerChatError(ChestMaterial material, class_1937 world, class_2338 blockPos, class_1657 player) {
        if (!world.field_9236 && player.method_5998(player.method_6058()).method_7960()) {
            DetectionResult result = material.getChestDetector().detect((class_4538)world, blockPos, null, (CubeDetector.IValidationAction)new MaterialValidationAction(), false);
            if (result != null && result.getError() != null) {
                ColossalChest.addPlayerChatError(player, result.getError());
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"multiblock.colossalchests.error.unexpected"), true);
            }
        }
    }

    public static void addPlayerChatError(class_1657 player, class_2561 error) {
        class_5250 chat = class_2561.method_43470((String)"");
        class_5250 prefix = class_2561.method_43470((String)"[").method_10852((class_2561)class_2561.method_43471((String)"multiblock.colossalchests.error.prefix")).method_10852((class_2561)class_2561.method_43470((String)"]: ")).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1080)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"multiblock.colossalchests.error.prefix.info"))));
        chat.method_10852((class_2561)prefix);
        chat.method_10852(error);
        player.method_7353((class_2561)chat, true);
    }

    public void writeExtraGuiData(class_2540 packetBuffer, class_1937 world, class_1657 player, class_2338 blockPos, class_3965 rayTraceResult) {
        IBlockEntityHelpers blockEntityHelpers = IModHelpers.get().getBlockEntityHelpers();
        blockEntityHelpers.setUnsafeBlockEntityGetter(true);
        blockEntityHelpers.get((class_1922)world, blockPos, BlockEntityColossalChest.class).ifPresent(tile -> packetBuffer.method_53002(tile.getInventory().method_5439()));
        blockEntityHelpers.setUnsafeBlockEntityGetter(false);
    }

    public class_1269 method_55766(class_2680 blockState, class_1937 world, class_2338 blockPos, class_1657 player, class_3965 rayTraceResult) {
        if (!((Boolean)blockState.method_11654((class_2769)ENABLED)).booleanValue()) {
            ColossalChest.addPlayerChatError(this.material, world, blockPos, player);
            return class_1269.field_5814;
        }
        return super.method_55766(blockState, world, blockPos, player, rayTraceResult);
    }

    public void method_9585(class_1936 world, class_2338 blockPos, class_2680 blockState) {
        if (((Boolean)blockState.method_11654((class_2769)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, world, blockPos, false, null, true);
        }
        super.method_9585(world, blockPos, blockState);
    }

    public boolean method_9558(class_2680 blockState, class_4538 world, class_2338 blockPos) {
        return super.method_9558(blockState, world, blockPos) && ColossalChest.canPlace(world, blockPos);
    }

    public void onBlockExplodedCommon(class_2680 state, class_3218 world, class_2338 pos, class_1927 explosion) {
        if (((Boolean)world.method_8320(pos).method_11654((class_2769)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, (class_1936)world, pos, false, null, true);
        }
        world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        this.method_9586(world, pos, explosion);
    }

    public float method_9520() {
        if (this.material.isExplosionResistant()) {
            return 10000.0f;
        }
        return 0.0f;
    }

    private static class MaterialValidationAction
    implements CubeDetector.IValidationAction {
        private final Wrapper<ChestMaterial> requiredMaterial = new Wrapper(null);

        public class_2561 onValidate(class_2338 blockPos, class_2680 blockState) {
            ChestMaterial material = null;
            if (blockState.method_26204() instanceof IBlockChestMaterial) {
                material = ((IBlockChestMaterial)blockState.method_26204()).getMaterial();
            }
            if (this.requiredMaterial.get() == null) {
                this.requiredMaterial.set((Object)material);
                return null;
            }
            return this.requiredMaterial.get() == material ? null : class_2561.method_43469((String)"multiblock.colossalchests.error.material", (Object[])new Object[]{class_2561.method_43471((String)material.getUnlocalizedName()), IModHelpers.get().getLocationHelpers().toCompactString(blockPos), class_2561.method_43471((String)((ChestMaterial)this.requiredMaterial.get()).getUnlocalizedName())});
        }
    }
}

