/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.blockentity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2618;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_4538;
import net.minecraft.class_5560;
import net.minecraft.class_5561;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ColossalChestConfig;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChest;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.INBTInventory;
import org.cyclops.cyclopscore.inventory.IndexedInventory;
import org.cyclops.cyclopscore.inventory.LargeInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;

public class BlockEntityColossalChest
extends CyclopsBlockEntity
implements class_3908,
class_2618 {
    private final class_5561 openersCounter = new class_5561(){

        protected void method_31681(class_1937 level, class_2338 pos, class_2680 blockState) {
            BlockEntityColossalChest.playSound(level, pos, blockState, class_3417.field_14982, BlockEntityColossalChest.this.getSizeSingular());
        }

        protected void method_31683(class_1937 level, class_2338 pos, class_2680 blockState) {
            BlockEntityColossalChest.playSound(level, pos, blockState, class_3417.field_14823, BlockEntityColossalChest.this.getSizeSingular());
        }

        protected void method_31682(class_1937 level, class_2338 pos, class_2680 blockState, int p_155364_, int p_155365_) {
            BlockEntityColossalChest.this.signalOpenCount(level, pos, blockState, p_155364_, p_155365_);
        }

        protected boolean method_31679(class_1657 player) {
            if (!(player.field_7512 instanceof ContainerColossalChest)) {
                return false;
            }
            class_1263 container = ((ContainerColossalChest)player.field_7512).getContainerInventory();
            return container == BlockEntityColossalChest.this.getInventory();
        }
    };
    private final class_5560 chestLidController = new class_5560();
    private SimpleInventory lastValidInventory = null;
    protected SimpleInventory inventory = null;
    @NBTPersist
    private class_2382 size = IModHelpers.get().getLocationHelpers().copyLocation(class_2382.field_11176);
    @NBTPersist
    private class_243 renderOffset = new class_243(0.0, 0.0, 0.0);
    private class_2561 customName = null;
    @NBTPersist
    private int materialId = 0;
    @NBTPersist
    private int rotation = 0;
    @NBTPersist(useDefaultValue=false)
    private List<class_2382> interfaceLocations = Lists.newArrayList();
    @NBTPersist
    private boolean disableDrops = false;
    private boolean recreateNullInventory = true;
    private EnumFacingMap<int[]> facingSlots = EnumFacingMap.newMap();

    public BlockEntityColossalChest(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)RegistryEntries.BLOCK_ENTITY_COLOSSAL_CHEST.comp_349(), blockPos, blockState);
    }

    public class_2382 getSize() {
        return this.size;
    }

    public void setSize(class_2382 size) {
        this.size = size;
        this.facingSlots.clear();
        if (this.isStructureComplete()) {
            this.setInventory((SimpleInventory)this.constructInventory());
            if (this.lastValidInventory != null) {
                int slot;
                for (slot = 0; slot < Math.min(this.lastValidInventory.method_5439(), this.inventory.method_5439()); ++slot) {
                    class_1799 contents = this.lastValidInventory.method_5438(slot);
                    if (contents.method_7960()) continue;
                    this.inventory.method_5447(slot, contents);
                    this.lastValidInventory.method_5447(slot, class_1799.field_8037);
                }
                if (slot < this.lastValidInventory.method_5439()) {
                    IModHelpers.get().getInventoryHelpers().dropItems(this.method_10997(), (class_1263)this.lastValidInventory, this.method_11016());
                }
                this.lastValidInventory = null;
            }
        } else {
            this.interfaceLocations.clear();
            if (this.inventory != null) {
                if (GeneralConfig.ejectItemsOnDestroy) {
                    IModHelpers.get().getInventoryHelpers().dropItems(this.method_10997(), (class_1263)this.inventory, this.method_11016());
                    this.lastValidInventory = null;
                } else {
                    this.lastValidInventory = this.inventory;
                }
            }
            this.setInventory((SimpleInventory)new LargeInventory(0, 0));
        }
        this.onDirty();
        IModHelpers.get().getBlockHelpers().markForUpdate(this.method_10997(), this.method_11016());
    }

    public void setMaterial(ChestMaterial material) {
        this.materialId = material.ordinal();
    }

    public ChestMaterial getMaterial() {
        return ChestMaterial.VALUES.get(this.materialId);
    }

    public SimpleInventory getLastValidInventory() {
        return this.lastValidInventory;
    }

    public void setLastValidInventory(SimpleInventory lastValidInventory) {
        this.lastValidInventory = lastValidInventory;
    }

    public int getSizeSingular() {
        return this.getSize().method_10263() + 1;
    }

    protected boolean isClientSide() {
        return this.method_10997() != null && this.method_10997().field_9236;
    }

    protected LargeInventory constructInventory() {
        if (!this.isClientSide() && GeneralConfig.creativeChests) {
            return this.constructInventoryDebug();
        }
        IndexedInventory inv = !this.isClientSide() ? new IndexedInventory(this.calculateInventorySize(), 64){

            public void method_5435(class_1657 entityPlayer) {
                if (!entityPlayer.method_7325()) {
                    super.method_5435(entityPlayer);
                    BlockEntityColossalChest.this.startOpen(entityPlayer);
                }
            }

            public void method_5432(class_1657 entityPlayer) {
                if (!entityPlayer.method_7325()) {
                    super.method_5432(entityPlayer);
                    BlockEntityColossalChest.this.stopOpen(entityPlayer);
                }
            }
        } : new LargeInventory(this.calculateInventorySize(), 64);
        inv.addDirtyMarkListener((IDirtyMarkListener)this);
        return inv;
    }

    protected LargeInventory constructInventoryDebug() {
        IndexedInventory inv = !this.isClientSide() ? new IndexedInventory(this.calculateInventorySize(), 64) : new LargeInventory(this.calculateInventorySize(), 64);
        Random random = new Random();
        for (int i = 0; i < inv.method_5439(); ++i) {
            inv.method_5447(i, new class_1799((class_1935)Iterables.get((Iterable)class_7923.field_41178, (int)random.nextInt(class_7923.field_41178.method_10204()))));
        }
        return inv;
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        SimpleInventory oldInventory = this.inventory;
        SimpleInventory oldLastInventory = this.lastValidInventory;
        this.inventory = null;
        this.lastValidInventory = null;
        this.recreateNullInventory = false;
        class_2487 tag = super.method_16887(provider);
        this.inventory = oldInventory;
        this.lastValidInventory = oldLastInventory;
        this.recreateNullInventory = true;
        return tag;
    }

    public void read(class_11368 input) {
        SimpleInventory oldInventory = this.inventory;
        SimpleInventory oldLastInventory = this.lastValidInventory;
        if (this.method_10997() != null && this.method_10997().field_9236) {
            this.inventory = null;
            this.lastValidInventory = null;
            this.recreateNullInventory = false;
        }
        super.read(input);
        if (this.method_10997() != null && this.method_10997().field_9236) {
            this.inventory = oldInventory;
            this.lastValidInventory = oldLastInventory;
            this.recreateNullInventory = true;
        } else {
            this.getInventory().read((class_11368)input.method_71420("inventory").orElseThrow());
            input.method_71420("lastValidInventory").ifPresent(child -> {
                this.lastValidInventory = new LargeInventory(((Integer)input.method_71439("lastValidInventorySize").orElseThrow()).intValue(), this.inventory.method_5444());
                this.lastValidInventory.read(child);
            });
        }
        this.customName = input.method_71426("CustomName", class_8824.field_46597).orElse(null);
    }

    public void method_11007(class_11372 output) {
        super.method_11007(output);
        if (this.customName != null) {
            output.method_71468("CustomName", class_8824.field_46597, (Object)this.customName);
        }
        if (this.inventory != null) {
            this.inventory.write(output.method_71461("inventory"));
        }
        if (this.lastValidInventory != null) {
            this.lastValidInventory.write(output.method_71461("lastValidInventory"));
            output.method_71465("lastValidInventorySize", this.lastValidInventory.method_5439());
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_39026((class_2586)this, (blockEntity, provider) -> this.method_16887((class_7225.class_7874)provider));
    }

    protected int calculateInventorySize() {
        int size = this.getSizeSingular();
        if (size == 1) {
            return 0;
        }
        return (int)Math.ceil(Math.pow(size, 3.0) * 27.0 * this.getMaterial().getInventoryMultiplier() / 9.0) * 9;
    }

    public void setInventory(SimpleInventory inventory) {
        this.inventory = inventory;
    }

    protected void ensureInventoryInitialized() {
        if (this.method_10997() != null && this.method_10997().field_9236 && (this.inventory == null || this.inventory.method_5439() != this.calculateInventorySize())) {
            this.setInventory((SimpleInventory)this.constructInventory());
        }
    }

    public INBTInventory getInventory() {
        if (this.lastValidInventory != null) {
            return new IndexedInventory();
        }
        this.ensureInventoryInitialized();
        if (this.inventory == null && this.recreateNullInventory) {
            this.setInventory((SimpleInventory)this.constructInventory());
        }
        return this.inventory;
    }

    public boolean canInteractWith(class_1657 entityPlayer) {
        return this.getSizeSingular() > 1 && super.canInteractWith(entityPlayer);
    }

    public void setCenter(class_243 center) {
        double dx = Math.abs(center.field_1352 - (double)this.method_11016().method_10263());
        double dz = Math.abs(center.field_1350 - (double)this.method_11016().method_10260());
        boolean equal = center.field_1352 - (double)this.method_11016().method_10263() == center.field_1350 - (double)this.method_11016().method_10260();
        class_2350 rotation = dx > dz || !equal && this.getSizeSingular() == 2 ? DirectionHelpers.getEnumFacingFromXSign((int)((int)Math.round(center.field_1352 - (double)this.method_11016().method_10263()))) : DirectionHelpers.getEnumFacingFromZSing((int)((int)Math.round(center.field_1350 - (double)this.method_11016().method_10260())));
        this.setRotation(rotation);
        this.renderOffset = new class_243((double)this.method_11016().method_10263() - center.field_1352, (double)this.method_11016().method_10264() - center.field_1351, (double)this.method_11016().method_10260() - center.field_1350);
    }

    public void setRotation(class_2350 rotation) {
        this.rotation = rotation.ordinal();
    }

    public class_2350 getRotation() {
        return class_2350.method_10143((int)this.rotation);
    }

    public class_243 getRenderOffset() {
        return this.renderOffset;
    }

    public void setRenderOffset(class_243 renderOffset) {
        this.renderOffset = renderOffset;
    }

    public static void detectStructure(class_4538 world, class_2338 location, class_2382 size, boolean valid, class_2338 originCorner) {
    }

    public boolean isStructureComplete() {
        return !this.getSize().equals((Object)class_2382.field_11176);
    }

    public static class_2382 getMaxSize() {
        int size = ColossalChestConfig.maxSize - 1;
        return new class_2382(size, size, size);
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public void setCustomName(class_2561 name) {
        this.customName = name;
    }

    public void addInterface(class_2382 blockPos) {
        this.interfaceLocations.add(blockPos);
    }

    public List<class_2382> getInterfaceLocations() {
        return Collections.unmodifiableList(this.interfaceLocations);
    }

    public class_2561 method_5476() {
        return this.hasCustomName() ? this.customName : class_2561.method_43469((String)"general.colossalchests.colossalchest", (Object[])new Object[]{class_2561.method_43471((String)this.getMaterial().getUnlocalizedName()), this.getSizeSingular()});
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 playerEntity) {
        return new ContainerColossalChest(id, playerInventory, (class_1263)this.getInventory());
    }

    static void playSound(class_1937 level, class_2338 pos, class_2680 blockState, class_3414 soundEvent, int size) {
        float increaseAngle = 0.15f / (float)Math.min(5, size);
        level.method_43128((class_1297)((class_1657)null), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, soundEvent, class_3419.field_15245, (float)(0.5 + 0.5 * Math.log(size)), level.field_9229.method_43057() * 0.1f + 0.45f + increaseAngle);
    }

    public boolean method_11004(int eventType, int value) {
        if (eventType == 1) {
            this.chestLidController.method_31674(value > 0);
            return true;
        }
        return super.method_11004(eventType, value);
    }

    public void startOpen(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.openersCounter.method_31684(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void stopOpen(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.openersCounter.method_31685(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void recheckOpen() {
        if (!this.field_11865) {
            this.openersCounter.method_31686(this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    protected void signalOpenCount(class_1937 level, class_2338 pos, class_2680 blockState, int p_155336_, int value) {
        class_2248 block = blockState.method_26204();
        level.method_8427(pos, block, 1, value);
    }

    public static void lidAnimateTick(class_1937 level, class_2338 pos, class_2680 blockState, BlockEntityColossalChest blockEntity) {
        blockEntity.chestLidController.method_31672();
    }

    public float method_11274(float value) {
        if (!GeneralConfig.visuallyOpen) {
            return 0.0f;
        }
        return this.chestLidController.method_31673(value);
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        super.method_66473(pos, state);
        if (!this.disableDrops) {
            SimpleInventory lastInventory = this.getLastValidInventory();
            IModHelpers.get().getInventoryHelpers().dropItems(this.method_10997(), (class_1263)(lastInventory != null ? lastInventory : this.getInventory()), pos);
        }
    }

    public void disableDrops() {
        this.disableDrops = true;
    }
}

