/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.client.render.blockentity;

import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.Map;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.colossalchests.client.render.blockentity.RenderTileEntityChestBase;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class RenderTileEntityColossalChest
extends RenderTileEntityChestBase<BlockEntityColossalChest> {
    public static final Map<ChestMaterial, class_2960> TEXTURES_CHEST = Maps.newHashMap();
    public static final Map<ChestMaterial, class_2960> TEXTURES_INTERFACE = Maps.newHashMap();

    public RenderTileEntityColossalChest(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void handleRotation(BlockEntityColossalChest blockEntity, class_4587 poseStack) {
        if (blockEntity.isStructureComplete()) {
            class_243 renderOffset = blockEntity.getRenderOffset();
            poseStack.method_22904(-renderOffset.field_1352, -renderOffset.field_1351, -renderOffset.field_1350);
        }
        super.handleRotation(blockEntity, poseStack);
        poseStack.method_46416(0.0f, (float)blockEntity.getSizeSingular() * 0.0625f, 0.0f);
        float size = (float)blockEntity.getSizeSingular() * 1.125f;
        poseStack.method_22905(size, size, size);
    }

    public void render(BlockEntityColossalChest tile, float partialTicks, class_4587 matrixStack, class_4597 renderTypeBuffer, int combinedLightIn, int combinedOverlayIn, class_243 cameraPos) {
        if (tile.isStructureComplete()) {
            matrixStack.method_22903();
            super.method_3569(tile, partialTicks, matrixStack, renderTypeBuffer, combinedLightIn, combinedOverlayIn, cameraPos);
            if (tile.isStructureComplete() && tile.method_11274(0.0f) == 0.0f && (GeneralConfig.alwaysShowInterfaceOverlay || class_310.method_1551().field_1724.method_18276())) {
                matrixStack.method_22903();
                class_4730 materialInterface = this.getMaterialInterface(tile);
                class_4588 buffer = materialInterface.method_24145(renderTypeBuffer, class_1921::method_23028);
                for (class_2382 interfaceLocation : tile.getInterfaceLocations()) {
                    float translateX = interfaceLocation.method_10263() - tile.method_11016().method_10263();
                    float translateY = interfaceLocation.method_10264() - tile.method_11016().method_10264();
                    float translateZ = interfaceLocation.method_10260() - tile.method_11016().method_10260();
                    matrixStack.method_46416(translateX, translateY, translateZ);
                    this.renderInterface(matrixStack, buffer, materialInterface.method_24148(), interfaceLocation.equals((Object)tile.method_11016()), combinedLightIn);
                    matrixStack.method_46416(-translateX, -translateY, -translateZ);
                }
                matrixStack.method_22909();
            }
            matrixStack.method_22909();
        }
    }

    public boolean method_3563() {
        return true;
    }

    @Override
    protected class_2350 getDirection(BlockEntityColossalChest tile) {
        return tile.getRotation().method_10153();
    }

    @Override
    protected class_4730 getMaterial(BlockEntityColossalChest tile) {
        return new class_4730(class_4722.field_21709, TEXTURES_CHEST.get(tile.getMaterial()));
    }

    protected class_4730 getMaterialInterface(BlockEntityColossalChest tile) {
        return new class_4730(class_1059.field_5275, TEXTURES_INTERFACE.get(tile.getMaterial()));
    }

    protected void setMatrixOrientation(class_4587 matrixStack, class_2350 direction) {
        float translateX = -1.0f - (float)direction.method_10148();
        float translateY = direction.method_10164();
        float translateZ = direction.method_10165();
        if (direction == class_2350.field_11043) {
            translateZ += 1.0f;
            translateX += 2.0f;
            translateY -= 1.0f;
        } else if (direction == class_2350.field_11034) {
            translateX += 3.0f;
            translateY -= 1.0f;
            translateZ += 1.0f;
        } else if (direction == class_2350.field_11039) {
            translateY -= 1.0f;
        } else if (direction == class_2350.field_11035) {
            translateX += 1.0f;
            translateY -= 1.0f;
        } else if (direction == class_2350.field_11036) {
            translateX += 1.0f;
            translateZ += 1.0f;
        } else if (direction == class_2350.field_11033) {
            translateX += 1.0f;
        }
        matrixStack.method_46416(translateX * 16.0f, translateY * 16.0f, translateZ * 16.0f);
        int rotationY = 0;
        int rotationX = 0;
        if (direction == class_2350.field_11035) {
            rotationY = 0;
        } else if (direction == class_2350.field_11043) {
            rotationY = 180;
        } else if (direction == class_2350.field_11034) {
            rotationY = 90;
        } else if (direction == class_2350.field_11039) {
            rotationY = -90;
        } else if (direction == class_2350.field_11036) {
            rotationX = -90;
        } else if (direction == class_2350.field_11033) {
            rotationX = 90;
        }
        matrixStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)rotationY));
        matrixStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees((float)rotationX));
    }

    protected void renderInterface(class_4587 matrixStack, class_4588 buffer, class_1058 sprite, boolean core, int combinedLightIn) {
        for (class_2350 side : class_2350.values()) {
            matrixStack.method_22903();
            float scale = 0.063f;
            matrixStack.method_22905(scale, scale, scale);
            matrixStack.method_22905(1.0f, -1.0f, 1.0f);
            this.setMatrixOrientation(matrixStack, side);
            float indent = -0.2f;
            if (side == class_2350.field_11036) {
                indent = -15.8f;
            }
            if (side == class_2350.field_11033) {
                indent *= 2.0f;
            }
            int alpha = 255;
            float posMin = core ? 5.0f : 6.0f;
            float posMax = 16.0f - posMin;
            float uvScale = posMin / 16.0f;
            float uMin = (sprite.method_4577() - sprite.method_4594()) * uvScale + sprite.method_4594();
            float uMax = (sprite.method_4577() - sprite.method_4594()) * (1.0f - uvScale) + sprite.method_4594();
            float vMin = (sprite.method_4575() - sprite.method_4593()) * uvScale + sprite.method_4593();
            float vMax = (sprite.method_4575() - sprite.method_4593()) * (1.0f - uvScale) + sprite.method_4593();
            Matrix4f matrix = matrixStack.method_23760().method_23761();
            buffer.method_22918(matrix, posMax, posMax, indent).method_1336(255, 255, 255, alpha).method_22913(uMin, vMax).method_60803(combinedLightIn);
            buffer.method_22918(matrix, posMax, posMin, indent).method_1336(255, 255, 255, alpha).method_22913(uMin, vMin).method_60803(combinedLightIn);
            buffer.method_22918(matrix, posMin, posMin, indent).method_1336(255, 255, 255, alpha).method_22913(uMax, vMin).method_60803(combinedLightIn);
            buffer.method_22918(matrix, posMin, posMax, indent).method_1336(255, 255, 255, alpha).method_22913(uMax, vMax).method_60803(combinedLightIn);
            matrixStack.method_22909();
        }
    }

    static {
        Calendar calendar = Calendar.getInstance();
        boolean christmas = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
        TEXTURES_CHEST.put(ChestMaterial.WOOD, class_2960.method_60654((String)("entity/chest/" + (christmas ? "christmas" : "normal"))));
        TEXTURES_CHEST.put(ChestMaterial.COPPER, class_2960.method_60655((String)"colossalchests", (String)"models/chest_copper"));
        TEXTURES_CHEST.put(ChestMaterial.IRON, class_2960.method_60655((String)"colossalchests", (String)"models/chest_iron"));
        TEXTURES_CHEST.put(ChestMaterial.SILVER, class_2960.method_60655((String)"colossalchests", (String)"models/chest_silver"));
        TEXTURES_CHEST.put(ChestMaterial.GOLD, class_2960.method_60655((String)"colossalchests", (String)"models/chest_gold"));
        TEXTURES_CHEST.put(ChestMaterial.DIAMOND, class_2960.method_60655((String)"colossalchests", (String)"models/chest_diamond"));
        TEXTURES_CHEST.put(ChestMaterial.OBSIDIAN, class_2960.method_60655((String)"colossalchests", (String)"models/chest_obsidian"));
        TEXTURES_INTERFACE.put(ChestMaterial.WOOD, class_2960.method_60655((String)"colossalchests", (String)"blocks/interface_wood"));
        TEXTURES_INTERFACE.put(ChestMaterial.COPPER, class_2960.method_60655((String)"colossalchests", (String)"blocks/interface_copper"));
        TEXTURES_INTERFACE.put(ChestMaterial.IRON, class_2960.method_60655((String)"colossalchests", (String)"blocks/interface_iron"));
        TEXTURES_INTERFACE.put(ChestMaterial.SILVER, class_2960.method_60655((String)"colossalchests", (String)"blocks/interface_silver"));
        TEXTURES_INTERFACE.put(ChestMaterial.GOLD, class_2960.method_60655((String)"colossalchests", (String)"blocks/interface_gold"));
        TEXTURES_INTERFACE.put(ChestMaterial.DIAMOND, class_2960.method_60655((String)"colossalchests", (String)"blocks/interface_diamond"));
        TEXTURES_INTERFACE.put(ChestMaterial.OBSIDIAN, class_2960.method_60655((String)"colossalchests", (String)"blocks/interface_obsidian"));
    }
}

