/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.inventory.container;

import com.google.common.collect.Lists;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3917;
import org.apache.logging.log4j.Level;
import org.cyclops.colossalchests.ColossalChestsInstance;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.network.packet.ClientboundContainerSetContentPacketWindow;
import org.cyclops.colossalchests.network.packet.ClientboundContainerSetSlotPacketLarge;
import org.cyclops.cyclopscore.inventory.LargeInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.PacketBase;

public class ContainerColossalChest
extends ScrollingInventoryContainer<class_1735> {
    private static final int INVENTORY_OFFSET_X = 9;
    private static final int INVENTORY_OFFSET_Y = 112;
    private static final int CHEST_INVENTORY_OFFSET_X = 9;
    private static final int CHEST_INVENTORY_OFFSET_Y = 18;
    public static final int CHEST_INVENTORY_ROWS = 5;
    public static final int CHEST_INVENTORY_COLUMNS = 9;
    private final List<class_1735> chestSlots = Lists.newArrayListWithCapacity((int)this.getSizeInventory());
    private final class_2371<class_1799> inventoryItemStacks = class_2371.method_10213((int)this.getSizeInventory(), (Object)class_1799.field_8037);
    private int lastInventoryState = -2;
    private boolean firstDetectionCheck = true;

    public ContainerColossalChest(int id, class_1661 playerInventory, class_2540 data) {
        this(id, playerInventory, (class_1263)new LargeInventory(data.readInt(), 64));
    }

    public ContainerColossalChest(int id, class_1661 playerInventory, class_1263 inventory) {
        super((class_3917)RegistryEntries.CONTAINER_COLOSSAL_CHEST.comp_349(), id, playerInventory, inventory, Collections.emptyList(), (item, pattern) -> true);
        this.addChestSlots(this.getSizeInventory() / 9, 9);
        this.addPlayerInventory(playerInventory, 9, 112);
        this.updateFilter("");
    }

    protected List<class_1735> getUnfilteredItems() {
        return this.chestSlots;
    }

    protected void addChestSlots(int rows, int columns) {
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                class_1735 slot = this.makeSlot(this.inventory, column + row * columns, 9 + column * 18, 18 + row * 18);
                this.method_7621(slot);
                this.chestSlots.add(slot);
            }
        }
    }

    protected class_1735 makeSlot(class_1263 inventory, int index, int row, int column) {
        return new SlotExtended(inventory, index, row, column);
    }

    public int getColumns() {
        return 9;
    }

    public int getPageSize() {
        return 5;
    }

    protected void disableSlot(int slotIndex) {
        class_1735 slot = this.method_7611(slotIndex);
        ContainerExtended.setSlotPosX((class_1735)slot, (int)Integer.MIN_VALUE);
        ContainerExtended.setSlotPosY((class_1735)slot, (int)Integer.MIN_VALUE);
    }

    protected void enableSlot(int slotIndex, int row, int column) {
        class_1735 slot = this.method_7611(slotIndex);
        ContainerExtended.setSlotPosX((class_1735)slot, (int)(9 + column * 18));
        ContainerExtended.setSlotPosY((class_1735)slot, (int)(18 + row * 18));
    }

    public void onScroll(int firstRow) {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.disableSlot(i);
        }
        super.onScroll(firstRow);
    }

    protected void enableElementAt(int visibleIndex, int elementIndex, class_1735 element) {
        super.enableElementAt(visibleIndex, elementIndex, (Object)element);
        int column = visibleIndex % this.getColumns();
        int row = (visibleIndex - column) / this.getColumns();
        this.enableSlot(elementIndex, row, column);
    }

    public void method_7596(class_1712 listener) {
        if (this.field_7765.contains(listener)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.field_7765.add(listener);
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            if (serverPlayer.field_29181 == listener) {
                this.updateCraftingInventory(serverPlayer, (List<class_1799>)this.method_7602());
            }
        }
        this.method_7623();
    }

    public void method_7623() {
        int newState = ((SimpleInventory)this.inventory).getState();
        if (this.lastInventoryState != newState) {
            this.lastInventoryState = newState;
            this.detectAndSendChangesOverride();
        }
    }

    protected void detectAndSendChangesOverride() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            class_1799 itemstack = ((class_1735)this.field_7761.get(i)).method_7677();
            class_1799 itemstack1 = (class_1799)this.inventoryItemStacks.get(i);
            if (class_1799.method_7973((class_1799)itemstack1, (class_1799)itemstack)) continue;
            itemstack1 = itemstack.method_7960() ? class_1799.field_8037 : itemstack.method_7972();
            this.inventoryItemStacks.set(i, (Object)itemstack1);
            if (this.firstDetectionCheck) continue;
            for (int j = 0; j < this.field_7765.size(); ++j) {
                class_1712 listener = (class_1712)this.field_7765.get(j);
                class_1657 class_16572 = this.player;
                if (class_16572 instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)class_16572;
                    if (serverPlayer.field_29181 == listener) {
                        this.sendSlotContentsToPlayer(serverPlayer, (class_1703)this, i, itemstack1);
                        continue;
                    }
                }
                listener.method_7635((class_1703)this, i, itemstack1);
            }
        }
        this.firstDetectionCheck = false;
    }

    protected void sendSlotContentsToPlayer(class_3222 player, class_1703 containerToSend, int slotInd, class_1799 stack) {
        if (!(containerToSend.method_7611(slotInd) instanceof class_1734)) {
            ColossalChestsInstance.MOD.getPacketHandler().sendToPlayer((PacketBase)new ClientboundContainerSetSlotPacketLarge(containerToSend.field_7763, this.method_37421(), slotInd, stack), player);
        }
    }

    protected int getTagSize(class_2520 tag) {
        if (tag instanceof class_2514 || tag instanceof class_2491) {
            return 1;
        }
        if (tag instanceof class_2487) {
            class_2487 compound = (class_2487)tag;
            int size = 0;
            for (String key : compound.method_10541()) {
                try {
                    size += key.getBytes("UTF-8").length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                size += this.getTagSize(compound.method_10580(key));
            }
            return size;
        }
        if (tag instanceof class_2479) {
            return ((class_2479)tag).method_10521().length;
        }
        if (tag instanceof class_2495) {
            return ((class_2495)tag).method_10588().length * 32;
        }
        if (tag instanceof class_2499) {
            class_2499 list = (class_2499)tag;
            int size = 0;
            for (int i = 0; i < list.size(); ++i) {
                size += this.getTagSize(list.method_10534(i));
            }
            return size;
        }
        if (tag instanceof class_2519) {
            try {
                return ((String)tag.method_68658().orElseThrow()).getBytes("UTF-8").length + 1;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return tag.toString().length();
    }

    public void updateCraftingInventory(class_3222 player, List<class_1799> allItems) {
        int maxBufferSize = GeneralConfig.maxPacketBufferSize;
        class_3244 playerNetServerHandler = player.field_13987;
        class_2487 sendBuffer = new class_2487();
        class_2499 sendList = new class_2499();
        sendBuffer.method_10566("stacks", (class_2520)sendList);
        int i = 0;
        int bufferSize = 0;
        boolean sent = false;
        for (class_1799 itemStack : allItems) {
            if (itemStack != null) {
                class_2487 tag = new class_2487();
                tag.method_10569("slot", i);
                try {
                    tag.method_10566("stack", (class_2520)class_1799.field_49266.encodeStart((DynamicOps)player.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)itemStack).getOrThrow(JsonParseException::new));
                }
                catch (JsonParseException e) {
                    ColossalChestsInstance.MOD.log(Level.ERROR, "Error while attempting to send a stack to a client " + String.valueOf(itemStack));
                    e.printStackTrace();
                }
                int tagSize = this.getTagSize((class_2520)tag);
                if (bufferSize + tagSize + 100 < maxBufferSize) {
                    sendList.add((Object)tag);
                    bufferSize += tagSize;
                } else {
                    ColossalChestsInstance.MOD.getPacketHandler().sendToPlayer((PacketBase)new ClientboundContainerSetContentPacketWindow(this.field_7763, this.method_37421(), sendBuffer), player);
                    sendBuffer = new class_2487();
                    sendList = new class_2499();
                    sendList.add((Object)tag);
                    sendBuffer.method_10566("stacks", (class_2520)sendList);
                    bufferSize = tagSize;
                }
            }
            ++i;
        }
        if (sendList.size() > 0) {
            ColossalChestsInstance.MOD.getPacketHandler().sendToPlayer((PacketBase)new ClientboundContainerSetContentPacketWindow(this.field_7763, this.method_37421(), sendBuffer), player);
        }
        playerNetServerHandler.method_14364((class_2596)new class_2653(-1, this.method_37421(), -1, this.method_34255()));
    }
}

