/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.advancement.criterion.ChestFormedTrigger;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.IBlockChestMaterial;
import org.cyclops.colossalchests.block.Interface;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.colossalchests.blockentity.BlockEntityInterface;
import org.cyclops.cyclopscore.block.multi.DetectionResult;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.IInventoryHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.cyclopscore.inventory.SimpleInventory;

public class ItemUpgradeTool
extends class_1792 {
    private final boolean upgrade;

    public ItemUpgradeTool(class_1792.class_1793 properties, boolean upgrade) {
        super(properties);
        this.upgrade = upgrade;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 itemStack = context.method_8041();
        class_2680 blockState = context.method_8045().method_8320(context.method_8037());
        if (blockState.method_26204() instanceof IBlockChestMaterial && ((Boolean)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(blockState, (class_2769)ColossalChest.ENABLED, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            class_2338 tileLocation = ColossalChest.getCoreLocation(((IBlockChestMaterial)blockState.method_26204()).getMaterial(), (class_4538)context.method_8045(), context.method_8037());
            BlockEntityColossalChest tile = IModHelpers.get().getBlockEntityHelpers().get((class_1922)context.method_8045(), tileLocation, BlockEntityColossalChest.class).orElse(null);
            ChestMaterial newType = this.transformType(itemStack, tile.getMaterial());
            if (newType == null) {
                if (context.method_8045().method_8608()) {
                    return class_1269.field_5811;
                }
                ColossalChest.addPlayerChatError(context.method_8036(), (class_2561)class_2561.method_43471((String)"multiblock.colossalchests.error.upgradeLimit"));
                return class_1269.field_5814;
            }
            class_2561 firstError = null;
            do {
                class_2561 error;
                if ((error = this.attemptTransform(context.method_8045(), context.method_8037(), context.method_8036(), tile, newType, tile.getMaterial(), context.method_20287())) != null) {
                    if (firstError != null) continue;
                    firstError = error;
                    continue;
                }
                return context.method_8045().method_8608() ? class_1269.field_5811 : class_1269.field_5812;
            } while ((newType = this.transformType(itemStack, newType)) != null);
            ColossalChest.addPlayerChatError(context.method_8036(), firstError);
            return context.method_8045().method_8608() ? class_1269.field_5811 : class_1269.field_5814;
        }
        return context.method_8045().method_8608() ? class_1269.field_5811 : class_1269.field_5812;
    }

    protected class_2561 attemptTransform(class_1937 world, class_2338 pos, class_1657 player, BlockEntityColossalChest tile, ChestMaterial newType, ChestMaterial currentType, class_1268 hand) {
        class_2382 size = tile.getSize();
        ChestMaterial validMaterial = null;
        Wrapper requiredCoresCount = new Wrapper((Object)0);
        Wrapper requiredInterfacesCount = new Wrapper((Object)0);
        Wrapper requiredWallsCount = new Wrapper((Object)0);
        for (ChestMaterial material : ChestMaterial.VALUES) {
            DetectionResult result = material.getChestDetector().detect((class_4538)world, pos, null, (location, blockState) -> {
                if (blockState.method_26204() instanceof ColossalChest) {
                    requiredCoresCount.set((Object)((Integer)requiredCoresCount.get() + 1));
                } else if (blockState.method_26204() instanceof Interface) {
                    requiredInterfacesCount.set((Object)((Integer)requiredInterfacesCount.get() + 1));
                } else if (blockState.method_26204() instanceof ChestWall) {
                    requiredWallsCount.set((Object)((Integer)requiredWallsCount.get() + 1));
                }
                return null;
            }, false);
            if (result.getError() != null) continue;
            validMaterial = material;
            break;
        }
        class_1799 requiredCores = new class_1799((class_1935)newType.getBlockCore(), ((Integer)requiredCoresCount.get()).intValue());
        class_1799 requiredInterfaces = new class_1799((class_1935)newType.getBlockInterface(), ((Integer)requiredInterfacesCount.get()).intValue());
        class_1799 requiredWalls = new class_1799((class_1935)newType.getBlockWall(), ((Integer)requiredWallsCount.get()).intValue());
        if (validMaterial == null) {
            return class_2561.method_43471((String)"multiblock.colossalchests.error.unexpected");
        }
        if (!(this.consumeItems(player, requiredCores, true) && this.consumeItems(player, requiredInterfaces, true) && this.consumeItems(player, requiredWalls, true))) {
            return class_2561.method_43469((String)"multiblock.colossalchests.error.upgrade", (Object[])new Object[]{requiredCores.method_7947(), requiredInterfaces.method_7947(), requiredWalls.method_7947(), class_2561.method_43471((String)newType.getUnlocalizedName())});
        }
        this.consumeItems(player, requiredCores.method_7972(), false);
        this.consumeItems(player, requiredInterfaces.method_7972(), false);
        this.consumeItems(player, requiredWalls.method_7972(), false);
        if (!world.field_9236) {
            tile.setSize(class_2382.field_11176);
            SimpleInventory oldInventory = tile.getLastValidInventory();
            class_2350 oldRotation = tile.getRotation();
            class_243 oldRenderOffset = tile.getRenderOffset();
            ArrayList oldInterfaceLocations = Lists.newArrayList(tile.getInterfaceLocations());
            tile.disableDrops();
            Wrapper coreLocation = new Wrapper(null);
            ArrayList interfaceLocations = Lists.newArrayList();
            validMaterial.getChestDetector().detect((class_4538)world, pos, null, (location, blockState) -> {
                class_2680 blockStateNew = null;
                if (blockState.method_26204() instanceof ColossalChest) {
                    coreLocation.set((Object)location);
                    blockStateNew = newType.getBlockCore().method_9564();
                } else if (blockState.method_26204() instanceof Interface) {
                    blockStateNew = newType.getBlockInterface().method_9564();
                    interfaceLocations.add(location);
                } else if (blockState.method_26204() instanceof ChestWall) {
                    blockStateNew = newType.getBlockWall().method_9564();
                }
                world.method_8652(location, (class_2680)blockStateNew.method_11657((class_2769)ColossalChest.ENABLED, (Comparable)((Boolean)blockState.method_11654((class_2769)ColossalChest.ENABLED))), IModHelpers.get().getMinecraftHelpers().getBlockNotifyClient());
                if (blockState.method_26204() instanceof ColossalChest || blockState.method_26204() instanceof Interface) {
                    tile.addInterface((class_2382)location);
                }
                return null;
            }, false);
            BlockEntityColossalChest tileNew = (BlockEntityColossalChest)((Object)IModHelpers.get().getBlockEntityHelpers().get((class_1922)world, (class_2338)coreLocation.get(), BlockEntityColossalChest.class).orElseThrow(() -> new IllegalStateException("Could not find a colossal chest core location during upgrading.")));
            tileNew.setLastValidInventory(oldInventory);
            tileNew.setMaterial(newType);
            tileNew.setRotation(oldRotation);
            tileNew.setRenderOffset(oldRenderOffset);
            for (class_2382 oldInterfaceLocation : oldInterfaceLocations) {
                tileNew.addInterface(oldInterfaceLocation);
            }
            tileNew.setSize(size);
            for (class_2338 interfaceLocation : interfaceLocations) {
                BlockEntityInterface tileInterface = (BlockEntityInterface)((Object)IModHelpers.get().getBlockEntityHelpers().get((class_1922)world, interfaceLocation, BlockEntityInterface.class).orElseThrow(() -> new IllegalStateException("Could not find a colossal chest interface location during upgrading.")));
                tileInterface.setCorePosition((class_2382)coreLocation.get());
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ((ChestFormedTrigger)((Object)RegistryEntries.TRIGGER_CHEST_FORMED.comp_349())).test(serverPlayer, newType, size.method_10263() + 1);
            }
        }
        class_1799 returnedCores = new class_1799((class_1935)currentType.getBlockCore(), requiredCores.method_7947());
        class_1799 returnedInterfaces = new class_1799((class_1935)currentType.getBlockInterface(), requiredInterfaces.method_7947());
        class_1799 returnedWalls = new class_1799((class_1935)currentType.getBlockWall(), requiredWalls.method_7947());
        IInventoryHelpers inventoryHelpers = IModHelpers.get().getInventoryHelpers();
        inventoryHelpers.tryReAddToStack(player, class_1799.field_8037, returnedCores, hand);
        inventoryHelpers.tryReAddToStack(player, class_1799.field_8037, returnedInterfaces, hand);
        inventoryHelpers.tryReAddToStack(player, class_1799.field_8037, returnedWalls, hand);
        return null;
    }

    protected boolean consumeItems(class_1657 player, class_1799 consumeStack, boolean simulate) {
        if (player.method_68878()) {
            return true;
        }
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        int validItems = 0;
        while (it.hasNext()) {
            class_1799 stack = it.next();
            if (stack.method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)consumeStack)) continue;
            int previousValidItems = validItems;
            validItems += stack.method_7947();
            validItems = Math.min(consumeStack.method_7947(), validItems);
            if (simulate) continue;
            stack.method_7934(validItems - previousValidItems);
            it.replace(stack.method_7947() == 0 ? class_1799.field_8037 : stack);
        }
        return validItems == consumeStack.method_7947();
    }

    protected ChestMaterial transformType(class_1799 itemStack, ChestMaterial type) {
        if (this.upgrade && type.ordinal() < ChestMaterial.VALUES.size() - 1) {
            return ChestMaterial.VALUES.get(type.ordinal() + 1);
        }
        if (!this.upgrade && type.ordinal() > 0) {
            return ChestMaterial.VALUES.get(type.ordinal() - 1);
        }
        return null;
    }
}

