/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.IBlockChestMaterial;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class ChestWall
extends Block
implements CubeDetector.IDetectionListener,
IBlockChestMaterial {
    public static final BooleanProperty ENABLED = ColossalChest.ENABLED;
    protected final ChestMaterial material;

    public ChestWall(BlockBehaviour.Properties properties, ChestMaterial material) {
        super(properties);
        this.material = material;
        material.setBlockWall(this);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public String getDescriptionId() {
        String baseKey = super.getDescriptionId();
        return baseKey.substring(0, baseKey.lastIndexOf(95));
    }

    @Override
    public ChestMaterial getMaterial() {
        return this.material;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ENABLED});
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)ENABLED) != false ? RenderShape.ENTITYBLOCK_ANIMATED : super.getRenderShape(blockState);
    }

    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockReader, BlockPos blockPos) {
        return (Boolean)blockState.getValue((Property)ENABLED);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(world, pos, state, placer, stack);
        ColossalChest.triggerDetector(this.material, (LevelAccessor)world, pos, true, placer instanceof Player ? (Player)placer : null, this.canBlockSnapshotsBeCaptured());
    }

    public void onPlace(BlockState blockStateNew, Level world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.onPlace(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!this.isCaptureBlockSnapshots(world) && blockStateNew.getBlock() != blockStateOld.getBlock() && !((Boolean)blockStateNew.getValue((Property)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, (LevelAccessor)world, blockPos, true, null, true);
        }
    }

    protected boolean canBlockSnapshotsBeCaptured() {
        return false;
    }

    protected boolean isCaptureBlockSnapshots(Level level) {
        return false;
    }

    public void destroy(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (((Boolean)blockState.getValue((Property)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, world, blockPos, false, null, true);
        }
        super.destroy(world, blockPos, blockState);
    }

    public void onDetect(LevelReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.getBlockState(location).getBlock();
        if (block == this) {
            boolean change = (Boolean)world.getBlockState(location).getValue((Property)ENABLED) == false;
            ((LevelWriter)world).setBlock(location, (BlockState)world.getBlockState(location).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(valid)), IModHelpers.get().getMinecraftHelpers().getBlockNotifyClient());
            if (change) {
                BlockEntityColossalChest.detectStructure(world, location, size, valid, originCorner);
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level world, BlockPos blockPos, Player player, BlockHitResult rayTraceResult) {
        if (((Boolean)blockState.getValue((Property)ENABLED)).booleanValue()) {
            BlockPos tileLocation = ColossalChest.getCoreLocation(this.material, (LevelReader)world, blockPos);
            if (tileLocation != null) {
                return world.getBlockState(tileLocation).useWithoutItem(world, player, rayTraceResult.withPosition(tileLocation));
            }
        } else {
            ColossalChest.addPlayerChatError(this.material, world, blockPos, player);
            return InteractionResult.FAIL;
        }
        return super.useWithoutItem(blockState, world, blockPos, player, rayTraceResult);
    }

    public boolean canSurvive(BlockState blockState, LevelReader world, BlockPos blockPos) {
        return super.canSurvive(blockState, world, blockPos) && ColossalChest.canPlace(world, blockPos);
    }

    public void onBlockExplodedCommon(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (((Boolean)world.getBlockState(pos).getValue((Property)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, (LevelAccessor)world, pos, false, null, true);
        }
        world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        this.wasExploded(world, pos, explosion);
    }

    public float getExplosionResistance() {
        if (this.material.isExplosionResistant()) {
            return 10000.0f;
        }
        return 0.0f;
    }
}

