/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.item;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.Block;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;

public class ItemBlockMaterial
extends BlockItem {
    private final ChestMaterial material;

    public ItemBlockMaterial(Block block, Item.Properties builder, ChestMaterial material) {
        super(block, builder);
        this.material = material;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept((Component)Component.translatable((String)this.material.getUnlocalizedName()).withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
    }

    public static <M extends IModBase> BiFunction<BlockConfigCommon<M>, Block, ? extends Item> getItemConstructor(ChestMaterial material, String descriptionSuffix) {
        return (eConfig, block) -> new ItemBlockMaterial((Block)block, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)eConfig.getResourceKey().location())).overrideDescription("block.colossalchests." + descriptionSuffix), material);
    }
}

