/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.cyclops.colossalchests.ColossalChests;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.network.packet.ClientboundContainerSetContentPacketWindow;
import org.cyclops.colossalchests.network.packet.ClientboundContainerSetSlotPacketLarge;
import org.cyclops.cyclopscore.inventory.LargeInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.PacketBase;

@ChestContainer(isLargeChest=true)
public class ContainerColossalChest
extends ScrollingInventoryContainer<Slot> {
    private static final int INVENTORY_OFFSET_X = 9;
    private static final int INVENTORY_OFFSET_Y = 112;
    private static final int CHEST_INVENTORY_OFFSET_X = 9;
    private static final int CHEST_INVENTORY_OFFSET_Y = 18;
    public static final int CHEST_INVENTORY_ROWS = 5;
    public static final int CHEST_INVENTORY_COLUMNS = 9;
    private final List<Slot> chestSlots = Lists.newArrayListWithCapacity((int)this.getSizeInventory());
    private final NonNullList<ItemStack> inventoryItemStacks = NonNullList.m_122780_((int)this.getSizeInventory(), (Object)ItemStack.f_41583_);
    private int lastInventoryState = -2;
    private boolean firstDetectionCheck = true;

    public ContainerColossalChest(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, (Container)new LargeInventory(data.readInt(), 64));
    }

    public ContainerColossalChest(int id, Inventory playerInventory, Container inventory) {
        super(RegistryEntries.CONTAINER_COLOSSAL_CHEST, id, playerInventory, inventory, Collections.emptyList(), (item, pattern) -> true);
        this.addChestSlots(this.getSizeInventory() / 9, 9);
        this.addPlayerInventory(playerInventory, 9, 112);
        this.updateFilter("");
    }

    protected List<Slot> getUnfilteredItems() {
        return this.chestSlots;
    }

    protected void addChestSlots(int rows, int columns) {
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                Slot slot = this.makeSlot(this.inventory, column + row * columns, 9 + column * 18, 18 + row * 18);
                this.m_38897_(slot);
                this.chestSlots.add(slot);
            }
        }
    }

    protected Slot makeSlot(Container inventory, int index, int row, int column) {
        return new SlotExtended(inventory, index, row, column);
    }

    public int getColumns() {
        return 9;
    }

    public int getPageSize() {
        return 5;
    }

    protected void disableSlot(int slotIndex) {
        Slot slot = this.m_38853_(slotIndex);
        ContainerColossalChest.setSlotPosX((Slot)slot, (int)Integer.MIN_VALUE);
        ContainerColossalChest.setSlotPosY((Slot)slot, (int)Integer.MIN_VALUE);
    }

    protected void enableSlot(int slotIndex, int row, int column) {
        Slot slot = this.m_38853_(slotIndex);
        ContainerColossalChest.setSlotPosX((Slot)slot, (int)(9 + column * 18));
        ContainerColossalChest.setSlotPosY((Slot)slot, (int)(18 + row * 18));
    }

    public void onScroll(int firstRow) {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.disableSlot(i);
        }
        super.onScroll(firstRow);
    }

    protected void enableElementAt(int visibleIndex, int elementIndex, Slot element) {
        super.enableElementAt(visibleIndex, elementIndex, (Object)element);
        int column = visibleIndex % this.getColumns();
        int row = (visibleIndex - column) / this.getColumns();
        this.enableSlot(elementIndex, row, column);
    }

    public void m_38893_(ContainerListener listener) {
        if (this.f_38848_.contains(listener)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.f_38848_.add(listener);
        if (listener instanceof ServerPlayer) {
            this.updateCraftingInventory((ServerPlayer)listener, (List<ItemStack>)this.m_38927_());
        }
        this.m_38946_();
    }

    public void m_38946_() {
        int newState = ((SimpleInventory)this.inventory).getState();
        if (this.lastInventoryState != newState) {
            this.lastInventoryState = newState;
            this.detectAndSendChangesOverride();
        }
    }

    protected void detectAndSendChangesOverride() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            ItemStack itemstack = ((Slot)this.f_38839_.get(i)).m_7993_();
            ItemStack itemstack1 = (ItemStack)this.inventoryItemStacks.get(i);
            if (ItemStack.m_41728_((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            itemstack1 = itemstack.m_41619_() ? ItemStack.f_41583_ : itemstack.m_41777_();
            this.inventoryItemStacks.set(i, (Object)itemstack1);
            if (this.firstDetectionCheck) continue;
            for (int j = 0; j < this.f_38848_.size(); ++j) {
                ContainerListener listener = (ContainerListener)this.f_38848_.get(j);
                if (listener instanceof ServerPlayer) {
                    this.sendSlotContentsToPlayer((ServerPlayer)listener, (AbstractContainerMenu)this, i, itemstack1);
                    continue;
                }
                listener.m_7934_((AbstractContainerMenu)this, i, itemstack1);
            }
        }
        this.firstDetectionCheck = false;
    }

    protected void sendSlotContentsToPlayer(ServerPlayer player, AbstractContainerMenu containerToSend, int slotInd, ItemStack stack) {
        if (!(containerToSend.m_38853_(slotInd) instanceof ResultSlot)) {
            ColossalChests._instance.getPacketHandler().sendToPlayer((PacketBase)new ClientboundContainerSetSlotPacketLarge(containerToSend.f_38840_, this.m_182424_(), slotInd, stack), player);
        }
    }

    protected int getTagSize(Tag tag) {
        if (tag instanceof NumericTag || tag instanceof EndTag) {
            return 1;
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            int size = 0;
            for (String key : compound.m_128431_()) {
                size += this.getTagSize(compound.m_128423_(key));
            }
            return size;
        }
        if (tag instanceof ByteArrayTag) {
            return ((ByteArrayTag)tag).m_128227_().length;
        }
        if (tag instanceof IntArrayTag) {
            return ((IntArrayTag)tag).m_128648_().length * 32;
        }
        if (tag instanceof ListTag) {
            ListTag list = (ListTag)tag;
            int size = 0;
            for (int i = 0; i < list.size(); ++i) {
                size += this.getTagSize(list.get(i));
            }
            return size;
        }
        if (tag instanceof StringTag) {
            try {
                return ((StringTag)tag).m_7916_().getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return tag.toString().length();
    }

    public void updateCraftingInventory(ServerPlayer player, List<ItemStack> allItems) {
        int maxBufferSize = GeneralConfig.maxPacketBufferSize;
        ServerGamePacketListenerImpl playerNetServerHandler = player.f_8906_;
        CompoundTag sendBuffer = new CompoundTag();
        ListTag sendList = new ListTag();
        sendBuffer.m_128365_("stacks", (Tag)sendList);
        int i = 0;
        int bufferSize = 0;
        boolean sent = false;
        for (ItemStack itemStack : allItems) {
            if (itemStack != null) {
                CompoundTag tag = new CompoundTag();
                tag.m_128405_("slot", i);
                tag.m_128365_("stack", (Tag)itemStack.serializeNBT());
                int tagSize = this.getTagSize((Tag)tag);
                if (bufferSize + tagSize + 100 < maxBufferSize) {
                    sendList.add((Object)tag);
                    bufferSize += tagSize;
                } else {
                    ColossalChests._instance.getPacketHandler().sendToPlayer((PacketBase)new ClientboundContainerSetContentPacketWindow(this.f_38840_, this.m_182424_(), sendBuffer), player);
                    sendBuffer = new CompoundTag();
                    sendList = new ListTag();
                    sendList.add((Object)tag);
                    sendBuffer.m_128365_("stacks", (Tag)sendList);
                    bufferSize = tagSize;
                }
            }
            ++i;
        }
        if (sendList.size() > 0) {
            ColossalChests._instance.getPacketHandler().sendToPlayer((PacketBase)new ClientboundContainerSetContentPacketWindow(this.f_38840_, this.m_182424_(), sendBuffer), player);
        }
        playerNetServerHandler.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-1, this.m_182424_(), -1, this.m_142621_()));
    }

    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> getContainerSelection() {
        try {
            int i;
            HashMap selection = Maps.newHashMap();
            ArrayList chest = Lists.newArrayList();
            ArrayList playerInventory = Lists.newArrayList();
            for (i = 0; i < this.getSizeInventory(); ++i) {
                chest.add(this.m_38853_(i));
            }
            for (i = this.getSizeInventory(); i < this.getSizeInventory() + this.player.m_150109_().f_35974_.size(); ++i) {
                playerInventory.add(this.m_38853_(i));
            }
            selection.put(ContainerSection.CHEST, chest);
            selection.put(ContainerSection.INVENTORY, playerInventory);
            return selection;
        }
        catch (RuntimeException e) {
            System.out.println("Size inv " + this.getSizeInventory());
            System.out.println("Player size inv " + this.player.m_150109_().f_35974_.size());
            System.out.println("Available slots " + this.f_38839_.size());
            throw e;
        }
    }
}

