/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests;

import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import org.apache.logging.log4j.Level;
import org.cyclops.colossalchests.ColossalChestsInstance;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.advancement.criterion.ChestFormedTriggerConfig;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ChestWallConfigNeoForge;
import org.cyclops.colossalchests.block.ColossalChestConfigNeoForge;
import org.cyclops.colossalchests.block.InterfaceConfigNeoForge;
import org.cyclops.colossalchests.block.UncolossalChestConfigNeoForge;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChestConfigNeoForge;
import org.cyclops.colossalchests.blockentity.BlockEntityInterfaceConfigNeoForge;
import org.cyclops.colossalchests.blockentity.BlockEntityUncolossalChestConfigNeoForge;
import org.cyclops.colossalchests.condition.ConditionMetalVariantsSettingConfig;
import org.cyclops.colossalchests.gametest.GameTestsCommon;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChestConfig;
import org.cyclops.colossalchests.inventory.container.ContainerUncolossalChestConfig;
import org.cyclops.colossalchests.item.ItemUpgradeToolConfig;
import org.cyclops.colossalchests.modcompat.CommonCapabilitiesModCompat;
import org.cyclops.colossalchests.modcompat.IronChestModCompat;
import org.cyclops.colossalchests.proxy.ClientProxy;
import org.cyclops.colossalchests.proxy.CommonProxy;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;

@Mod(value="colossalchests")
public class ColossalChestsNeoForge
extends ModBaseNeoForge<ColossalChestsNeoForge> {
    public static ColossalChestsNeoForge _instance;

    public ColossalChestsNeoForge(IEventBus modEventBus) {
        super("colossalchests", instance -> {
            ColossalChestsInstance.MOD = instance;
            _instance = instance;
        }, modEventBus);
    }

    protected void loadModCompats(ModCompatLoader modCompatLoader) {
        modCompatLoader.addModCompat((IModCompat)new IronChestModCompat());
        modCompatLoader.addModCompat((IModCompat)new CommonCapabilitiesModCompat());
    }

    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return super.constructDefaultCreativeModeTab(builder).icon(() -> new ItemStack(RegistryEntries.ITEM_CHEST));
    }

    protected void onConfigsRegister(ConfigHandlerCommon configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable(new GeneralConfig<ColossalChestsNeoForge>(this));
        for (ChestMaterial material : ChestMaterial.VALUES) {
            configHandler.addConfigurable(new ChestWallConfigNeoForge<ColossalChestsNeoForge>(this, material));
            configHandler.addConfigurable(new ColossalChestConfigNeoForge<ColossalChestsNeoForge>(this, material));
            configHandler.addConfigurable(new InterfaceConfigNeoForge<ColossalChestsNeoForge>(this, material));
        }
        configHandler.addConfigurable(new UncolossalChestConfigNeoForge<ColossalChestsNeoForge>(this));
        configHandler.addConfigurable(new ItemUpgradeToolConfig<ColossalChestsNeoForge>(this, true));
        configHandler.addConfigurable(new ItemUpgradeToolConfig<ColossalChestsNeoForge>(this, false));
        configHandler.addConfigurable(new BlockEntityColossalChestConfigNeoForge<ColossalChestsNeoForge>(this));
        configHandler.addConfigurable(new BlockEntityInterfaceConfigNeoForge<ColossalChestsNeoForge>(this));
        configHandler.addConfigurable(new BlockEntityUncolossalChestConfigNeoForge<ColossalChestsNeoForge>(this));
        configHandler.addConfigurable(new ContainerColossalChestConfig<ColossalChestsNeoForge>(this));
        configHandler.addConfigurable(new ContainerUncolossalChestConfig<ColossalChestsNeoForge>(this));
        configHandler.addConfigurable((ExtendedConfigCommon)new ConditionMetalVariantsSettingConfig());
        configHandler.addConfigurable(new ChestFormedTriggerConfig<ColossalChestsNeoForge>(this));
    }

    public Class<?>[] getGameTestClasses() {
        return new Class[]{GameTestsCommon.class};
    }

    public static void clog(String message) {
        ColossalChestsNeoForge.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }
}

