/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.modcompat;

import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.cyclops.colossalchests.ColossalChestsNeoForge;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.colossalchests.blockentity.BlockEntityInterface;
import org.cyclops.colossalchests.modcompat.InventoryIndexReferenceIndexedInventoryCommon;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.commoncapabilities.api.capability.inventorystate.IInventoryState;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.cyclopscore.inventory.IInventoryIndexReference;
import org.cyclops.cyclopscore.inventory.IndexedInventory;
import org.cyclops.cyclopscore.inventory.IndexedSlotlessItemHandlerWrapper;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.modcompat.ICompatInitializer;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;

public class CommonCapabilitiesModCompat
implements IModCompat {
    public String getId() {
        return "commoncapabilities";
    }

    public boolean isEnabledDefault() {
        return true;
    }

    public String getComment() {
        return "If slotless item handlers should be registered to colossal chests.";
    }

    public ICompatInitializer createInitializer() {
        return mod -> {
            CapabilityConstructorRegistry registry = ColossalChestsNeoForge._instance.getCapabilityConstructorRegistry();
            registry.registerBlockEntity(() -> RegistryEntries.BLOCK_ENTITY_COLOSSAL_CHEST.value(), (ICapabilityConstructor)new ICapabilityConstructor<BlockEntityColossalChest, Direction, ISlotlessItemHandler, BlockEntityType<BlockEntityColossalChest>>(this){

                public BaseCapability<ISlotlessItemHandler, Direction> getCapability() {
                    return Capabilities.SlotlessItemHandler.BLOCK;
                }

                public ICapabilityProvider<BlockEntityColossalChest, Direction, ISlotlessItemHandler> createProvider(BlockEntityType<BlockEntityColossalChest> capabilityKey) {
                    return (blockEntity, side) -> {
                        IndexedInventory inv = (IndexedInventory)blockEntity.getInventory();
                        return new IndexedSlotlessItemHandlerWrapper((IItemHandler)new InvWrapper((Container)inv), (IInventoryIndexReference)new InventoryIndexReferenceIndexedInventoryCommon(inv));
                    };
                }
            });
            registry.registerBlockEntity(() -> RegistryEntries.BLOCK_ENTITY_INTERFACE.value(), (ICapabilityConstructor)new ICapabilityConstructor<BlockEntityInterface, Direction, ISlotlessItemHandler, BlockEntityType<BlockEntityInterface>>(this){

                public BaseCapability<ISlotlessItemHandler, Direction> getCapability() {
                    return Capabilities.SlotlessItemHandler.BLOCK;
                }

                public ICapabilityProvider<BlockEntityInterface, Direction, ISlotlessItemHandler> createProvider(BlockEntityType<BlockEntityInterface> capabilityKey) {
                    return (blockEntity, side) -> {
                        BlockEntityColossalChest core = blockEntity.getCore();
                        if (core != null) {
                            return new IndexedSlotlessItemHandlerWrapper((IItemHandler)new InvWrapper((Container)core.getInventory()), (IInventoryIndexReference)new InventoryIndexReferenceIndexedInventoryCommon((IndexedInventory)core.getInventory()));
                        }
                        return null;
                    };
                }
            });
            registry.registerBlockEntity(() -> RegistryEntries.BLOCK_ENTITY_COLOSSAL_CHEST.value(), (ICapabilityConstructor)new ICapabilityConstructor<BlockEntityColossalChest, Direction, IInventoryState, BlockEntityType<BlockEntityColossalChest>>(this){

                public BaseCapability<IInventoryState, Direction> getCapability() {
                    return Capabilities.InventoryState.BLOCK;
                }

                public ICapabilityProvider<BlockEntityColossalChest, Direction, IInventoryState> createProvider(BlockEntityType<BlockEntityColossalChest> capabilityKey) {
                    return (blockEntity, side) -> () -> ((SimpleInventory)blockEntity.getInventory()).getState();
                }
            });
            registry.registerBlockEntity(() -> RegistryEntries.BLOCK_ENTITY_INTERFACE.value(), (ICapabilityConstructor)new ICapabilityConstructor<BlockEntityInterface, Direction, IInventoryState, BlockEntityType<BlockEntityInterface>>(this){

                public BaseCapability<IInventoryState, Direction> getCapability() {
                    return Capabilities.InventoryState.BLOCK;
                }

                public ICapabilityProvider<BlockEntityInterface, Direction, IInventoryState> createProvider(BlockEntityType<BlockEntityInterface> capabilityKey) {
                    return (blockEntity, side) -> {
                        BlockEntityColossalChest core = blockEntity.getCore();
                        if (core != null) {
                            return () -> ((SimpleInventory)core.getInventory()).getState();
                        }
                        return null;
                    };
                }
            });
        };
    }
}

