/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.network.packet;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.HashedStack;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChest;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public class ServerboundContainerClickPacketOverride
extends PacketCodec<ServerboundContainerClickPacketOverride> {
    public static final CustomPacketPayload.Type<ServerboundContainerClickPacketOverride> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"serverbound_container_click_packet_override"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundContainerClickPacketOverride> CODEC = ServerboundContainerClickPacketOverride.getCodec(ServerboundContainerClickPacketOverride::new);
    @CodecField
    private int windowId;
    @CodecField
    private int stateId;
    @CodecField
    private int slotId;
    @CodecField
    private int usedButton;
    @CodecField
    private HashedStack clickedItem;
    @CodecField
    private String mode;
    private Int2ObjectMap<HashedStack> changedSlots;

    public ServerboundContainerClickPacketOverride() {
        super(TYPE);
    }

    public ServerboundContainerClickPacketOverride(int windowId, int stateId, int slotId, int usedButton, ClickType mode, HashedStack clickedItem, Int2ObjectMap<HashedStack> changedSlots) {
        super(TYPE);
        this.windowId = windowId;
        this.stateId = stateId;
        this.slotId = slotId;
        this.usedButton = usedButton;
        this.clickedItem = clickedItem;
        this.mode = mode.name();
        this.changedSlots = changedSlots;
    }

    public void encode(RegistryFriendlyByteBuf output) {
        super.encode(output);
        output.writeMap(this.changedSlots, FriendlyByteBuf::writeInt, (b, i) -> HashedStack.STREAM_CODEC.encode((Object)output, i));
    }

    public void decode(RegistryFriendlyByteBuf input) {
        super.decode(input);
        IntFunction intfunction = FriendlyByteBuf.limitValue(Int2ObjectOpenHashMap::new, (int)128);
        this.changedSlots = Int2ObjectMaps.unmodifiable((Int2ObjectMap)((Int2ObjectMap)input.readMap(intfunction, FriendlyByteBuf::readInt, b -> (HashedStack)HashedStack.STREAM_CODEC.decode((Object)input))));
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        player.resetLastActionTime();
        if (player.containerMenu.containerId == this.windowId) {
            if (player.isSpectator()) {
                ArrayList arraylist = Lists.newArrayList();
                for (int i = 0; i < player.containerMenu.slots.size(); ++i) {
                    arraylist.add(((Slot)player.containerMenu.slots.get(i)).getItem());
                }
                ((ContainerColossalChest)player.containerMenu).updateCraftingInventory(player, arraylist);
            } else {
                boolean flag = this.stateId != player.containerMenu.getStateId();
                player.containerMenu.suppressRemoteUpdates();
                player.containerMenu.clicked(this.slotId, this.usedButton, ClickType.valueOf((String)this.mode), (Player)player);
                for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(this.changedSlots)) {
                    player.containerMenu.setRemoteSlotUnsafe(entry.getIntKey(), (HashedStack)entry.getValue());
                }
                player.containerMenu.setRemoteCarried(this.clickedItem);
                player.containerMenu.resumeRemoteUpdates();
                if (flag) {
                    NonNullList nonnulllist1 = NonNullList.create();
                    for (int j = 0; j < player.containerMenu.slots.size(); ++j) {
                        nonnulllist1.add((Object)((Slot)player.containerMenu.slots.get(j)).getItem());
                    }
                    ((ContainerColossalChest)player.containerMenu).updateCraftingInventory(player, (List<ItemStack>)nonnulllist1);
                } else {
                    player.containerMenu.broadcastChanges();
                }
            }
        }
    }
}

