/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.gametest;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4516;
import net.minecraft.class_6302;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.Interface;
import org.cyclops.colossalchests.block.UncolossalChest;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;

public class GameTestsCommon {
    public static final String TEMPLATE_EMPTY = "colossalchests:empty10";
    public static final class_2338 POS = class_2338.field_10980.method_10069(1, 0, 1);

    @class_6302(method_35936="colossalchests:empty10")
    public void testUncolossalPlacementDirection(class_4516 helper) {
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799((class_1935)RegistryEntries.BLOCK_UNCOLOSSAL_CHEST.comp_349());
        player.method_6122(class_1268.field_5808, itemStack);
        helper.method_47816(player, itemStack, POS, class_2350.field_11035);
        helper.method_36018(() -> {
            helper.method_35972((class_2248)RegistryEntries.BLOCK_UNCOLOSSAL_CHEST.comp_349(), POS.method_10072());
            helper.method_35987(POS.method_10072(), (class_2769)UncolossalChest.FACING, (Comparable)class_2350.field_11043);
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testUncolossalPlacementDirectionOpposite(class_4516 helper) {
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799((class_1935)RegistryEntries.BLOCK_UNCOLOSSAL_CHEST.comp_349());
        player.method_6122(class_1268.field_5808, itemStack);
        helper.method_47816(player, itemStack, POS, class_2350.field_11043);
        helper.method_36018(() -> {
            helper.method_35972((class_2248)RegistryEntries.BLOCK_UNCOLOSSAL_CHEST.comp_349(), POS.method_10095());
            helper.method_35987(POS.method_10095(), (class_2769)UncolossalChest.FACING, (Comparable)class_2350.field_11043);
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testUncolossalHoppers(class_4516 helper) {
        helper.method_35984(POS.method_10084(), class_2246.field_10312);
        helper.method_35984(POS, (class_2248)RegistryEntries.BLOCK_UNCOLOSSAL_CHEST.comp_349());
        helper.method_35984(POS.method_10074(), class_2246.field_10312);
        helper.method_46225(class_1802.field_8279, POS.method_10084().method_10084());
        helper.method_36018(() -> this.assertHopperContains(helper, POS.method_10074(), new class_1799((class_1935)class_1802.field_8279)));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood2x2(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.WOOD, 2);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.WOOD, 2));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood3x3(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.WOOD, 3);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.WOOD, 3));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood5x5(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.WOOD, 5);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.WOOD, 5));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood9x9(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.WOOD, 9);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.WOOD, 9));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood3x3MissingCore(class_4516 helper) {
        HashSet excluded = Sets.newHashSet((Object[])new class_2338[]{POS});
        this.createChest(helper, POS, ChestMaterial.WOOD, 3, excluded);
        helper.method_36018(() -> this.assertChestInvalid(helper, POS, ChestMaterial.WOOD, 3, excluded, Sets.newHashSet()));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood3x3MissingWall(class_4516 helper) {
        HashSet excluded = Sets.newHashSet((Object[])new class_2338[]{POS.method_10084()});
        this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet((Iterable)excluded));
        helper.method_36018(() -> this.assertChestInvalid(helper, POS, ChestMaterial.WOOD, 3, excluded, Sets.newHashSet()));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood3x3MissingWallMultiple(class_4516 helper) {
        HashSet excluded = Sets.newHashSet((Object[])new class_2338[]{POS.method_10084(), POS.method_10084().method_10084(), POS.method_10084().method_10095()});
        this.createChest(helper, POS, ChestMaterial.WOOD, 3, excluded);
        helper.method_36018(() -> this.assertChestInvalid(helper, POS, ChestMaterial.WOOD, 3, excluded, Sets.newHashSet()));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalCopper5x5(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.COPPER, 5);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.COPPER, 5));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalCopper9x9(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.COPPER, 9);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.COPPER, 9));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalIron5x5(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.IRON, 5);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.IRON, 5));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalIron9x9(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.IRON, 9);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.IRON, 9));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalSilver5x5(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.SILVER, 5);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.SILVER, 5));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalSilver9x9(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.SILVER, 9);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.SILVER, 9));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalGold5x5(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.GOLD, 5);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.GOLD, 5));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalGold9x9(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.GOLD, 9);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.GOLD, 9));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalDiamond5x5(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.DIAMOND, 5);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.DIAMOND, 5));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalDiamond9x9(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.DIAMOND, 9);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.DIAMOND, 9));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalObsidian5x5(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.OBSIDIAN, 5);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.OBSIDIAN, 5));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalObsidian9x9(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.OBSIDIAN, 9);
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.OBSIDIAN, 9));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood5x5HopperInsert(class_4516 helper) {
        if (this.isFabric()) {
            helper.method_36036();
            return;
        }
        this.createChest(helper, POS.method_10084().method_10072(), ChestMaterial.WOOD, 5);
        helper.method_35986(POS.method_10084(), (class_2680)class_2246.field_10312.method_9564().method_11657((class_2769)class_2377.field_11129, (Comparable)class_2350.field_11035));
        helper.method_46225(class_1802.field_8279, POS.method_10084().method_10084());
        helper.method_46225(class_1802.field_19044, POS.method_10084().method_10084());
        helper.method_46225(class_1802.field_17507, POS.method_10084().method_10084());
        helper.method_36018(() -> {
            this.assertCoreContains(helper, POS.method_10084().method_10072(), new class_1799((class_1935)class_1802.field_8279));
            this.assertCoreContains(helper, POS.method_10084().method_10072(), new class_1799((class_1935)class_1802.field_19044));
            this.assertCoreContains(helper, POS.method_10084().method_10072(), new class_1799((class_1935)class_1802.field_17507));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood5x5HopperExtract(class_4516 helper) {
        BlockEntityColossalChest core = this.createChest(helper, POS.method_10084().method_10072(), ChestMaterial.WOOD, 5);
        helper.method_35986(POS.method_10072(), (class_2680)class_2246.field_10312.method_9564().method_11657((class_2769)class_2377.field_11129, (Comparable)class_2350.field_11035));
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        core.getInventory().method_5447(1, new class_1799((class_1935)class_1802.field_19044));
        core.getInventory().method_5447(2, new class_1799((class_1935)class_1802.field_17507));
        helper.method_36018(() -> {
            this.assertHopperContains(helper, POS.method_10072(), new class_1799((class_1935)class_1802.field_8279));
            this.assertHopperContains(helper, POS.method_10072(), new class_1799((class_1935)class_1802.field_19044));
            this.assertHopperContains(helper, POS.method_10072(), new class_1799((class_1935)class_1802.field_17507));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood5x5HopperInsertExtract(class_4516 helper) {
        if (this.isFabric()) {
            helper.method_36036();
            return;
        }
        BlockEntityColossalChest core = this.createChest(helper, POS.method_10084().method_10072(), ChestMaterial.WOOD, 5);
        helper.method_35986(POS.method_10084(), (class_2680)class_2246.field_10312.method_9564().method_11657((class_2769)class_2377.field_11129, (Comparable)class_2350.field_11035));
        helper.method_35986(POS.method_10072(), (class_2680)class_2246.field_10312.method_9564().method_11657((class_2769)class_2377.field_11129, (Comparable)class_2350.field_11035));
        helper.method_46225(class_1802.field_8279, POS.method_10084().method_10084());
        helper.method_46225(class_1802.field_19044, POS.method_10084().method_10084());
        helper.method_46225(class_1802.field_17507, POS.method_10084().method_10084());
        helper.method_36018(() -> {
            this.assertHopperContains(helper, POS.method_10072(), new class_1799((class_1935)class_1802.field_8279));
            this.assertHopperContains(helper, POS.method_10072(), new class_1799((class_1935)class_1802.field_19044));
            this.assertHopperContains(helper, POS.method_10072(), new class_1799((class_1935)class_1802.field_17507));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood5x5Interfaces(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.WOOD, 5, Sets.newHashSet(), Sets.newHashSet((Object[])new class_2338[]{POS.method_10095().method_10084(), POS.method_10072().method_10084()}));
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.WOOD, 5, Sets.newHashSet((Object[])new class_2338[]{POS.method_10095().method_10084(), POS.method_10072().method_10084()}), true));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalDiamond5x5Interfaces(class_4516 helper) {
        this.createChest(helper, POS, ChestMaterial.DIAMOND, 5, Sets.newHashSet(), Sets.newHashSet((Object[])new class_2338[]{POS.method_10095().method_10084(), POS.method_10072().method_10084()}));
        helper.method_36018(() -> this.assertChestValid(helper, POS, ChestMaterial.DIAMOND, 5, Sets.newHashSet((Object[])new class_2338[]{POS.method_10095().method_10084(), POS.method_10072().method_10084()}), true));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood3x3InterfacesMissingWall(class_4516 helper) {
        HashSet excluded = Sets.newHashSet((Object[])new class_2338[]{POS.method_10084()});
        this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet((Iterable)excluded), Sets.newHashSet((Object[])new class_2338[]{POS.method_10095()}));
        helper.method_36018(() -> this.assertChestInvalid(helper, POS, ChestMaterial.WOOD, 3, excluded, Sets.newHashSet((Object[])new class_2338[]{POS.method_10095()})));
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood5x5InterfacesHopperInsertExtract(class_4516 helper) {
        if (this.isFabric()) {
            helper.method_36036();
            return;
        }
        this.createChest(helper, POS.method_10084(), ChestMaterial.WOOD, 5, Sets.newHashSet(), Sets.newHashSet((Object[])new class_2338[]{POS.method_10069(0, 5, 0), POS.method_10084().method_10072()}));
        helper.method_35986(POS.method_10069(0, 5, 0).method_10084(), (class_2680)class_2246.field_10312.method_9564().method_11657((class_2769)class_2377.field_11129, (Comparable)class_2350.field_11033));
        helper.method_35986(POS.method_10072(), (class_2680)class_2246.field_10312.method_9564().method_11657((class_2769)class_2377.field_11129, (Comparable)class_2350.field_11033));
        helper.method_46225(class_1802.field_8279, POS.method_10069(0, 5, 0).method_10084().method_10084());
        helper.method_46225(class_1802.field_19044, POS.method_10069(0, 5, 0).method_10084().method_10084());
        helper.method_46225(class_1802.field_17507, POS.method_10069(0, 5, 0).method_10084().method_10084());
        helper.method_36018(() -> {
            this.assertHopperContains(helper, POS.method_10072(), new class_1799((class_1935)class_1802.field_8279));
            this.assertHopperContains(helper, POS.method_10072(), new class_1799((class_1935)class_1802.field_19044));
            this.assertHopperContains(helper, POS.method_10072(), new class_1799((class_1935)class_1802.field_17507));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood3x3Upgrade(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.method_6122(class_1268.field_5808, itemStack);
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.COPPER.getBlockCore(), 1));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.COPPER.getBlockInterface(), 2));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.COPPER.getBlockWall(), 23));
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(POS.method_46558(), class_2350.field_11043, helper.method_36052(POS), false)));
        helper.method_46226(interactionResult.method_36360(), "Interaction must succeed");
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.COPPER, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.WOOD.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.WOOD.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.WOOD.getBlockWall(), 23));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood3x3UpgradeInsufficientItems(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.method_6122(class_1268.field_5808, itemStack);
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.COPPER.getBlockCore(), 1));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.COPPER.getBlockInterface(), 2));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.COPPER.getBlockWall(), 22));
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(POS.method_46558(), class_2350.field_11043, helper.method_36052(POS), false)));
        helper.method_46226(interactionResult == class_1269.field_5814, "Interaction must fail");
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.WOOD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.WOOD.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.WOOD.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.WOOD.getBlockWall(), 22));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockWall(), 22));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalCopper3x3Upgrade(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.COPPER, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.method_6122(class_1268.field_5808, itemStack);
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.IRON.getBlockCore(), 1));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.IRON.getBlockInterface(), 2));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.IRON.getBlockWall(), 23));
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(POS.method_46558(), class_2350.field_11043, helper.method_36052(POS), false)));
        helper.method_46226(interactionResult.method_36360(), "Interaction must succeed");
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.IRON, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.IRON.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.IRON.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.IRON.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockWall(), 23));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalIron3x3Upgrade(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.IRON, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.method_6122(class_1268.field_5808, itemStack);
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.SILVER.getBlockCore(), 1));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.SILVER.getBlockInterface(), 2));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.SILVER.getBlockWall(), 23));
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(POS.method_46558(), class_2350.field_11043, helper.method_36052(POS), false)));
        helper.method_46226(interactionResult.method_36360(), "Interaction must succeed");
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.SILVER, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.SILVER.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.SILVER.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.SILVER.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.IRON.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.IRON.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.IRON.getBlockWall(), 23));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalSilver3x3Upgrade(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.SILVER, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.method_6122(class_1268.field_5808, itemStack);
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.GOLD.getBlockCore(), 1));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.GOLD.getBlockInterface(), 2));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.GOLD.getBlockWall(), 23));
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(POS.method_46558(), class_2350.field_11043, helper.method_36052(POS), false)));
        helper.method_46226(interactionResult.method_36360(), "Interaction must succeed");
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.GOLD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.GOLD.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.GOLD.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.GOLD.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.SILVER.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.SILVER.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.SILVER.getBlockWall(), 23));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalGold3x3Upgrade(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.GOLD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.method_6122(class_1268.field_5808, itemStack);
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockCore(), 1));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockInterface(), 2));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockWall(), 23));
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(POS.method_46558(), class_2350.field_11043, helper.method_36052(POS), false)));
        helper.method_46226(interactionResult.method_36360(), "Interaction must succeed");
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.DIAMOND, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.GOLD.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.GOLD.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.GOLD.getBlockWall(), 23));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalDiamond3x3Upgrade(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.DIAMOND, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.method_6122(class_1268.field_5808, itemStack);
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.OBSIDIAN.getBlockCore(), 1));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.OBSIDIAN.getBlockInterface(), 2));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.OBSIDIAN.getBlockWall(), 23));
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(POS.method_46558(), class_2350.field_11043, helper.method_36052(POS), false)));
        helper.method_46226(interactionResult.method_36360(), "Interaction must succeed");
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.OBSIDIAN, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.OBSIDIAN.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.OBSIDIAN.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.OBSIDIAN.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockWall(), 23));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalCopper3x3Downgrade(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.COPPER, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_UPGRADE_TOOL_REVERSE);
        player.method_6122(class_1268.field_5808, itemStack);
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.WOOD.getBlockCore(), 1));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.WOOD.getBlockInterface(), 2));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.WOOD.getBlockWall(), 23));
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(POS.method_46558(), class_2350.field_11043, helper.method_36052(POS), false)));
        helper.method_46226(interactionResult.method_36360(), "Interaction must succeed");
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.WOOD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.WOOD.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.WOOD.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.WOOD.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockWall(), 23));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalCopper3x3DowngradeInsufficientItems(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.COPPER, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.method_6122(class_1268.field_5808, itemStack);
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.WOOD.getBlockCore(), 1));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.WOOD.getBlockInterface(), 2));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.WOOD.getBlockWall(), 22));
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(POS.method_46558(), class_2350.field_11043, helper.method_36052(POS), false)));
        helper.method_46226(interactionResult == class_1269.field_5814, "Interaction must fail");
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.COPPER, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockWall(), 22));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.WOOD.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.WOOD.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.WOOD.getBlockWall(), 22));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalIron3x3Downgrade(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.IRON, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_UPGRADE_TOOL_REVERSE);
        player.method_6122(class_1268.field_5808, itemStack);
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.COPPER.getBlockCore(), 1));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.COPPER.getBlockInterface(), 2));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.COPPER.getBlockWall(), 23));
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(POS.method_46558(), class_2350.field_11043, helper.method_36052(POS), false)));
        helper.method_46226(interactionResult.method_36360(), "Interaction must succeed");
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.COPPER, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.COPPER.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.IRON.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.IRON.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.IRON.getBlockWall(), 23));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalSilver3x3Downgrade(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.SILVER, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_UPGRADE_TOOL_REVERSE);
        player.method_6122(class_1268.field_5808, itemStack);
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.IRON.getBlockCore(), 1));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.IRON.getBlockInterface(), 2));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.IRON.getBlockWall(), 23));
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(POS.method_46558(), class_2350.field_11043, helper.method_36052(POS), false)));
        helper.method_46226(interactionResult.method_36360(), "Interaction must succeed");
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.IRON, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.IRON.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.IRON.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.IRON.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.SILVER.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.SILVER.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.SILVER.getBlockWall(), 23));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalGold3x3Downgrade(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.GOLD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_UPGRADE_TOOL_REVERSE);
        player.method_6122(class_1268.field_5808, itemStack);
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.SILVER.getBlockCore(), 1));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.SILVER.getBlockInterface(), 2));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.SILVER.getBlockWall(), 23));
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(POS.method_46558(), class_2350.field_11043, helper.method_36052(POS), false)));
        helper.method_46226(interactionResult.method_36360(), "Interaction must succeed");
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.SILVER, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.SILVER.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.SILVER.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.SILVER.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.GOLD.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.GOLD.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.GOLD.getBlockWall(), 23));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalDiamond3x3Downgrade(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.DIAMOND, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_UPGRADE_TOOL_REVERSE);
        player.method_6122(class_1268.field_5808, itemStack);
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.GOLD.getBlockCore(), 1));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.GOLD.getBlockInterface(), 2));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.GOLD.getBlockWall(), 23));
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(POS.method_46558(), class_2350.field_11043, helper.method_36052(POS), false)));
        helper.method_46226(interactionResult.method_36360(), "Interaction must succeed");
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.GOLD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.GOLD.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.GOLD.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.GOLD.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockWall(), 23));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalObsidian3x3Downgrade(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.OBSIDIAN, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799(RegistryEntries.ITEM_UPGRADE_TOOL_REVERSE);
        player.method_6122(class_1268.field_5808, itemStack);
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockCore(), 1));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockInterface(), 2));
        player.method_31548().method_7394(new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockWall(), 23));
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(POS.method_46558(), class_2350.field_11043, helper.method_36052(POS), false)));
        helper.method_46226(interactionResult.method_36360(), "Interaction must succeed");
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.DIAMOND, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new class_1799((class_1935)ChestMaterial.DIAMOND.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.OBSIDIAN.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.OBSIDIAN.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new class_1799((class_1935)ChestMaterial.OBSIDIAN.getBlockWall(), 23));
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood3x3BreakPlaceWall(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        this.destroyBlock(helper, POS.method_10078());
        helper.method_35984(POS.method_10078(), (class_2248)ChestMaterial.WOOD.getBlockWall());
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.WOOD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            helper.method_36004(class_1299.field_6052);
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood3x3BreakPlaceWallAsPlayer(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        this.destroyBlock(helper, POS.method_10078());
        this.setBlockAsPlayer(helper, POS.method_10078(), ChestMaterial.WOOD.getBlockWall());
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.WOOD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            helper.method_36004(class_1299.field_6052);
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood3x3BreakPlaceInterface(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        this.destroyBlock(helper, POS.method_10078().method_10084());
        helper.method_35984(POS.method_10078().method_10084(), (class_2248)ChestMaterial.WOOD.getBlockInterface());
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.WOOD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            helper.method_36004(class_1299.field_6052);
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood3x3BreakPlaceInterfaceAsPlayer(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        this.destroyBlock(helper, POS.method_10078().method_10084());
        this.setBlockAsPlayer(helper, POS.method_10078().method_10084(), (class_2248)ChestMaterial.WOOD.getBlockInterface());
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.WOOD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new class_1799((class_1935)class_1802.field_8279));
            helper.method_36004(class_1299.field_6052);
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood3x3BreakPlaceCore(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10069(4, 1, 4).method_10078().method_10084(), POS.method_10069(4, 1, 4).method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS.method_10069(4, 1, 4), ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        core.getInventory().method_5447(1, new class_1799((class_1935)class_1802.field_17507));
        core.getInventory().method_5447(2, new class_1799((class_1935)class_1802.field_19044));
        this.destroyBlock(helper, POS.method_10069(4, 1, 4));
        helper.method_35984(POS.method_10069(4, 1, 4), (class_2248)ChestMaterial.WOOD.getBlockCore());
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS.method_10069(4, 1, 4), ChestMaterial.WOOD, 3, interfaces, true);
            helper.method_54143(class_1802.field_8279);
            helper.method_54143(class_1802.field_17507);
            helper.method_54143(class_1802.field_19044);
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood3x3BreakPlaceCoreAsPlayer(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10069(4, 1, 4).method_10078().method_10084(), POS.method_10069(4, 1, 4).method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS.method_10069(4, 1, 4), ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        core.getInventory().method_5447(1, new class_1799((class_1935)class_1802.field_17507));
        core.getInventory().method_5447(2, new class_1799((class_1935)class_1802.field_19044));
        this.destroyBlock(helper, POS.method_10069(4, 1, 4));
        this.setBlockAsPlayer(helper, POS.method_10069(4, 1, 4), (class_2248)ChestMaterial.WOOD.getBlockCore());
        helper.method_36018(() -> {
            this.assertChestValid(helper, POS.method_10069(4, 1, 4), ChestMaterial.WOOD, 3, interfaces, true);
            helper.method_54143(class_1802.field_8279);
            helper.method_54143(class_1802.field_17507);
            helper.method_54143(class_1802.field_19044);
        });
    }

    @class_6302(method_35936="colossalchests:empty10")
    public void testColossalWood3x3DestroyTnt(class_4516 helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new class_2338[]{POS.method_10078().method_10084(), POS.method_10072().method_10084()});
        BlockEntityColossalChest core = this.createChest(helper, POS.method_10084(), ChestMaterial.WOOD, 2, Sets.newHashSet(), interfaces);
        core.getInventory().method_5447(0, new class_1799((class_1935)class_1802.field_8279));
        core.getInventory().method_5447(1, new class_1799((class_1935)class_1802.field_17507));
        helper.method_35984(POS.method_10084().method_10069(2, 0, 0), class_2246.field_10375);
        helper.method_35984(POS.method_10084().method_10069(2, 1, 0), class_2246.field_10002);
        helper.method_36018(() -> {
            helper.method_54143(class_1802.field_8279);
            helper.method_54143(class_1802.field_17507);
            helper.method_54143(ChestMaterial.WOOD.getBlockCore().method_8389());
            helper.method_54143(ChestMaterial.WOOD.getBlockInterface().method_8389());
            helper.method_54143(ChestMaterial.WOOD.getBlockWall().method_8389());
        });
    }

    protected BlockEntityColossalChest createChest(class_4516 helper, class_2338 pos, ChestMaterial material, int dimension) {
        return this.createChest(helper, pos, material, dimension, Sets.newHashSet());
    }

    protected BlockEntityColossalChest createChest(class_4516 helper, class_2338 pos, ChestMaterial material, int dimension, Set<class_2338> exclude) {
        return this.createChest(helper, pos, material, dimension, exclude, Sets.newHashSet());
    }

    protected BlockEntityColossalChest createChest(class_4516 helper, class_2338 pos, ChestMaterial material, int dimension, Set<class_2338> exclude, Set<class_2338> interfaces) {
        for (int x = 0; x < dimension; ++x) {
            for (int y = 0; y < dimension; ++y) {
                for (int z = 0; z < dimension; ++z) {
                    class_2338 poso = pos.method_10069(x, y, z);
                    if (exclude.contains(poso)) continue;
                    if (x == 0 && y == 0 && z == 0) {
                        helper.method_35984(poso, (class_2248)material.getBlockCore());
                        continue;
                    }
                    if (x != 0 && y != 0 && z != 0 && x != dimension - 1 && y != dimension - 1 && z != dimension - 1) continue;
                    if (interfaces.contains(poso)) {
                        helper.method_35984(poso, (class_2248)material.getBlockInterface());
                        continue;
                    }
                    helper.method_35984(poso, (class_2248)material.getBlockWall());
                }
            }
        }
        return exclude.contains(pos) ? null : (BlockEntityColossalChest)helper.method_36014(pos);
    }

    protected int chestSize(int dimension, ChestMaterial material) {
        return (int)Math.ceil(Math.pow(dimension, 3.0) * 27.0 * material.getInventoryMultiplier() / 9.0) * 9;
    }

    protected void assertChestValid(class_4516 helper, class_2338 pos, ChestMaterial material, int dimension) {
        this.assertChestValid(helper, pos, material, dimension, Sets.newHashSet(), true);
    }

    protected void assertChestValid(class_4516 helper, class_2338 pos, ChestMaterial material, int dimension, Set<class_2338> interfaces, boolean mustBeEmpty) {
        int inventorySize = this.chestSize(dimension, material);
        for (int x = 0; x < dimension; ++x) {
            for (int y = 0; y < dimension; ++y) {
                for (int z = 0; z < dimension; ++z) {
                    class_2338 poso = pos.method_10069(x, y, z);
                    if (x == 0 && y == 0 && z == 0) {
                        helper.method_35972((class_2248)material.getBlockCore(), poso);
                        helper.method_35987(poso, (class_2769)ColossalChest.ENABLED, (Comparable)Boolean.valueOf(true));
                        helper.method_60651(poso, be -> be.getInventory().method_5439() == inventorySize, () -> "Inventory is not of size " + inventorySize);
                        if (!mustBeEmpty) continue;
                        helper.method_60651(poso, be -> be.getInventory().method_5442(), () -> "Inventory is not empty");
                        continue;
                    }
                    if (x != 0 && y != 0 && z != 0 && x != dimension - 1 && y != dimension - 1 && z != dimension - 1) continue;
                    if (interfaces.contains(poso)) {
                        helper.method_35972((class_2248)material.getBlockInterface(), poso);
                        helper.method_35987(poso, (class_2769)Interface.ENABLED, (Comparable)Boolean.valueOf(true));
                        continue;
                    }
                    helper.method_35972((class_2248)material.getBlockWall(), poso);
                    helper.method_35987(poso, (class_2769)ChestWall.ENABLED, (Comparable)Boolean.valueOf(true));
                }
            }
        }
    }

    protected void assertChestInvalid(class_4516 helper, class_2338 pos, ChestMaterial material, int dimension, Set<class_2338> exclude, Set<class_2338> interfaces) {
        for (int x = 0; x < dimension; ++x) {
            for (int y = 0; y < dimension; ++y) {
                for (int z = 0; z < dimension; ++z) {
                    class_2338 poso = pos.method_10069(x, y, z);
                    if (exclude.contains(poso)) {
                        helper.method_35972(class_2246.field_10124, poso);
                        continue;
                    }
                    if (x == 0 && y == 0 && z == 0) {
                        helper.method_35972((class_2248)material.getBlockCore(), poso);
                        helper.method_35987(poso, (class_2769)ColossalChest.ENABLED, (Comparable)Boolean.valueOf(false));
                        helper.method_60651(poso, be -> be.getInventory().method_5439() == 0, () -> "Inventory is not of size zero");
                        helper.method_60651(poso, be -> be.getInventory().method_5442(), () -> "Inventory is not empty");
                        continue;
                    }
                    if (x != 0 && y != 0 && z != 0 && x != dimension - 1 && y != dimension - 1 && z != dimension - 1) continue;
                    if (interfaces.contains(poso)) {
                        helper.method_35972((class_2248)material.getBlockInterface(), poso);
                        helper.method_35987(poso, (class_2769)Interface.ENABLED, (Comparable)Boolean.valueOf(false));
                        continue;
                    }
                    helper.method_35972((class_2248)material.getBlockWall(), poso);
                    helper.method_35987(poso, (class_2769)ChestWall.ENABLED, (Comparable)Boolean.valueOf(false));
                }
            }
        }
    }

    protected void assertHopperContains(class_4516 helper, class_2338 pos, class_1799 itemStack) {
        helper.method_60651(pos, be -> {
            for (int i = 0; i < be.method_5439(); ++i) {
                if (!class_1799.method_31577((class_1799)be.method_5438(i), (class_1799)itemStack)) continue;
                return true;
            }
            return false;
        }, () -> "Hopper does not contain item");
    }

    protected void assertCoreContains(class_4516 helper, class_2338 pos, class_1799 itemStack) {
        helper.method_60651(pos, be -> {
            for (int i = 0; i < be.getInventory().method_5439(); ++i) {
                if (!class_1799.method_31577((class_1799)be.getInventory().method_5438(i), (class_1799)itemStack)) continue;
                return true;
            }
            return false;
        }, () -> "Colossal chest core does not contain item");
    }

    protected void assertPlayerInventoryContains(class_4516 helper, class_1657 player, class_1799 itemStack) {
        boolean contains = false;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            if (!class_1799.method_31577((class_1799)player.method_31548().method_5438(i), (class_1799)itemStack)) continue;
            contains = true;
            break;
        }
        helper.method_46226(contains, "Player does not contain item");
    }

    protected void assertPlayerInventoryNotContains(class_4516 helper, class_1657 player, class_1799 itemStack) {
        boolean contains = false;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            if (!class_1799.method_31577((class_1799)player.method_31548().method_5438(i), (class_1799)itemStack)) continue;
            contains = true;
            break;
        }
        helper.method_49994(contains, "Player does contain item");
    }

    protected void destroyBlock(class_4516 helper, class_2338 pos) {
        class_2680 blockState = helper.method_35980(pos);
        boolean removed = helper.method_35943().method_8650(helper.method_36052(pos), false);
        if (removed) {
            blockState.method_26204().method_9585((class_1936)helper.method_35943(), helper.method_36052(pos), blockState);
        }
    }

    private void setBlockAsPlayer(class_4516 helper, class_2338 pos, class_2248 block) {
        class_1657 player = helper.method_36021(class_1934.field_9215);
        class_1799 itemStack = new class_1799((class_1935)block);
        player.method_6122(class_1268.field_5808, itemStack);
        class_1269 interactionResult = itemStack.method_7981(new class_1838(player, class_1268.field_5808, new class_3965(pos.method_46558(), class_2350.field_11033, helper.method_36052(pos), false)));
        helper.method_46226(interactionResult.method_23665(), "Block placement as player failed");
    }

    protected boolean isFabric() {
        try {
            Class.forName("net.fabricmc.fabric.api.transfer.v1.item.ItemStorage");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

