/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.client.gui.container;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.cyclops.colossalchests.ColossalChestsInstance;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChest;
import org.cyclops.colossalchests.network.packet.ServerboundContainerClickPacketOverride;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenScrollingCommon;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainerCommon;
import org.cyclops.cyclopscore.network.PacketBase;

public class ContainerScreenColossalChest
extends ContainerScreenScrollingCommon<ContainerColossalChest> {
    private static final int TEXTUREWIDTH = 195;
    private static final int TEXTUREHEIGHT = 194;

    public ContainerScreenColossalChest(ContainerColossalChest container, Inventory inventory, Component title) {
        super((ScrollingInventoryContainerCommon)container, inventory, title);
    }

    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new ButtonArrow(this.leftPos + 173, this.topPos + 7, (Component)Component.translatable((String)"gui.cyclopscore.up"), button -> this.scrollRelative(1), ButtonArrow.Direction.NORTH));
        this.addRenderableWidget((GuiEventListener)new ButtonArrow(this.leftPos + 173, this.topPos + 129, (Component)Component.translatable((String)"gui.cyclopscore.down"), button -> this.scrollRelative(-1), ButtonArrow.Direction.SOUTH));
    }

    protected void scrollRelative(int direction) {
        int multiplier = Minecraft.getInstance().player.isCrouching() ? 9 : 1;
        this.getScrollbar().scrollRelative((double)(direction * multiplier));
    }

    protected boolean isSearchEnabled() {
        return false;
    }

    protected boolean isSubsetRenderSlots() {
        return true;
    }

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"textures/gui/colossal_chest.png");
    }

    protected int getBaseXSize() {
        return 195;
    }

    protected int getBaseYSize() {
        return 194;
    }

    protected void drawForgegroundString(GuiGraphics guiGraphics) {
        guiGraphics.drawString(this.font, this.getTitle().getString(), 8 + this.offsetX, 6 + this.offsetY, 0x404040, false);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.drawForgegroundString(guiGraphics);
    }

    protected void slotClicked(Slot slotIn, int slotId, int clickedButton, ClickType clickType) {
        if (slotIn != null) {
            slotId = slotIn.index;
        }
        this.handleInventoryMouseClick(((ContainerColossalChest)this.container).containerId, slotId, clickedButton, clickType, (Player)this.minecraft.player);
    }

    protected void handleInventoryMouseClick(int windowId, int slotId, int mouseButtonClicked, ClickType clickType, Player playerIn) {
        AbstractContainerMenu abstractcontainermenu = playerIn.containerMenu;
        NonNullList nonnulllist = abstractcontainermenu.slots;
        int i = nonnulllist.size();
        ArrayList list = Lists.newArrayListWithCapacity((int)i);
        for (Slot slot : nonnulllist) {
            list.add(slot.getItem().copy());
        }
        abstractcontainermenu.clicked(slotId, mouseButtonClicked, clickType, playerIn);
        Int2ObjectOpenHashMap changedSlots = new Int2ObjectOpenHashMap();
        for (int j = 0; j < i; ++j) {
            ItemStack itemstack1;
            ItemStack itemstack = (ItemStack)list.get(j);
            if (ItemStack.matches((ItemStack)itemstack, (ItemStack)(itemstack1 = ((Slot)nonnulllist.get(j)).getItem()))) continue;
            changedSlots.put(j, (Object)itemstack1.copy());
        }
        ColossalChestsInstance.MOD.getPacketHandlerCommon().sendToServer((PacketBase)new ServerboundContainerClickPacketOverride(windowId, abstractcontainermenu.getStateId(), slotId, mouseButtonClicked, clickType, abstractcontainermenu.getCarried().copy(), (Int2ObjectMap<ItemStack>)changedSlots));
    }
}

