/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.network.packet;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public class ClientboundContainerSetContentPacketWindow
extends PacketCodec<ClientboundContainerSetContentPacketWindow> {
    public static final CustomPacketPayload.Type<ClientboundContainerSetContentPacketWindow> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"colossalchests", (String)"clientbound_container_set_content_packet_window"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundContainerSetContentPacketWindow> CODEC = ClientboundContainerSetContentPacketWindow.getCodec(ClientboundContainerSetContentPacketWindow::new);
    @CodecField
    private int windowId;
    @CodecField
    private int stateId;
    @CodecField
    private CompoundTag itemStacks;

    public ClientboundContainerSetContentPacketWindow() {
        super(TYPE);
    }

    public ClientboundContainerSetContentPacketWindow(int windowId, int stateId, CompoundTag itemStacks) {
        super(TYPE);
        this.windowId = windowId;
        this.stateId = stateId;
        this.itemStacks = itemStacks;
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
        if (this.windowId == 0) {
            this.putStacksInSlotsWithOffset((HolderLookup.Provider)world.registryAccess(), (AbstractContainerMenu)player.inventoryMenu);
        } else if (this.windowId == player.containerMenu.containerId) {
            this.putStacksInSlotsWithOffset((HolderLookup.Provider)world.registryAccess(), player.containerMenu);
        }
    }

    protected void putStacksInSlotsWithOffset(HolderLookup.Provider provider, AbstractContainerMenu container) {
        ListTag list = this.itemStacks.getList("stacks", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.getCompound(i);
            int slot = tag.getInt("slot");
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("stack"));
            container.setItem(slot, this.stateId, stack);
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

