/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.roughlyenoughprofessions;

import com.mrbysco.roughlyenoughprofessions.platform.Services;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class VillagerCache {
    private static Villager cachedVillager;

    @Nullable
    public static Villager getVillagerEntity(Holder<VillagerProfession> professionHolder) {
        if (cachedVillager == null) {
            Villager villager;
            CompoundTag nbt = new CompoundTag();
            nbt.putString("id", Services.PLATFORM.getVillagerID());
            Minecraft mc = Minecraft.getInstance();
            ClientLevel level = mc.level;
            if (level != null && (villager = (Villager)EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)level, (EntitySpawnReason)EntitySpawnReason.COMMAND, Function.identity())) != null) {
                cachedVillager = villager;
            }
        } else {
            cachedVillager.setVillagerData(cachedVillager.getVillagerData().withProfession(professionHolder));
            return cachedVillager;
        }
        return null;
    }
}

