/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.roughlyenoughprofessions.profession;

import com.mrbysco.roughlyenoughprofessions.RenderHelper;
import com.mrbysco.roughlyenoughprofessions.profession.ProfessionEntry;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2f;

public class ProfessionDisplay {
    protected final ProfessionEntry entry;

    public ProfessionDisplay(ProfessionEntry entry) {
        this.entry = entry;
    }

    public ResourceLocation getProfessionName() {
        return ((ResourceKey)this.entry.profession().unwrapKey().orElseThrow()).location();
    }

    public Component getDisplayName() {
        ResourceLocation professionKey = this.getProfessionName();
        String languageKey = professionKey.toLanguageKey();
        if (languageKey.startsWith("minecraft.")) {
            languageKey = languageKey.replace("minecraft.", "");
        }
        return Component.translatable((String)("entity.minecraft.villager." + languageKey));
    }

    public List<ItemStack> getBlockStacks() {
        return this.entry.blockStacks();
    }

    public void drawEntry(GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Matrix3x2fStack poseStack = guiGraphics.pose();
        Villager entityVillager = this.entry.getVillagerEntity();
        if (entityVillager != null) {
            Vector2f position = new Vector2f(26.0f, 62.0f);
            position = poseStack.transformPosition(position);
            int x = Math.round(position.x);
            int y = Math.round(position.y);
            RenderHelper.renderVillager(guiGraphics, x, y, 25.0, Mth.wrapDegrees((double)(38.0 - mouseX)), Mth.wrapDegrees((double)(15.0 - mouseY)), entityVillager);
        }
    }
}

