/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.roughlyenoughprofessions.rei;

import com.mrbysco.roughlyenoughprofessions.compat.CompatibilityHelper;
import com.mrbysco.roughlyenoughprofessions.profession.ProfessionEntry;
import com.mrbysco.roughlyenoughprofessions.rei.ProfessionCategory;
import com.mrbysco.roughlyenoughprofessions.rei.ProfessionDisplayNeoForge;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

@REIPluginClient
public class REPClientPlugin
implements REIClientPlugin {
    public static final CategoryIdentifier<ProfessionDisplayNeoForge> PROFESSION = CategoryIdentifier.of((String)"roughlyenoughprofessions", (String)"plugins/profession");

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new ProfessionCategory());
        registry.addWorkstations(PROFESSION, new EntryStack[]{EntryStacks.of((ItemLike)Items.EMERALD), EntryStacks.of((ItemLike)Items.VILLAGER_SPAWN_EGG)});
    }

    public void registerDisplays(DisplayRegistry registry) {
        LinkedList<ProfessionDisplayNeoForge> entries = new LinkedList<ProfessionDisplayNeoForge>();
        List professions = BuiltInRegistries.VILLAGER_PROFESSION.registryKeySet().stream().toList();
        for (ResourceKey professionKey : professions) {
            if (professionKey == VillagerProfession.NONE) continue;
            LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
            LinkedList<ResourceLocation> knownItems = new LinkedList<ResourceLocation>();
            List types = BuiltInRegistries.POINT_OF_INTEREST_TYPE.stream().toList();
            VillagerProfession profession = (VillagerProfession)BuiltInRegistries.VILLAGER_PROFESSION.getValue(professionKey);
            if (profession == null) continue;
            for (PoiType poiType : types) {
                if (!profession.acquirableJobSite().test(BuiltInRegistries.POINT_OF_INTEREST_TYPE.wrapAsHolder((Object)poiType))) continue;
                for (BlockState state : poiType.matchingStates()) {
                    Block block = state.getBlock();
                    if (block == null) continue;
                    ItemStack stack = CompatibilityHelper.compatibilityCheck(new ItemStack((ItemLike)block), BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession));
                    ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                    if (stack.isEmpty() || knownItems.contains(location)) continue;
                    stacks.add(stack);
                    knownItems.add(location);
                }
            }
            if (stacks.isEmpty()) continue;
            entries.add(new ProfessionDisplayNeoForge(new ProfessionEntry((Holder<VillagerProfession>)((Holder)BuiltInRegistries.VILLAGER_PROFESSION.get(professionKey).orElse(null)), stacks)));
        }
        entries.forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
    }
}

