/*
 * Decompiled with CFR 0.152.
 */
package com.example.christmasgift;

import com.example.christmasgift.ChristmasGift;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AdvancedRewardSystem {
    private final ChristmasGift plugin;
    private final Random random = new Random();
    private final Map<String, RewardTier> rewardTiers = new HashMap<String, RewardTier>();

    public AdvancedRewardSystem(ChristmasGift plugin) {
        this.plugin = plugin;
        this.loadRewardTiers();
    }

    private void loadRewardTiers() {
        ConfigurationSection tiersSection = this.plugin.getRewardsConfig().getConfigurationSection("tiers");
        if (tiersSection == null) {
            return;
        }
        for (String tierName : tiersSection.getKeys(false)) {
            ConfigurationSection tierSection = tiersSection.getConfigurationSection(tierName);
            if (tierSection == null) continue;
            RewardTier tier = new RewardTier(tierName, tierSection.getDouble("chance", 0.0), tierSection.getString("color", "&f"), tierSection.getString("prefix", ""), tierSection.getStringList("rewards"));
            this.rewardTiers.put(tierName, tier);
        }
    }

    public void reloadRewardTiers() {
        this.rewardTiers.clear();
        this.loadRewardTiers();
    }

    public String calculateTier() {
        RewardTier selectedTier = this.selectTier();
        return selectedTier != null ? selectedTier.getName() : "common";
    }

    public void giveReward(Player player, String tierName) {
        RewardTier selectedTier = this.rewardTiers.get(tierName);
        if (selectedTier == null) {
            selectedTier = this.rewardTiers.get("common");
        }
        if (selectedTier == null) {
            return;
        }
        String reward = this.selectRewardFromTier(selectedTier);
        if (reward == null) {
            return;
        }
        double multiplier = this.plugin.getComboSystem().getMultiplier(player);
        int comboCount = this.plugin.getComboSystem().getComboCount(player);
        String multipliedReward = this.applyMultiplier(reward, multiplier);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            String command = multipliedReward.replace("%player%", player.getName());
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), command);
        });
        Object rewardDisplay = this.formatRewardDisplay(multipliedReward);
        if (comboCount >= 3) {
            String comboText = String.valueOf(ChatColor.YELLOW) + " (x" + String.format("%.1f", multiplier) + " Combo!)";
            rewardDisplay = (String)rewardDisplay + comboText;
        }
        this.sendRewardTitle(player, selectedTier, (String)rewardDisplay);
        this.broadcastReward(player.getName(), (String)rewardDisplay, selectedTier);
    }

    public void giveReward(Player player) {
        String tier = this.calculateTier();
        this.giveReward(player, tier);
    }

    private void sendRewardTitle(Player player, RewardTier tier, String rewardDisplay) {
        String title = ChatColor.translateAlternateColorCodes((char)'&', (String)(tier.getColor() + "\u2726 " + tier.getName().toUpperCase() + " REWARD \u2726"));
        String subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)("&fYou received &e" + rewardDisplay + "&f!"));
        player.sendTitle(title, subtitle, 10, 70, 20);
    }

    private void broadcastReward(String playerName, String rewardDisplay, RewardTier tier) {
        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)(tier.getColor() + "\u2726 " + tier.getName().toUpperCase() + " \u2726 &f" + playerName + " received &e" + rewardDisplay + "&f!"));
        this.plugin.getServer().broadcastMessage(message);
    }

    private String formatRewardDisplay(String command) {
        StringBuilder message = new StringBuilder();
        String[] parts = command.split(" ");
        try {
            if (command.contains("give")) {
                int amount = 1;
                String itemName = "";
                for (int i = 0; i < parts.length; ++i) {
                    if (!parts[i].equals("give") || i + 2 >= parts.length) continue;
                    String rawItem = parts[i + 2];
                    if (rawItem.contains(":")) {
                        rawItem = rawItem.substring(rawItem.indexOf(":") + 1);
                    }
                    if (rawItem.contains("[")) {
                        rawItem = rawItem.substring(0, rawItem.indexOf("["));
                    }
                    if (rawItem.contains("{")) {
                        rawItem = rawItem.substring(0, rawItem.indexOf("{"));
                    }
                    itemName = this.formatItemName(rawItem);
                    if (i + 3 >= parts.length) break;
                    try {
                        String potentialAmount = parts[i + 3];
                        if (potentialAmount.startsWith("{") || potentialAmount.startsWith("[")) break;
                        amount = Integer.parseInt(potentialAmount);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                if (amount > 1) {
                    message.append(amount).append("x ").append(itemName);
                } else {
                    message.append(itemName);
                }
            } else if (command.contains("xp add")) {
                String amount = parts[parts.length - 1];
                message.append(this.formatNumber(Integer.parseInt(amount))).append(" XP");
            } else if (command.contains("eco give")) {
                String amount = parts[parts.length - 1];
                message.append("$").append(this.formatNumber(Integer.parseInt(amount)));
            } else {
                message.append("Special Reward");
            }
        }
        catch (Exception e) {
            message.append("Special Reward");
        }
        return message.toString();
    }

    private String formatItemName(String rawName) {
        String name = rawName.toLowerCase().replace("_", " ").replace("netherite", "Netherite").replace("diamond", "Diamond").replace("emerald", "Emerald").replace("golden apple", "Golden Apple").replace("enchanted golden apple", "Enchanted Golden Apple");
        String[] words = name.split(" ");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            if (word.length() <= 0) continue;
            formatted.append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
        }
        return formatted.toString();
    }

    private String formatNumber(int number) {
        if (number >= 1000000) {
            return String.format("%.1fM", (double)number / 1000000.0);
        }
        if (number >= 1000) {
            return String.format("%.1fK", (double)number / 1000.0);
        }
        return String.format("%,d", number);
    }

    private RewardTier selectTier() {
        double totalChance = this.rewardTiers.values().stream().mapToDouble(RewardTier::getChance).sum();
        double random = this.random.nextDouble() * totalChance;
        double cumulative = 0.0;
        for (RewardTier tier : this.rewardTiers.values()) {
            if (!(random <= (cumulative += tier.getChance()))) continue;
            return tier;
        }
        return null;
    }

    private String selectRewardFromTier(RewardTier tier) {
        List<String> rewards = tier.getRewards();
        if (rewards.isEmpty()) {
            return null;
        }
        return rewards.get(this.random.nextInt(rewards.size()));
    }

    private String applyMultiplier(String command, double multiplier) {
        if (multiplier <= 1.0) {
            return command;
        }
        String[] parts = command.split(" ");
        StringBuilder result = new StringBuilder();
        try {
            if (command.contains("give")) {
                for (int i = 0; i < parts.length; ++i) {
                    int multipliedAmount;
                    if (i > 0) {
                        result.append(" ");
                    }
                    if (i >= 3 && i == 3) {
                        try {
                            int amount = Integer.parseInt(parts[i]);
                            multipliedAmount = (int)Math.ceil((double)amount * multiplier);
                            result.append(multipliedAmount);
                        }
                        catch (NumberFormatException e) {
                            result.append(parts[i]);
                        }
                        continue;
                    }
                    if (i == parts.length - 1 && i >= 3) {
                        try {
                            int amount = Integer.parseInt(parts[i]);
                            multipliedAmount = (int)Math.ceil((double)amount * multiplier);
                            result.append(multipliedAmount);
                        }
                        catch (NumberFormatException e) {
                            result.append(parts[i]);
                        }
                        continue;
                    }
                    result.append(parts[i]);
                }
            } else if (command.contains("xp add") || command.contains("eco give")) {
                for (int i = 0; i < parts.length; ++i) {
                    if (i > 0) {
                        result.append(" ");
                    }
                    if (i == parts.length - 1) {
                        try {
                            int amount = Integer.parseInt(parts[i]);
                            int multipliedAmount = (int)Math.ceil((double)amount * multiplier);
                            result.append(multipliedAmount);
                        }
                        catch (NumberFormatException e) {
                            result.append(parts[i]);
                        }
                        continue;
                    }
                    result.append(parts[i]);
                }
            } else {
                return command;
            }
            return result.toString();
        }
        catch (Exception e) {
            return command;
        }
    }

    private static class RewardTier {
        private final String name;
        private final double chance;
        private final String color;
        private final String prefix;
        private final List<String> rewards;

        public RewardTier(String name, double chance, String color, String prefix, List<String> rewards) {
            this.name = name;
            this.chance = chance;
            this.color = color;
            this.prefix = prefix;
            this.rewards = rewards;
        }

        public String getName() {
            return this.name;
        }

        public double getChance() {
            return this.chance;
        }

        public String getColor() {
            return this.color;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public List<String> getRewards() {
            return this.rewards;
        }

        public String toString() {
            return "RewardTier{name='" + this.name + "', chance=" + this.chance + ", color='" + this.color + "', prefix='" + this.prefix + "', rewards=" + String.valueOf(this.rewards) + "}";
        }
    }
}

