/*
 * Decompiled with CFR 0.152.
 */
package com.example.christmasgift;

import com.example.christmasgift.AdvancedRewardSystem;
import com.example.christmasgift.ComboSystem;
import com.example.christmasgift.GiftCommand;
import com.example.christmasgift.GiftEffects;
import com.example.christmasgift.GiftListener;
import com.example.christmasgift.GuiHandler;
import com.example.christmasgift.RouletteSystem;
import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChristmasGift
extends JavaPlugin {
    private static ChristmasGift instance;
    private FileConfiguration rewardsConfig;
    private File rewardsFile;
    private AdvancedRewardSystem rewardSystem;
    private GiftEffects giftEffects;
    private RouletteSystem rouletteSystem;
    private ComboSystem comboSystem;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.setupRewardsConfig();
        this.rewardSystem = new AdvancedRewardSystem(this);
        this.giftEffects = new GiftEffects(this);
        this.rouletteSystem = new RouletteSystem(this);
        this.comboSystem = new ComboSystem(this);
        this.getServer().getPluginManager().registerEvents((Listener)new GiftListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GuiHandler(this), (Plugin)this);
        this.getCommand("christmasgift").setExecutor((CommandExecutor)new GiftCommand(this));
        this.getLogger().info("ChristmasGift Plugin has been enabled!");
        this.getLogger().info("Roulette System activated! \ud83c\udfb0");
        this.getLogger().info("Combo System activated! \ud83d\udd25");
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.saveRewardsConfig();
        this.getLogger().info("ChristmasGift Plugin has been disabled!");
    }

    public static ChristmasGift getInstance() {
        return instance;
    }

    private void setupRewardsConfig() {
        this.rewardsFile = new File(this.getDataFolder(), "rewards.yml");
        if (!this.rewardsFile.exists()) {
            this.rewardsFile.getParentFile().mkdirs();
            this.saveResource("rewards.yml", false);
        }
        this.rewardsConfig = YamlConfiguration.loadConfiguration((File)this.rewardsFile);
    }

    public void saveRewardsConfig() {
        if (this.rewardsConfig == null || this.rewardsFile == null) {
            return;
        }
        try {
            this.rewardsConfig.save(this.rewardsFile);
        }
        catch (Exception e) {
            this.getLogger().severe("Could not save rewards config: " + e.getMessage());
        }
    }

    public FileConfiguration getRewardsConfig() {
        return this.rewardsConfig;
    }

    public AdvancedRewardSystem getRewardSystem() {
        return this.rewardSystem;
    }

    public GiftEffects getGiftEffects() {
        return this.giftEffects;
    }

    public RouletteSystem getRouletteSystem() {
        return this.rouletteSystem;
    }

    public ComboSystem getComboSystem() {
        return this.comboSystem;
    }

    public void reloadRewardsConfig() {
        if (!this.rewardsFile.exists()) {
            this.saveResource("rewards.yml", false);
        }
        this.rewardsConfig = YamlConfiguration.loadConfiguration((File)this.rewardsFile);
        if (this.rewardSystem != null) {
            this.rewardSystem.reloadRewardTiers();
        }
    }
}

