/*
 * Decompiled with CFR 0.152.
 */
package com.example.christmasgift;

import com.example.christmasgift.ChristmasGift;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ComboSystem {
    private final ChristmasGift plugin;
    private final Map<UUID, ComboData> playerCombos = new HashMap<UUID, ComboData>();
    private static final long COMBO_TIMEOUT = 10000L;
    private static final int COMBO_TIER_1 = 3;
    private static final int COMBO_TIER_2 = 5;
    private static final int COMBO_TIER_3 = 10;

    public ComboSystem(ChristmasGift plugin) {
        this.plugin = plugin;
        this.startComboChecker();
    }

    public void addCombo(Player player) {
        UUID playerId = player.getUniqueId();
        ComboData data = this.playerCombos.getOrDefault(playerId, new ComboData());
        ++data.combo;
        data.lastOpenTime = System.currentTimeMillis();
        this.playerCombos.put(playerId, data);
        this.displayCombo(player, data.combo);
        this.playComboEffects(player, data.combo);
    }

    public double getMultiplier(Player player) {
        ComboData data = this.playerCombos.get(player.getUniqueId());
        if (data == null) {
            return 1.0;
        }
        int combo = data.combo;
        if (combo >= 10) {
            return 3.0;
        }
        if (combo >= 5) {
            return 2.0;
        }
        if (combo >= 3) {
            return 1.5;
        }
        return 1.0;
    }

    public int getComboCount(Player player) {
        ComboData data = this.playerCombos.get(player.getUniqueId());
        return data != null ? data.combo : 0;
    }

    private void displayCombo(Player player, int combo) {
        String message;
        if (combo >= 10) {
            String colorCode = ChatColor.LIGHT_PURPLE.toString() + ChatColor.BOLD.toString();
            message = colorCode + "@ " + combo + "x COMBO! @ [3.0x MULTIPLIER]";
        } else if (combo >= 5) {
            String colorCode = ChatColor.GOLD.toString() + ChatColor.BOLD.toString();
            message = colorCode + "* " + combo + "x COMBO! * [2.0x MULTIPLIER]";
        } else if (combo >= 3) {
            String colorCode = ChatColor.AQUA.toString() + ChatColor.BOLD.toString();
            message = colorCode + "# " + combo + "x COMBO! # [1.5x MULTIPLIER]";
        } else {
            String colorCode = ChatColor.YELLOW.toString();
            message = colorCode + combo + "x Combo";
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
        if (combo >= 3) {
            player.sendMessage(message);
        }
    }

    private void playComboEffects(Player player, int combo) {
        Location loc = player.getLocation().add(0.0, 1.0, 0.0);
        if (combo >= 10) {
            player.playSound(loc, Sound.ENTITY_ENDER_DRAGON_GROWL, 0.5f, 2.0f);
            player.playSound(loc, Sound.ENTITY_FIREWORK_ROCKET_BLAST, 1.0f, 1.5f);
            this.spawnComboParticles(player, Particle.DRAGON_BREATH, 20);
            this.spawnComboParticles(player, Particle.END_ROD, 15);
            this.spawnComboParticles(player, Particle.ELECTRIC_SPARK, 10);
        } else if (combo >= 5) {
            player.playSound(loc, Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.5f);
            player.playSound(loc, Sound.BLOCK_BELL_USE, 1.0f, 2.0f);
            this.spawnComboParticles(player, Particle.FLAME, 15);
            this.spawnComboParticles(player, Particle.FIREWORK, 10);
        } else if (combo >= 3) {
            player.playSound(loc, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.5f);
            player.playSound(loc, Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
            this.spawnComboParticles(player, Particle.CRIT, 10);
            this.spawnComboParticles(player, Particle.WITCH, 8);
        } else {
            player.playSound(loc, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.0f + (float)combo * 0.1f);
        }
    }

    private void spawnComboParticles(final Player player, final Particle particle, int count) {
        final Location loc = player.getLocation().add(0.0, 1.0, 0.0);
        new BukkitRunnable(this){
            private int ticks = 0;
            final /* synthetic */ ComboSystem this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticks >= 10 || !player.isOnline()) {
                    this.cancel();
                    return;
                }
                double angle = (double)this.ticks * Math.PI / 4.0;
                double radius = 1.0;
                for (int i = 0; i < 3; ++i) {
                    double offsetAngle = angle + (double)i * Math.PI * 2.0 / 3.0;
                    double x = Math.cos(offsetAngle) * radius;
                    double z = Math.sin(offsetAngle) * radius;
                    Location particleLoc = loc.clone().add(x, (double)this.ticks * 0.1, z);
                    player.getWorld().spawnParticle(particle, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void breakCombo(Player player) {
        UUID playerId = player.getUniqueId();
        ComboData data = this.playerCombos.get(playerId);
        if (data == null || data.combo < 3) {
            this.playerCombos.remove(playerId);
            return;
        }
        String breakerMessage = ChatColor.RED.toString() + ChatColor.BOLD.toString() + "X COMBO BREAKER! X";
        String infoMessage = String.valueOf(ChatColor.GRAY) + "Your " + data.combo + "x combo has ended!";
        player.sendMessage(breakerMessage);
        player.sendMessage(infoMessage);
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 0.5f);
        player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
        Location loc = player.getLocation().add(0.0, 1.0, 0.0);
        player.getWorld().spawnParticle(Particle.SMOKE, loc, 20, 0.5, 0.5, 0.5, 0.1);
        player.getWorld().spawnParticle(Particle.CAMPFIRE_COSY_SMOKE, loc, 10, 0.3, 0.3, 0.3, 0.05);
        this.playerCombos.remove(playerId);
    }

    private void startComboChecker() {
        new BukkitRunnable(){

            public void run() {
                long currentTime = System.currentTimeMillis();
                ComboSystem.this.playerCombos.entrySet().removeIf(entry -> {
                    UUID playerId = (UUID)entry.getKey();
                    ComboData data = (ComboData)entry.getValue();
                    if (currentTime - data.lastOpenTime > 10000L) {
                        Player player = ComboSystem.this.plugin.getServer().getPlayer(playerId);
                        if (player != null && player.isOnline()) {
                            ComboSystem.this.breakCombo(player);
                        }
                        return true;
                    }
                    return false;
                });
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    public void clearCombo(Player player) {
        this.playerCombos.remove(player.getUniqueId());
    }

    private static class ComboData {
        int combo = 0;
        long lastOpenTime = 0L;

        private ComboData() {
        }
    }
}

