/*
 * Decompiled with CFR 0.152.
 */
package com.example.christmasgift;

import com.example.christmasgift.ChristmasGift;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GiftCommand
implements CommandExecutor {
    private final ChristmasGift plugin;

    public GiftCommand(ChristmasGift plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("christmasgift.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cThis command can only be used by players!");
                return true;
            }
            this.openAdminGUI((Player)sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("give")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cThis command can only be used by players!");
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage("\u00a7cUsage: /christmasgift give <amount>");
                return true;
            }
            try {
                int amount = Integer.parseInt(args[1]);
                if (amount <= 0 || amount > 64) {
                    sender.sendMessage("\u00a7cAmount must be between 1-64!");
                    return true;
                }
                this.giveGift((Player)sender, amount);
                sender.sendMessage("\u00a7aYou have received " + amount + " Christmas Gift!");
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cAmount must be a number!");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            try {
                this.plugin.reloadConfig();
                this.plugin.reloadRewardsConfig();
                this.plugin.getRewardSystem().reloadRewardTiers();
                sender.sendMessage("\u00a7a\u00a7lChristmasGift \u00a77\u00bb \u00a7aConfiguration reloaded successfully!");
                return true;
            }
            catch (Exception e) {
                sender.sendMessage("\u00a7c\u00a7lChristmasGift \u00a77\u00bb \u00a7cAn error occurred while reloading configuration!");
                this.plugin.getLogger().severe("Error reloading config: " + e.getMessage());
                return true;
            }
        }
        sender.sendMessage("\u00a7cUsage: /christmasgift [give <amount>|reload]");
        return true;
    }

    private void openAdminGUI(Player player) {
        Inventory gui = this.plugin.getServer().createInventory(null, 54, "Christmas Gift Admin");
        ConfigurationSection tiers = this.plugin.getRewardsConfig().getConfigurationSection("tiers");
        if (tiers != null) {
            int slot = 0;
            for (String tierName : tiers.getKeys(false)) {
                if (slot >= 53) break;
                ConfigurationSection tier = tiers.getConfigurationSection(tierName);
                if (tier == null) continue;
                ItemStack item = new ItemStack(Material.BOOK);
                ItemMeta meta = item.getItemMeta();
                String color = tier.getString("color", "&f");
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)(color + "Tier: " + tierName)));
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add("\u00a77Chance: " + tier.getDouble("chance") + "%");
                lore.add("\u00a77Prefix: " + tier.getString("prefix"));
                lore.add("");
                lore.add("\u00a7eLeft click to edit chance");
                lore.add("\u00a7eRight click to edit rewards");
                lore.add("\u00a7eShift + Right click to edit prefix");
                meta.setLore(lore);
                item.setItemMeta(meta);
                gui.setItem(slot++, item);
            }
        }
        ItemStack newTier = new ItemStack(Material.EMERALD);
        ItemMeta meta = newTier.getItemMeta();
        meta.setDisplayName("\u00a7a\u00a7lAdd New Tier");
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Click to add a new tier");
        meta.setLore(lore);
        newTier.setItemMeta(meta);
        gui.setItem(53, newTier);
        player.openInventory(gui);
    }

    private void giveGift(Player player, int amount) {
        ItemStack gift = new ItemStack(Material.CHEST, amount);
        ItemMeta meta = gift.getItemMeta();
        meta.setDisplayName("\u00a7c\u00a7lChristmas Gift");
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Right click to open!");
        lore.add("\u00a77\u2726 Contains special rewards!");
        lore.add("\u00a77\u2726 From Common to Mythic");
        meta.setLore(lore);
        gift.setItemMeta(meta);
        player.getInventory().addItem(new ItemStack[]{gift});
    }
}

