/*
 * Decompiled with CFR 0.152.
 */
package com.example.christmasgift;

import com.example.christmasgift.ChristmasGift;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GiftEffects {
    private final ChristmasGift plugin;

    public GiftEffects(ChristmasGift plugin) {
        this.plugin = plugin;
    }

    public void playOpeningAnimation(final Player player) {
        final Location loc = player.getLocation();
        new BukkitRunnable(this){
            private int step = 0;
            private final int STEPS = 30;
            private double angle = 0.0;
            final /* synthetic */ GiftEffects this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.step >= 30 || !player.isOnline()) {
                    this.cancel();
                    return;
                }
                if (this.step < 8) {
                    this.playSound(player, Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.0f + (float)this.step * 0.1f);
                    this.spawnSpiral(loc, this.step);
                } else if (this.step < 16) {
                    this.spawnRisingParticles(loc);
                    if (this.step % 2 == 0) {
                        this.playSound(player, Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.0f + (float)(this.step - 8) * 0.1f);
                    }
                } else if (this.step < 24) {
                    this.spawnFireworks(loc);
                    if (this.step == 16) {
                        this.playSound(player, Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                    }
                } else {
                    this.spawnSparkles(loc);
                }
                this.angle += 0.5235987755982988;
                ++this.step;
            }

            private void spawnSpiral(Location loc2, int step) {
                for (double i = 0.0; i < Math.PI * 2; i += 0.7853981633974483) {
                    double x = Math.cos(i + this.angle) * ((double)step * 0.2);
                    double z = Math.sin(i + this.angle) * ((double)step * 0.2);
                    loc2.add(x, 0.5, z);
                    player.getWorld().spawnParticle(Particle.FLAME, loc2, 1, 0.0, 0.0, 0.0, 0.0);
                    loc2.subtract(x, 0.5, z);
                }
            }

            private void spawnRisingParticles(Location loc2) {
                for (int i = 0; i < 6; ++i) {
                    double x = Math.cos(this.angle + (double)i * Math.PI / 3.0) * 0.8;
                    double z = Math.sin(this.angle + (double)i * Math.PI / 3.0) * 0.8;
                    loc2.add(x, 0.0, z);
                    player.getWorld().spawnParticle(Particle.SNOWFLAKE, loc2, 1, 0.0, 0.0, 0.0, 0.1);
                    player.getWorld().spawnParticle(Particle.END_ROD, loc2, 1, 0.0, 0.0, 0.0, 0.05);
                    loc2.subtract(x, 0.0, z);
                }
            }

            private void spawnFireworks(Location loc2) {
                for (int i = 0; i < 12; ++i) {
                    double x = Math.cos((double)i * Math.PI / 6.0) * 1.5;
                    double z = Math.sin((double)i * Math.PI / 6.0) * 1.5;
                    loc2.add(x, 1.0, z);
                    player.getWorld().spawnParticle(Particle.WITCH, loc2, 1, 0.0, 0.0, 0.0, 0.0);
                    player.getWorld().spawnParticle(Particle.FLAME, loc2, 1, 0.0, 0.0, 0.0, 0.0);
                    loc2.subtract(x, 1.0, z);
                }
            }

            private void spawnSparkles(Location loc2) {
                for (int i = 0; i < 3; ++i) {
                    double x = (Math.random() - 0.5) * 2.5;
                    double y = Math.random() * 1.5;
                    double z = (Math.random() - 0.5) * 2.5;
                    loc2.add(x, y, z);
                    player.getWorld().spawnParticle(Particle.INSTANT_EFFECT, loc2, 1, 0.0, 0.0, 0.0, 0.0);
                    player.getWorld().spawnParticle(Particle.FIREWORK, loc2, 1, 0.0, 0.0, 0.0, 0.0);
                    loc2.subtract(x, y, z);
                }
            }

            private void playSound(Player player2, Sound sound, float volume, float pitch) {
                player2.playSound(player2.getLocation(), sound, volume, pitch);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 2L);
    }
}

