/*
 * Decompiled with CFR 0.152.
 */
package com.example.christmasgift;

import com.example.christmasgift.ChristmasGift;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GiftListener
implements Listener {
    private final ChristmasGift plugin;
    private final Map<String, Long> cooldowns = new HashMap<String, Long>();
    private static final long COOLDOWN_TIME = 1000L;
    private static final long CLEANUP_INTERVAL = 300000L;

    public GiftListener(ChristmasGift plugin) {
        this.plugin = plugin;
        this.startCleanupTask();
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        long timeElapsed;
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (!(item != null && item.getType() == Material.CHEST && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().contains("Christmas Gift"))) {
            return;
        }
        String playerName = player.getName();
        if (this.cooldowns.containsKey(playerName) && (timeElapsed = System.currentTimeMillis() - this.cooldowns.get(playerName)) < 1000L) {
            return;
        }
        event.setCancelled(true);
        this.cooldowns.put(playerName, System.currentTimeMillis());
        this.plugin.getComboSystem().addCombo(player);
        this.plugin.getRouletteSystem().clearActionBar(player);
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else {
            player.getInventory().setItemInMainHand(null);
        }
        String selectedTier = this.plugin.getRewardSystem().calculateTier();
        this.plugin.getGiftEffects().playOpeningAnimation(player);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.isOnline()) {
                this.plugin.getRouletteSystem().startRouletteAnimation(player, selectedTier);
            }
        }, 10L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.cooldowns.remove(event.getPlayer().getName());
        this.plugin.getComboSystem().clearCombo(event.getPlayer());
        this.plugin.getRouletteSystem().clearActionBar(event.getPlayer());
    }

    private void startCleanupTask() {
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            long currentTime = System.currentTimeMillis();
            Iterator<Map.Entry<String, Long>> iterator = this.cooldowns.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Long> entry = iterator.next();
                if (currentTime - entry.getValue() <= 300000L) continue;
                iterator.remove();
            }
        }, 6000L, 6000L);
    }
}

