/*
 * Decompiled with CFR 0.152.
 */
package com.example.christmasgift;

import com.example.christmasgift.ChristmasGift;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class GuiHandler
implements Listener {
    private final ChristmasGift plugin;
    private final Map<UUID, GuiState> playerStates = new HashMap<UUID, GuiState>();
    private final Map<UUID, String> editingTier = new HashMap<UUID, String>();

    public GuiHandler(ChristmasGift plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (!title.equals("Christmas Gift Admin") && !title.contains("Rewards Editor: ")) {
            return;
        }
        event.setCancelled(true);
        if (event.getClickedInventory() == event.getView().getBottomInventory()) {
            return;
        }
        if (event.getClickedInventory() == null) {
            return;
        }
        if (event.getClickedInventory() != event.getView().getTopInventory()) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta() || !clicked.getItemMeta().hasDisplayName()) {
            return;
        }
        if (title.equals("Christmas Gift Admin")) {
            this.handleMainMenuClick(event);
        } else if (title.contains("Rewards Editor: ")) {
            this.handleRewardsEditorClick(event);
        }
    }

    private void handleMainMenuClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String itemName = clicked.getItemMeta().getDisplayName();
        if (itemName.contains("Tier: ")) {
            String tierName = ChatColor.stripColor((String)itemName.substring(itemName.indexOf("Tier: ") + 6));
            this.editingTier.put(player.getUniqueId(), tierName);
            if (event.getClick() == ClickType.LEFT) {
                player.closeInventory();
                this.playerStates.put(player.getUniqueId(), GuiState.EDITING_CHANCE);
                player.sendMessage("\u00a7e\u00a7lEnter new chance for tier " + tierName);
                player.sendMessage("\u00a77Format: <number> (example: 25.5)");
            } else if (event.getClick() == ClickType.RIGHT) {
                this.openRewardsEditor(player, tierName);
            } else if (event.getClick() == ClickType.SHIFT_RIGHT) {
                player.closeInventory();
                this.playerStates.put(player.getUniqueId(), GuiState.EDITING_PREFIX);
                player.sendMessage("\u00a7e\u00a7lEnter new prefix for tier " + tierName);
                player.sendMessage("\u00a77Format: &wPrefix (example: &6[Legendary])");
            }
        } else if (itemName.equals("\u00a7a\u00a7lAdd New Tier")) {
            player.closeInventory();
            this.playerStates.put(player.getUniqueId(), GuiState.ADDING_NEW_TIER);
            player.sendMessage("\u00a7e\u00a7lEnter new tier name");
            player.sendMessage("\u00a77Format: tier_name (example: mythic)");
        }
    }

    private void openRewardsEditor(Player player, String tierName) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)("Rewards Editor: " + tierName));
        ConfigurationSection tierSection = this.plugin.getRewardsConfig().getConfigurationSection("tiers." + tierName);
        if (tierSection != null) {
            List rewards = tierSection.getStringList("rewards");
            ItemStack border = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
            ItemMeta borderMeta = border.getItemMeta();
            borderMeta.setDisplayName(" ");
            border.setItemMeta(borderMeta);
            for (int i = 0; i < 54; ++i) {
                gui.setItem(i, border);
            }
            for (int row = 1; row < 5; ++row) {
                for (int col = 1; col < 8; ++col) {
                    gui.setItem(row * 9 + col, null);
                }
            }
            int slot = 10;
            int rewardIndex = 0;
            for (String reward : rewards) {
                ItemStack item = new ItemStack(Material.PAPER);
                ItemMeta meta = item.getItemMeta();
                meta.setDisplayName("\u00a76Reward #" + (rewardIndex + 1));
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add("\u00a77Command: " + reward);
                lore.add("");
                lore.add("\u00a7eLeft click to edit");
                lore.add("\u00a7cRight click to delete");
                meta.setLore(lore);
                item.setItemMeta(meta);
                gui.setItem(slot, item);
                ++rewardIndex;
                if (++slot % 9 != 8) continue;
                slot += 2;
            }
            ItemStack addButton = new ItemStack(Material.EMERALD);
            ItemMeta addMeta = addButton.getItemMeta();
            addMeta.setDisplayName("\u00a7a\u00a7lAdd New Reward");
            ArrayList<String> addLore = new ArrayList<String>();
            addLore.add("\u00a77Click to add a new reward");
            addMeta.setLore(addLore);
            addButton.setItemMeta(addMeta);
            gui.setItem(49, addButton);
            ItemStack backButton = new ItemStack(Material.BARRIER);
            ItemMeta backMeta = backButton.getItemMeta();
            backMeta.setDisplayName("\u00a7c\u00a7lBack");
            ArrayList<String> backLore = new ArrayList<String>();
            backLore.add("\u00a77Click to return to main menu");
            backMeta.setLore(backLore);
            backButton.setItemMeta(backMeta);
            gui.setItem(45, backButton);
        }
        player.openInventory(gui);
    }

    private void handleRewardsEditorClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getClickedInventory() != event.getView().getTopInventory()) {
            return;
        }
        String tierName = event.getView().getTitle().substring(event.getView().getTitle().indexOf(": ") + 2);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta() || !clicked.getItemMeta().hasDisplayName()) {
            return;
        }
        String itemName = clicked.getItemMeta().getDisplayName();
        if (itemName.equals("\u00a7c\u00a7lBack")) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getCommand("christmasgift").getExecutor().onCommand((CommandSender)player, null, "", new String[0]));
            return;
        }
        if (itemName.equals("\u00a7a\u00a7lAdd New Reward")) {
            player.closeInventory();
            this.editingTier.put(player.getUniqueId(), tierName);
            this.playerStates.put(player.getUniqueId(), GuiState.EDITING_COMMAND);
            player.sendMessage("\u00a7e\u00a7lEnter new reward command");
            player.sendMessage("\u00a77Format: command (example: give %player% diamond 5)");
            return;
        }
        if (itemName.contains("Reward #")) {
            try {
                ConfigurationSection tierSection;
                int rewardIndex = Integer.parseInt(itemName.substring(itemName.indexOf("#") + 1)) - 1;
                if (event.getClick() == ClickType.LEFT) {
                    player.closeInventory();
                    this.editingTier.put(player.getUniqueId(), tierName + ":" + rewardIndex);
                    this.playerStates.put(player.getUniqueId(), GuiState.EDITING_COMMAND);
                    player.sendMessage("\u00a7e\u00a7lEnter new command for this reward");
                    player.sendMessage("\u00a77Format: command (example: give %player% diamond 5)");
                } else if (event.getClick() == ClickType.RIGHT && (tierSection = this.plugin.getRewardsConfig().getConfigurationSection("tiers." + tierName)) != null) {
                    List rewards = tierSection.getStringList("rewards");
                    if (rewardIndex >= 0 && rewardIndex < rewards.size()) {
                        rewards.remove(rewardIndex);
                        tierSection.set("rewards", (Object)rewards);
                        this.plugin.saveRewardsConfig();
                        this.plugin.getRewardSystem().reloadRewardTiers();
                        this.openRewardsEditor(player, tierName);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        GuiState state = this.playerStates.get(playerId);
        if (state == null || state == GuiState.NONE) {
            return;
        }
        event.setCancelled(true);
        String message = event.getMessage();
        String tierName = this.editingTier.get(playerId);
        switch (state.ordinal()) {
            case 0: {
                try {
                    double chance = Double.parseDouble(message);
                    this.plugin.getRewardsConfig().set("tiers." + tierName + ".chance", (Object)chance);
                    this.plugin.saveRewardsConfig();
                    this.plugin.getRewardSystem().reloadRewardTiers();
                    player.sendMessage("\u00a7a\u00a7lChance successfully changed!");
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7c\u00a7lInvalid number format!");
                }
                break;
            }
            case 1: {
                this.plugin.getRewardsConfig().set("tiers." + tierName + ".prefix", (Object)message);
                this.plugin.saveRewardsConfig();
                this.plugin.getRewardSystem().reloadRewardTiers();
                player.sendMessage("\u00a7a\u00a7lPrefix successfully changed to: " + ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                break;
            }
            case 2: {
                ConfigurationSection tiersSection = this.plugin.getRewardsConfig().createSection("tiers." + message);
                tiersSection.set("chance", (Object)10.0);
                tiersSection.set("color", (Object)"&f");
                tiersSection.set("prefix", (Object)("&f[" + message.substring(0, 1).toUpperCase() + message.substring(1) + "]"));
                tiersSection.set("rewards", new ArrayList());
                this.plugin.saveRewardsConfig();
                this.plugin.getRewardSystem().reloadRewardTiers();
                player.sendMessage("\u00a7a\u00a7lNew tier successfully added!");
                break;
            }
            case 3: {
                if (tierName.contains(":")) {
                    String[] parts = tierName.split(":");
                    String tier = parts[0];
                    int index = Integer.parseInt(parts[1]);
                    List rewards = this.plugin.getRewardsConfig().getStringList("tiers." + tier + ".rewards");
                    rewards.set(index, message);
                    this.plugin.getRewardsConfig().set("tiers." + tier + ".rewards", (Object)rewards);
                } else {
                    List rewards = this.plugin.getRewardsConfig().getStringList("tiers." + tierName + ".rewards");
                    rewards.add(message);
                    this.plugin.getRewardsConfig().set("tiers." + tierName + ".rewards", (Object)rewards);
                }
                this.plugin.saveRewardsConfig();
                this.plugin.getRewardSystem().reloadRewardTiers();
                player.sendMessage("\u00a7a\u00a7lCommand successfully saved!");
            }
        }
        this.playerStates.put(playerId, GuiState.NONE);
        this.editingTier.remove(playerId);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.isOnline()) {
                this.plugin.getCommand("christmasgift").getExecutor().onCommand((CommandSender)player, null, "", new String[0]);
            }
        }, 20L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDrag(InventoryDragEvent event) {
        String title = event.getView().getTitle();
        if (title.equals("Christmas Gift Admin") || title.contains("Rewards Editor: ")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryClose(InventoryCloseEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        GuiState state = this.playerStates.get(playerId);
        if (state == GuiState.NONE) {
            this.playerStates.remove(playerId);
            this.editingTier.remove(playerId);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.playerStates.remove(playerId);
        this.editingTier.remove(playerId);
    }

    private static enum GuiState {
        EDITING_CHANCE,
        EDITING_PREFIX,
        ADDING_NEW_TIER,
        EDITING_COMMAND,
        NONE;

    }
}

