/*
 * Decompiled with CFR 0.152.
 */
package com.example.christmasgift;

import com.example.christmasgift.ChristmasGift;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RouletteSystem {
    private final ChristmasGift plugin;
    private final Map<String, TierInfo> tierInfoMap = new LinkedHashMap<String, TierInfo>();

    public RouletteSystem(ChristmasGift plugin) {
        this.plugin = plugin;
        this.initializeTierInfo();
    }

    public void clearActionBar(Player player) {
        if (player != null && player.isOnline()) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
        }
    }

    private void initializeTierInfo() {
        this.tierInfoMap.put("common", new TierInfo("COMMON", "&f&l", "+", ChatColor.WHITE));
        this.tierInfoMap.put("rare", new TierInfo("RARE", "&b&l", "*", ChatColor.AQUA));
        this.tierInfoMap.put("epic", new TierInfo("EPIC", "&5&l", "#", ChatColor.DARK_PURPLE));
        this.tierInfoMap.put("legendary", new TierInfo("LEGENDARY", "&6&l", "@", ChatColor.GOLD));
        this.tierInfoMap.put("mythic", new TierInfo("MYTHIC", "&d&l", "&", ChatColor.LIGHT_PURPLE));
    }

    public void startRouletteAnimation(final Player player, final String finalTier) {
        new BukkitRunnable(this){
            private int tickCount = 0;
            private final int TOTAL_TICKS = 80;
            private final int FAST_PHASE = 30;
            private final int SLOW_PHASE = 70;
            private int currentTierIndex = 0;
            private final List<String> tierOrder;
            private int ticksPerChange;
            private int ticksSinceLastChange;
            final /* synthetic */ RouletteSystem this$0;
            {
                this.this$0 = this$0;
                this.tierOrder = new ArrayList<String>(this.this$0.tierInfoMap.keySet());
                this.ticksPerChange = 2;
                this.ticksSinceLastChange = 0;
            }

            public void run() {
                if (this.tickCount >= 80 || !player.isOnline()) {
                    this.revealFinalReward(player, finalTier);
                    this.cancel();
                    return;
                }
                if (this.tickCount < 30) {
                    this.ticksPerChange = 2;
                } else if (this.tickCount < 70) {
                    this.ticksPerChange = 4;
                } else {
                    int remaining = 80 - this.tickCount;
                    this.ticksPerChange = 6 + (80 - this.tickCount) / 2;
                }
                ++this.ticksSinceLastChange;
                if (this.ticksSinceLastChange >= this.ticksPerChange) {
                    this.ticksSinceLastChange = 0;
                    this.currentTierIndex = (this.currentTierIndex + 1) % this.tierOrder.size();
                    String currentTier = this.tierOrder.get(this.currentTierIndex);
                    this.displayTierInActionBar(player, currentTier, this.tickCount);
                    float pitch = 0.5f + (float)this.tickCount / 80.0f * 1.5f;
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_HAT, 0.5f, pitch);
                }
                ++this.tickCount;
            }

            private void displayTierInActionBar(Player player2, String tierKey, int tick) {
                TierInfo tier = this.this$0.tierInfoMap.get(tierKey);
                if (tier == null) {
                    return;
                }
                StringBuilder display = new StringBuilder();
                int prevIndex = (this.currentTierIndex - 1 + this.tierOrder.size()) % this.tierOrder.size();
                TierInfo prevTier = this.this$0.tierInfoMap.get(this.tierOrder.get(prevIndex));
                display.append(ChatColor.DARK_GRAY).append(prevTier.symbol).append(" ");
                String color = ChatColor.translateAlternateColorCodes((char)'&', (String)tier.colorCode);
                display.append(color);
                if (tick % 4 < 2) {
                    display.append("[[ ").append(tier.symbol).append(" ").append(tier.displayName).append(" ").append(tier.symbol).append(" ]]");
                } else {
                    display.append(">> ").append(tier.symbol).append(" ").append(tier.displayName).append(" ").append(tier.symbol).append(" <<");
                }
                int nextIndex = (this.currentTierIndex + 1) % this.tierOrder.size();
                TierInfo nextTier = this.this$0.tierInfoMap.get(this.tierOrder.get(nextIndex));
                display.append(" ").append(ChatColor.DARK_GRAY).append(nextTier.symbol);
                player2.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(display.toString()));
            }

            private void revealFinalReward(final Player player2, String finalTier2) {
                final TierInfo tier = this.this$0.tierInfoMap.get(finalTier2);
                if (tier == null) {
                    return;
                }
                player2.playSound(player2.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                player2.playSound(player2.getLocation(), Sound.ENTITY_FIREWORK_ROCKET_BLAST, 0.8f, 1.2f);
                final String color = ChatColor.translateAlternateColorCodes((char)'&', (String)tier.colorCode);
                player2.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(color + "[[ " + tier.displayName + " REWARD! ]]"));
                new BukkitRunnable(this){
                    private int flashCount = 0;
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (this.flashCount >= 6 || !player2.isOnline()) {
                            player2.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
                            this.cancel();
                            return;
                        }
                        if (this.flashCount % 2 == 0) {
                            player2.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(color + "*** " + tier.displayName + " REWARD! ***"));
                        } else {
                            player2.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(color + ">>> " + tier.displayName + " REWARD! <<<"));
                        }
                        player2.playSound(player2.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.5f);
                        ++this.flashCount;
                    }
                }.runTaskTimer((Plugin)this.this$0.plugin, 0L, 3L);
                this.this$0.plugin.getServer().getScheduler().runTaskLater((Plugin)this.this$0.plugin, () -> this.this$0.plugin.getRewardSystem().giveReward(player2, finalTier2), 20L);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private static class TierInfo {
        final String displayName;
        final String colorCode;
        final String symbol;
        final ChatColor chatColor;

        TierInfo(String displayName, String colorCode, String symbol, ChatColor chatColor) {
            this.displayName = displayName;
            this.colorCode = colorCode;
            this.symbol = symbol;
            this.chatColor = chatColor;
        }
    }
}

