/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.api.Utils;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.api.recipe.PureDaisyRecipe;
import vazkii.botania.api.recipe.RunicAltarRecipe;
import vazkii.botania.api.recipe.TerrestrialAgglomerationRecipe;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.item.BotaniaItems;

public class BotaniaAddon {
    public static final String MODID = "botania";

    static String NAME(String name) {
        return "Botania" + name + "Mapper";
    }

    @ConversionProvider(value="botania")
    public static class BotaniaConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            builder.comment("Default conversions for Botania").before((ItemLike)BotaniaItems.pebble, 1L).before((ItemLike)BotaniaItems.livingroot, 1L).before((ItemLike)BotaniaItems.lifeEssence, 256L).before((ItemLike)BotaniaItems.enderAirBottle, 1024L);
        }
    }

    @RecipeTypeMapper(requiredMods={"botania"}, priority=1)
    public static class BTerraPlateMapper
    extends ARecipeTypeMapper<TerrestrialAgglomerationRecipe> {
        @Override
        public String getName() {
            return BotaniaAddon.NAME("TerraPlate");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == BotaniaRecipeTypes.TERRA_PLATE_TYPE;
        }
    }

    @RecipeTypeMapper(requiredMods={"botania"}, priority=1)
    public static class BRuneAlterMapper
    extends ARecipeTypeMapper<RunicAltarRecipe> {
        @Override
        public String getName() {
            return BotaniaAddon.NAME("RuneAlter");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == BotaniaRecipeTypes.RUNE_TYPE;
        }
    }

    @RecipeTypeMapper(requiredMods={"botania"}, priority=1)
    public static class BPureDaisyMapper
    extends ARecipeTypeMapper<PureDaisyRecipe> {
        @Override
        public String getName() {
            return BotaniaAddon.NAME("PureDaisy");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == BotaniaRecipeTypes.PURE_DAISY_TYPE;
        }

        @Override
        public NSSOutput getOutput(PureDaisyRecipe recipe) {
            return new NSSOutput(recipe.getOutputState());
        }

        @Override
        public NSSInput getInput(PureDaisyRecipe recipe) {
            List matches = recipe.getInput().getDisplayed();
            IngredientMap ingredientMap = new IngredientMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            if (matches == null) {
                return null;
            }
            if (matches.size() == 1) {
                boolean res = Utils.addBlockToIngredientMap((IngredientMap<NormalizedSimpleStack>)ingredientMap, ((BlockState)matches.get(0)).m_60734_());
                return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, res);
            }
            if (matches.size() > 1) {
                HashSet<NormalizedSimpleStack> rawNSSMatches = new HashSet<NormalizedSimpleStack>();
                ArrayList<Block> stacks = new ArrayList<Block>();
                for (BlockState match : matches) {
                    NormalizedSimpleStack nss = Utils.getNSSFromBlock(match.m_60734_());
                    if (nss != null) {
                        rawNSSMatches.add(nss);
                    }
                    stacks.add(match.m_60734_());
                }
                int count = stacks.size();
                if (count == 1) {
                    boolean res = Utils.addBlockToIngredientMap((IngredientMap<NormalizedSimpleStack>)ingredientMap, ((Block)stacks.get(0)).m_49966_().m_60734_());
                    return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, res);
                }
                Tuple group = this.fakeGroupManager.getOrCreateFakeGroup(rawNSSMatches);
                NormalizedSimpleStack dummy = (NormalizedSimpleStack)group.m_14418_();
                ingredientMap.addIngredient((Object)dummy, 1);
                if (((Boolean)group.m_14419_()).booleanValue()) {
                    ArrayList<IngredientMap> groupIngredientMaps = new ArrayList<IngredientMap>();
                    Iterator iterator = stacks.iterator();
                    while (iterator.hasNext()) {
                        IngredientMap groupIngredientMap = new IngredientMap();
                        Block block = (Block)iterator.next();
                        if (!Utils.addBlockToIngredientMap((IngredientMap<NormalizedSimpleStack>)groupIngredientMap, block)) continue;
                        groupIngredientMaps.add(groupIngredientMap);
                    }
                    fakeGroupMap.add((Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>)new Tuple((Object)dummy, groupIngredientMaps));
                }
            }
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
        }
    }

    @RecipeTypeMapper(requiredMods={"botania"}, priority=1)
    public static class BPetalMapper
    extends ARecipeTypeMapper<PetalApothecaryRecipe> {
        @Override
        public String getName() {
            return BotaniaAddon.NAME("Petal");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == BotaniaRecipeTypes.PETAL_TYPE;
        }
    }

    @RecipeTypeMapper(requiredMods={"botania"}, priority=1)
    public static class BManaInfusionMapper
    extends ARecipeTypeMapper<ManaInfusionRecipe> {
        @Override
        public String getName() {
            return BotaniaAddon.NAME("ManaInfusion");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == BotaniaRecipeTypes.MANA_INFUSION_TYPE;
        }
    }

    @RecipeTypeMapper(requiredMods={"botania"}, priority=1)
    public static class BElvenTradeMapper
    extends ARecipeTypeMapper<ElvenTradeRecipe> {
        @Override
        public String getName() {
            return BotaniaAddon.NAME("ElvenTrade");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == BotaniaRecipeTypes.ELVEN_TRADE_TYPE;
        }

        @Override
        public NSSOutput getOutput(ElvenTradeRecipe recipe) {
            return this.mapOutputs(recipe.getOutputs().toArray());
        }
    }
}

