/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.mna.api.recipes.IItemAndPatternRecipe;
import com.mna.api.rituals.IRitualReagent;
import com.mna.api.tools.MATags;
import com.mna.items.ItemInit;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.arcanefurnace.ArcaneFurnaceRecipe;
import com.mna.recipes.eldrin.EldrinAltarRecipe;
import com.mna.recipes.manaweaving.ManaweavingRecipe;
import com.mna.recipes.rituals.RitualRecipe;
import com.mna.recipes.runeforging.RuneforgingRecipe;
import com.mna.recipes.runeforging.RunescribingRecipe;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class ManaAndArtificeAddon {
    public static final String MODID = "mna";

    public static String NAME(String name) {
        return "ManaAndArtifice" + name + "Mapper";
    }

    public static abstract class MAAItemAndPatternRecipeMapper<R extends IItemAndPatternRecipe & Recipe<?>>
    extends ARecipeTypeMapper<R> {
        @Override
        protected List<Ingredient> getIngredients(R recipe) {
            ArrayList<Ingredient> recipeIngredients = new ArrayList<Ingredient>();
            for (ResourceLocation resourceLocation : recipe.getRequiredItems()) {
                recipeIngredients.add(Ingredient.m_43921_(MATags.smartLookupItem((ResourceLocation)resourceLocation).stream().map(item -> {
                    ItemStack stack = new ItemStack((ItemLike)item);
                    if (stack.m_41720_() == Items.f_42589_ && stack.m_41783_() == null) {
                        PotionUtils.m_43549_((ItemStack)stack, (Potion)Potions.f_43599_);
                    }
                    return stack;
                })));
            }
            return recipeIngredients;
        }
    }

    @ConversionProvider(value="mna")
    public static class MAAConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            builder.comment("Default conversions for Mana and Artifice").before((ItemLike)ItemInit.VINTEUM_DUST.get(), 32L).before((ItemLike)ItemInit.CHIMERITE_GEM.get(), 96L);
        }
    }

    @RecipeTypeMapper(requiredMods={"mna"}, priority=1)
    public static class MAARuneforgingRecipeMapper
    extends ARecipeTypeMapper<RuneforgingRecipe> {
        @Override
        public String getName() {
            return ManaAndArtificeAddon.NAME("Runeforging");
        }

        public boolean canHandle(RecipeType<?> iRecipeType) {
            return iRecipeType == RecipeInit.RUNEFORGING_TYPE.get();
        }

        @Override
        protected List<Ingredient> getIngredients(RuneforgingRecipe recipe) {
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            inputs.add(Ingredient.m_43921_(MATags.smartLookupItem((ResourceLocation)recipe.getMaterial()).stream().map(ItemStack::new)));
            inputs.add(Ingredient.m_43921_(MATags.smartLookupItem((ResourceLocation)recipe.getPatternResource()).stream().map(ItemStack::new)));
            return inputs;
        }
    }

    @RecipeTypeMapper(requiredMods={"mna"}, priority=1)
    public static class MAARunescribingRecipeMapper
    extends ARecipeTypeMapper<RunescribingRecipe> {
        @Override
        public String getName() {
            return ManaAndArtificeAddon.NAME("Runescribing");
        }

        public boolean isAvailable() {
            return false;
        }

        public boolean canHandle(RecipeType<?> iRecipeType) {
            return iRecipeType == RecipeInit.RUNESCRIBING_TYPE.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"mna"}, priority=1)
    public static class MAARitualRecipeMapper
    extends ARecipeTypeMapper<RitualRecipe> {
        @Override
        public String getName() {
            return ManaAndArtificeAddon.NAME("Ritual");
        }

        @Override
        public String getDescription() {
            return super.getDescription() + "NOTE: Disabled by default because this really shouldn't be here.";
        }

        public boolean isAvailable() {
            return false;
        }

        public boolean canHandle(RecipeType<?> iRecipeType) {
            return iRecipeType == RecipeInit.RITUAL_TYPE.get();
        }

        @Override
        protected List<Ingredient> getIngredients(RitualRecipe recipe) {
            IRitualReagent[][] reagents;
            ArrayList<Ingredient> recipeIngredients = new ArrayList<Ingredient>();
            for (IRitualReagent[] reagent : reagents = recipe.getReagents()) {
                for (int j = 0; j < reagent.length; ++j) {
                    if (reagent[j] == null || reagent[j].isEmpty() || reagent[j].isDynamic()) continue;
                    recipeIngredients.add(Ingredient.m_43921_(MATags.smartLookupItem((ResourceLocation)reagent[j].getResourceLocation()).stream().map(ItemStack::new)));
                }
            }
            return recipeIngredients;
        }
    }

    @RecipeTypeMapper(requiredMods={"mna"}, priority=1)
    public static class MAAManaweavingRecipeMapper
    extends MAAItemAndPatternRecipeMapper<ManaweavingRecipe> {
        @Override
        public String getName() {
            return ManaAndArtificeAddon.NAME("Manaweaving");
        }

        public boolean canHandle(RecipeType<?> iRecipeType) {
            return iRecipeType == RecipeInit.MANAWEAVING_RECIPE_TYPE.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"mna"}, priority=1)
    public static class MAAEldrinAltarRecipeMapper
    extends MAAItemAndPatternRecipeMapper<EldrinAltarRecipe> {
        @Override
        public String getName() {
            return ManaAndArtificeAddon.NAME("EldrinAltar");
        }

        public boolean canHandle(RecipeType<?> iRecipeType) {
            return iRecipeType == RecipeInit.ELDRIN_ALTAR_TYPE.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"mna"}, priority=1)
    public static class MAAArcaneFurnaceRecipeMapper
    extends ARecipeTypeMapper<ArcaneFurnaceRecipe> {
        @Override
        public String getName() {
            return ManaAndArtificeAddon.NAME("ArcaneFurnace");
        }

        public boolean canHandle(RecipeType<?> iRecipeType) {
            return iRecipeType == RecipeInit.ARCANE_FURNACE_TYPE.get();
        }

        @Override
        protected List<Ingredient> getIngredients(ArcaneFurnaceRecipe recipe) {
            return Collections.singletonList(Ingredient.m_43921_(MATags.smartLookupItem((ResourceLocation)recipe.getInputItem()).stream().map(ItemStack::new)));
        }
    }
}

