/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.recipes.AERecipeTypes;
import appeng.recipes.handlers.ChargerRecipe;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.transform.TransformRecipe;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class AppliedEnergisticsAddon {
    public static final String MODID = "ae2";

    public static String NAME(String name) {
        return "AppliedEnergistics" + name + "Mapper";
    }

    @ConversionProvider(value="ae2")
    public static class AEConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            ((CustomConversionBuilder)builder.comment("Set defaults conversions for Applied Energistics")).before((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL.get(), 256L).before((ItemLike)AEBlocks.SKY_STONE_BLOCK, 16L);
        }
    }

    @RecipeTypeMapper(requiredMods={"ae2"}, priority=1)
    public static class AETransformMapper
    extends ARecipeTypeMapper<TransformRecipe> {
        @Override
        public String getName() {
            return AppliedEnergisticsAddon.NAME("Transform");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AERecipeTypes.TRANSFORM;
        }
    }

    @RecipeTypeMapper(requiredMods={"ae2"}, priority=1)
    public static class AEInscriberMapper
    extends ARecipeTypeMapper<InscriberRecipe> {
        @Override
        public String getName() {
            return AppliedEnergisticsAddon.NAME("Inscriber");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AERecipeTypes.INSCRIBER;
        }

        @Override
        protected List<Ingredient> getIngredients(InscriberRecipe recipe) {
            if (recipe.getProcessType() == InscriberProcessType.INSCRIBE) {
                return Collections.singletonList(recipe.getMiddleInput());
            }
            return super.getIngredients(recipe);
        }
    }

    @RecipeTypeMapper(requiredMods={"ae2"}, priority=1)
    public static class AEChargerMapper
    extends ARecipeTypeMapper<ChargerRecipe> {
        @Override
        public String getName() {
            return AppliedEnergisticsAddon.NAME("Charger");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AERecipeTypes.CHARGER;
        }
    }
}

