/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import earth.terrarium.chipped.common.recipes.ChippedRecipe;
import earth.terrarium.chipped.common.registry.ModRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;

public class ChippedAddon {
    public static final String MODID = "chipped";

    public static String NAME(String name) {
        return "Chipped" + name + "Mapper";
    }

    @RecipeTypeMapper(requiredMods={"chipped"}, priority=1)
    public static class ChippedWorkbenchMapper
    extends ARecipeTypeMapper<ChippedRecipe> {
        @Override
        public String getName() {
            return ChippedAddon.NAME("Workbench");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.WORKBENCH.get();
        }

        @Override
        public boolean convertRecipe(ChippedRecipe recipe) {
            ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fgm = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
            for (Ingredient ingredient : recipe.ingredients()) {
                Object2IntOpenHashMap ingMap = new Object2IntOpenHashMap();
                ItemStack[] items = ingredient.getItems();
                this.convertIngredient(ingredient, (Object2IntMap<NormalizedSimpleStack>)ingMap, fgm);
                for (ItemStack item : items) {
                    this.mapper.addConversion(1, (Object)NSSItem.createItem((ItemStack)item), (Object2IntMap)ingMap);
                }
            }
            return this.addConversionsAndReturn(fgm, true);
        }
    }
}

