/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import com.simibubi.create.content.kinetics.crusher.CrushingRecipe;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.simibubi.create.content.kinetics.fan.processing.HauntingRecipe;
import com.simibubi.create.content.kinetics.fan.processing.SplashingRecipe;
import com.simibubi.create.content.kinetics.millstone.MillingRecipe;
import com.simibubi.create.content.kinetics.mixer.CompactingRecipe;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;

public class CreateAddon {
    public static final String MODID = "create";

    static String NAME(String name) {
        return "Create" + name + "Mapper";
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateSandPaperPolishingMapper
    extends CreateProcessingRecipeMapper<SandPaperPolishingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("SandpaperPolishing");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AllRecipeTypes.SANDPAPER_POLISHING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateSequencedAssemblyMapper
    extends ARecipeTypeMapper<SequencedAssemblyRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("SequencedAssembly");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AllRecipeTypes.SEQUENCED_ASSEMBLY.getType();
        }

        @Override
        protected List<Ingredient> getIngredients(SequencedAssemblyRecipe recipe) {
            int loops = recipe.getLoops();
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(loops * recipe.getSequence().size());
            ingredients.add(recipe.getIngredient());
            int i = 0;
            for (SequencedRecipe step : recipe.getSequence()) {
                ProcessingRecipe stepRecipe = step.getRecipe();
                ArrayList stepIngredients = new ArrayList(stepRecipe.getIngredients());
                stepIngredients.removeFirst();
                if (stepIngredients.isEmpty()) continue;
                if (loops == 1) {
                    ingredients.addAll(stepIngredients);
                } else {
                    for (Ingredient ingredient : stepIngredients) {
                        ingredients.addAll(Collections.nCopies(loops, ingredient));
                    }
                }
                ++i;
            }
            return ingredients;
        }

        @Override
        public NSSOutput getOutput(SequencedAssemblyRecipe recipe) {
            ItemStack output = recipe.getResultItem((HolderLookup.Provider)this.registryAccess);
            if (output.isEmpty()) {
                return null;
            }
            return new NSSOutput(output);
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateItemApplicationMapper
    extends CreateProcessingRecipeMapper<ItemApplicationRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("ItemApplication");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AllRecipeTypes.ITEM_APPLICATION.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateMechanicalCraftingMapper
    extends ARecipeTypeMapper<MechanicalCraftingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("MechanicalCrafting");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AllRecipeTypes.MECHANICAL_CRAFTING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateDeployerApplicationMapper
    extends CreateProcessingRecipeMapper<DeployerApplicationRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("DeployerApplication");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AllRecipeTypes.DEPLOYING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateSplashingMapper
    extends CreateProcessingRecipeMapper<SplashingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("Splashing");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AllRecipeTypes.SPLASHING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreatePressingMapper
    extends CreateProcessingRecipeMapper<PressingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("Pressing");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AllRecipeTypes.PRESSING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateMixingMapper
    extends CreateProcessingRecipeMapper<MixingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("CUTTING");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AllRecipeTypes.MIXING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateMillingMapper
    extends CreateProcessingRecipeMapper<MillingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("Milling");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AllRecipeTypes.MILLING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateHauntingMapper
    extends CreateProcessingRecipeMapper<HauntingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("Haunting");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AllRecipeTypes.HAUNTING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateCuttingMapper
    extends CreateProcessingRecipeMapper<CuttingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("Cutting");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AllRecipeTypes.CUTTING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateCrushingMapper
    extends CreateProcessingRecipeMapper<CrushingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("Crushing");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AllRecipeTypes.CRUSHING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateCompactingMapper
    extends CreateProcessingRecipeMapper<CompactingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("Compacting");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AllRecipeTypes.COMPACTING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateBasinMapper
    extends CreateProcessingRecipeMapper<BasinRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("BASIN");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == AllRecipeTypes.BASIN.getType();
        }
    }

    public static abstract class CreateProcessingRecipeMapper<R extends ProcessingRecipe<?>>
    extends ARecipeTypeMapper<R> {
        @Override
        public NSSInput getInput(R recipe) {
            NonNullList ingredients = recipe.getIngredients();
            NonNullList fluidIngredients = recipe.getFluidIngredients();
            if (ingredients.isEmpty() && fluidIngredients.isEmpty()) {
                PEIntegration.debugLog("Recipe ({}) contains no inputs: (Ingredients: {}; Fluids: {})", this.recipeID, ingredients, fluidIngredients);
                return null;
            }
            ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
            Object2IntOpenHashMap ingredientMap = new Object2IntOpenHashMap();
            for (int i = 0; i < ingredients.size(); ++i) {
                ItemApplicationRecipe iaRecipe;
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                if (recipe instanceof ItemApplicationRecipe && (iaRecipe = (ItemApplicationRecipe)recipe).shouldKeepHeldItem() && i == 1 || this.convertIngredient(ingredient, (Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) continue;
                return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, false);
            }
            for (FluidIngredient fluidIngredient : fluidIngredients) {
                int amount = fluidIngredient.getRequiredAmount();
                List matches = fluidIngredient.getMatchingFluidStacks();
                if (matches.isEmpty()) continue;
                if (matches.size() == 1) {
                    ingredientMap.put((Object)NSSFluid.createFluid((FluidStack)((FluidStack)matches.getFirst())), amount);
                    continue;
                }
                HashSet<NSSFluid> rawNSSMatches = new HashSet<NSSFluid>();
                ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
                for (FluidStack match : matches) {
                    if (match.isEmpty()) continue;
                    rawNSSMatches.add(NSSFluid.createFluid((FluidStack)match));
                    stacks.add(match);
                }
                int count = stacks.size();
                if (count == 1) {
                    ingredientMap.put((Object)NSSFluid.createFluid((FluidStack)((FluidStack)stacks.getFirst())), amount);
                    continue;
                }
                if (count <= 1) continue;
                INSSFakeGroupManager.FakeGroupData group = this.fakeGroupManager.getOrCreateFakeGroup(rawNSSMatches);
                NormalizedSimpleStack dummy = group.dummy();
                ingredientMap.put((Object)dummy, Math.max(amount, 1));
                if (!group.created()) continue;
                ArrayList<Object2IntOpenHashMap> groupIngredientMaps = new ArrayList<Object2IntOpenHashMap>();
                for (FluidStack stack : stacks) {
                    Object2IntOpenHashMap groupIngredientMap = new Object2IntOpenHashMap();
                    groupIngredientMap.put((Object)NSSFluid.createFluid((FluidStack)stack), 1);
                    groupIngredientMaps.add(groupIngredientMap);
                }
                fakeGroupMap.add((Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>)new Tuple((Object)dummy, groupIngredientMaps));
            }
            return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
        }

        @Override
        public NSSOutput getOutput(R recipe) {
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            List<ItemStack> results = recipe.getRollableResults().stream().filter(pO -> pO.getChance() >= 1.0f).map(ProcessingOutput::getStack).toList();
            outputs.addAll(results);
            outputs.addAll((Collection<ItemStack>)recipe.getFluidResults());
            if (outputs.isEmpty()) {
                return NSSOutput.EMPTY;
            }
            return this.mapOutputs(outputs.toArray());
        }
    }
}

