/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.utils.Constants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;

public class EvilCraftAddon {
    public static final String MODID = "evilcraft";

    public static String NAME(String name) {
        return "EvilCraft" + name + "Mapper";
    }

    @ConversionProvider(value="evilcraft")
    public static class ECConversionProvider
    extends AConversionProvider {
        private static final Item ITEM_VENGEANCE_ESSENCE = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"vengeance_essence"));
        private static final Item ITEM_ENDER_TEAR = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"ender_tear"));

        @Override
        public void convert(CustomConversionBuilder builder) {
            ((CustomConversionBuilder)((CustomConversionBuilder)builder.comment("Default conversions for EvilCraft")).before((Fluid)RegistryEntries.FLUID_BLOOD.get(), 1L).before((ItemLike)RegistryEntries.ITEM_POISON_SAC.get(), 16L).before((ItemLike)RegistryEntries.ITEM_DARK_GEM.get(), 64L).before((ItemLike)RegistryEntries.ITEM_WEREWOLF_BONE.get(), 144L).before((ItemLike)ITEM_VENGEANCE_ESSENCE, 512L).before((ItemLike)ITEM_ENDER_TEAR, 1024L).conversion((ItemLike)RegistryEntries.BLOCK_HARDENED_BLOOD.get()).ingredient((Fluid)RegistryEntries.FLUID_BLOOD.get(), 1000).end()).conversion((ItemLike)RegistryEntries.ITEM_DARK_GEM_CRUSHED.get()).ingredient((ItemLike)RegistryEntries.ITEM_DARK_GEM.get()).end();
        }
    }

    @RecipeTypeMapper(requiredMods={"evilcraft"}, priority=1)
    public static class ECEnvironmentalAccumulatorMapper
    extends ARecipeTypeMapper<RecipeEnvironmentalAccumulator> {
        @Override
        public String getName() {
            return EvilCraftAddon.NAME("EnvironmentalAccumulator");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR.get();
        }

        @Override
        protected List<Ingredient> getIngredients(RecipeEnvironmentalAccumulator recipe) {
            return Collections.singletonList(recipe.getInputIngredient());
        }
    }

    @RecipeTypeMapper(requiredMods={"evilcraft"}, priority=1)
    public static class ECBloodInfuserMapper
    extends ARecipeTypeMapper<RecipeBloodInfuser> {
        @Override
        public String getName() {
            return EvilCraftAddon.NAME("BloodInfuser");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == RegistryEntries.RECIPETYPE_BLOOD_INFUSER.get();
        }

        @Override
        public NSSInput getInput(RecipeBloodInfuser recipe) {
            Object2IntOpenHashMap ingMap = new Object2IntOpenHashMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
            this.convertIngredient((Ingredient)recipe.getInputIngredient().get(), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupMap);
            ingMap.mergeInt((Object)NSSFluid.createFluid((FluidStack)((FluidStack)recipe.getInputFluid().get())), ((FluidStack)recipe.getInputFluid().get()).getAmount() / 10, Constants.INT_SUM);
            return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupMap, true);
        }
    }
}

