/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class ImmersiveEngineeringAddon {
    public static final String MODID = "immersiveengineering";

    protected static String NAME(String name) {
        return "ImmersiveEngineering" + name + "Mapper";
    }

    @ConversionProvider(value="immersiveengineering")
    public static class IEConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            ((CustomConversionBuilder)builder.comment("default conversions for immersive engineering")).before(IEConversionProvider.commonTag("fiber_hemp"), 4L).before(IEConversionProvider.dustTag("wood"), 1L).before(IEConversionProvider.dustTag("sulfur"), 8L).before(IEConversionProvider.dustTag("nitrate"), 8L).before(IEConversionProvider.ingotTag("hop_graphite"), 12L).before((ItemLike)IEItems.Ingredients.SLAG.get(), 8L).before((Fluid)IEFluids.CREOSOTE.getStill(), 1L);
            for (IEBlocks.BlockEntry block : IEBlocks.WoodenDecoration.TREATED_WOOD.values()) {
                builder.conversion((ItemLike)block).ingredient(ItemTags.PLANKS, 8).end();
            }
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IESqueezerMapper
    extends IEMultiblockRecipeMapper<SqueezerRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Squeezer");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IERecipeTypes.SQUEEZER.get();
        }

        @Override
        protected List<Ingredient> getIngredients(SqueezerRecipe recipe) {
            return Collections.singletonList(recipe.input.getBaseIngredient());
        }

        @Override
        public NSSOutput getOutput(SqueezerRecipe recipe) {
            return this.mapOutputs(recipe.itemOutput, recipe.fluidOutput);
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IESawmillMapper
    extends IEMultiblockRecipeMapper<SawmillRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Sawmill");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IERecipeTypes.SAWMILL.get();
        }

        @Override
        protected List<Ingredient> getIngredients(SawmillRecipe recipe) {
            return Collections.singletonList(recipe.input);
        }

        @Override
        public NSSOutput getOutput(SawmillRecipe recipe) {
            return new NSSOutput(recipe.output.get());
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IERefineryMapper
    extends IEMultiblockRecipeMapper<RefineryRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Refinery");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IERecipeTypes.REFINERY.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IEMixerMapper
    extends IEMultiblockRecipeMapper<MixerRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Mixer");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IERecipeTypes.MIXER.get();
        }

        @Override
        public NSSOutput getOutput(MixerRecipe recipe) {
            return new NSSOutput(recipe.fluidOutput.copy());
        }

        @Override
        public NSSInput getInput(MixerRecipe recipe) {
            Object2IntOpenHashMap ingredientMap = new Object2IntOpenHashMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
            this.convertFluidIngredient(recipe.fluidInput.amount(), Arrays.asList(recipe.fluidInput.getFluids()), (Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap);
            for (IngredientWithSize input : recipe.itemInputs) {
                this.convertIngredient(input.getCount(), input.getBaseIngredient(), (Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap);
            }
            return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IEMetalPressMapper
    extends ARecipeTypeMapper<MetalPressRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("MetalPress");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IERecipeTypes.METAL_PRESS.get();
        }

        @Override
        protected List<Ingredient> getIngredients(MetalPressRecipe recipe) {
            return Collections.singletonList(recipe.input.getBaseIngredient());
        }

        @Override
        public NSSOutput getOutput(MetalPressRecipe recipe) {
            return new NSSOutput(recipe.output.get());
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IEFermenterMapper
    extends ARecipeTypeMapper<FermenterRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Fermenter");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IERecipeTypes.FERMENTER.get();
        }

        @Override
        public NSSOutput getOutput(FermenterRecipe recipe) {
            return new NSSOutput(recipe.fluidOutput);
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IECrusherMapper
    extends IEMultiblockRecipeMapper<CrusherRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Crusher");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IERecipeTypes.CRUSHER.get();
        }

        @Override
        public NSSOutput getOutput(CrusherRecipe recipe) {
            return new NSSOutput(recipe.output.get());
        }

        @Override
        protected List<Ingredient> getIngredients(CrusherRecipe recipe) {
            return Collections.singletonList(recipe.input);
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IECokeOvenMapper
    extends ARecipeTypeMapper<CokeOvenRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("CokeOven");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IERecipeTypes.COKE_OVEN.get();
        }

        @Override
        public NSSInput getInput(CokeOvenRecipe recipe) {
            return this.convertSingleIngredient(recipe.input.getCount(), recipe.input.getBaseIngredient());
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IEClocheMapper
    extends ARecipeTypeMapper<ClocheRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Cloche");
        }

        @Override
        public String getDescription() {
            return super.getDescription() + " NOTE: Disabled by default because its plants";
        }

        public boolean isAvailable() {
            return false;
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IERecipeTypes.CLOCHE.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IEBottlerMapper
    extends IEMultiblockRecipeMapper<BottlingMachineRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Bottling");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IERecipeTypes.BOTTLING_MACHINE.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IEBlueprintMapper
    extends IEMultiblockRecipeMapper<BlueprintCraftingRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Blueprint");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IERecipeTypes.BLUEPRINT.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IEBlastFurnaceMapper
    extends ARecipeTypeMapper<BlastFurnaceRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("BlastFurnace");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IERecipeTypes.BLAST_FURNACE.get();
        }

        @Override
        public NSSInput getInput(BlastFurnaceRecipe recipe) {
            return this.convertSingleIngredient(recipe.input.getCount(), recipe.input.getBaseIngredient());
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IEArcFurnaceMapper
    extends IEMultiblockRecipeMapper<ArcFurnaceRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("ArcFurnace");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IERecipeTypes.ARC_FURNACE.get();
        }

        @Override
        public boolean convertRecipe(ArcFurnaceRecipe recipe) {
            if (recipe.isSpecialType("recycling")) {
                PEIntegration.debugLog("Skipping Arc Furnace - Recycling Recipe ({})", this.recipeID);
                return false;
            }
            return super.convertRecipe(recipe);
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IEAlloyMapper
    extends ARecipeTypeMapper<AlloyRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Alloy");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == IERecipeTypes.ALLOY.get();
        }

        @Override
        public NSSInput getInput(AlloyRecipe recipe) {
            Object2IntOpenHashMap ingMap = new Object2IntOpenHashMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupData = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
            this.convertIngredient(recipe.input0.getCount(), recipe.input0.getBaseIngredient(), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
            this.convertIngredient(recipe.input1.getCount(), recipe.input1.getBaseIngredient(), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
            return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData, true);
        }
    }

    public static abstract class IEMultiblockRecipeMapper<R extends MultiblockRecipe>
    extends ARecipeTypeMapper<R> {
        @Override
        public NSSInput getInput(R recipe) {
            Object2IntOpenHashMap ingMap = new Object2IntOpenHashMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupData = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
            if (recipe.getFluidInputs() != null && recipe.getFluidInputs().isEmpty() && recipe.getItemInputs().isEmpty()) {
                PEIntegration.LOGGER.warn("Immersive Engineering Recipe ({}) contains no inputs!", (Object)this.recipeID);
            }
            for (IngredientWithSize ingredient : recipe.getItemInputs()) {
                this.convertIngredient(ingredient.getCount(), ingredient.getBaseIngredient(), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
            }
            if (recipe.getFluidInputs() != null) {
                for (SizedFluidIngredient fluidInput : recipe.getFluidInputs()) {
                    this.convertFluidIngredient(fluidInput.amount(), Arrays.asList(fluidInput.getFluids()), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
                }
            }
            return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData, true);
        }

        @Override
        public NSSOutput getOutput(R recipe) {
            ArrayList outputs = new ArrayList(recipe.getItemOutputs());
            if (recipe.getFluidOutputs() != null && !recipe.getFluidOutputs().isEmpty()) {
                outputs.addAll(recipe.getFluidOutputs());
            }
            PEIntegration.LOGGER.info("Multiblock Recipe ({}) has outputs {}", (Object)this.recipeID, outputs);
            return this.mapOutputs(outputs.toArray());
        }
    }
}

