/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.CrusherRecipe;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.recipe.StoneWorkGenerateRecipe;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class IndustrialForegoingAddon {
    public static final String MODID = "industrialforegoing";

    public static String NAME(String name) {
        return "IndustrialForegoing" + name + "Mapper";
    }

    @ConversionProvider(value="industrialforegoing")
    public static class IFConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            ((CustomConversionBuilder)((CustomConversionBuilder)builder.comment("Sets default conversions for Industrial Foregoing")).before((Fluid)ModuleCore.SEWAGE.getSourceFluid().get(), 1L).before((ItemLike)ModuleCore.DRY_RUBBER.get(), 12L).before((Fluid)ModuleCore.SLUDGE.getSourceFluid().get(), 1L).before((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), 1L).before((ItemLike)ModuleCore.PINK_SLIME_ITEM.get(), 16L).before((Fluid)ModuleCore.ETHER.getSourceFluid().get(), 1L).conversion((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 1600).ingredient(ItemTags.LOGS).end()).conversion((ItemLike)ModuleCore.FERTILIZER.get()).ingredient((Fluid)ModuleCore.SEWAGE.getSourceFluid().get(), 1000).end();
        }
    }

    @RecipeTypeMapper(requiredMods={"industrialforegoing"}, priority=1)
    public static class IFStoneWorkGenerateMapper
    extends ARecipeTypeMapper<StoneWorkGenerateRecipe> {
        @Override
        public String getName() {
            return IndustrialForegoingAddon.NAME("StoneWorksGenerate");
        }

        @Override
        public String getDescription() {
            return super.getDescription() + " NOTE: Disabled by default.";
        }

        public boolean isAvailable() {
            return false;
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModuleCore.STONEWORK_GENERATE_TYPE.get();
        }

        @Override
        public NSSOutput getOutput(StoneWorkGenerateRecipe recipe) {
            ItemStack output = recipe.output.copy();
            if (output.isEmpty()) {
                return null;
            }
            return new NSSOutput(output);
        }

        @Override
        public NSSInput getInput(StoneWorkGenerateRecipe recipe) {
            int lavaRequired = recipe.lavaConsume;
            int waterRequired = recipe.waterConsume;
            if (lavaRequired == 0 && waterRequired == 0) {
                return null;
            }
            Object2IntOpenHashMap ingredientMap = new Object2IntOpenHashMap();
            if (lavaRequired > 0) {
                ingredientMap.put((Object)NSSFluid.createFluid((Fluid)Fluids.LAVA), lavaRequired);
            }
            if (waterRequired > 0) {
                ingredientMap.put((Object)NSSFluid.createFluid((Fluid)Fluids.WATER), waterRequired);
            }
            return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingredientMap, true);
        }
    }

    @RecipeTypeMapper(requiredMods={"industrialforegoing"}, priority=1)
    public static class IFDissolutionChamberMapper
    extends ARecipeTypeMapper<DissolutionChamberRecipe> {
        @Override
        public String getName() {
            return IndustrialForegoingAddon.NAME("DissolutionChamber");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModuleCore.DISSOLUTION_TYPE.get();
        }

        @Override
        public NSSOutput getOutput(DissolutionChamberRecipe recipe) {
            if (recipe.output.isPresent() && recipe.outputFluid.isEmpty()) {
                return super.getOutput(recipe);
            }
            return this.mapOutputs(recipe.output, recipe.outputFluid);
        }

        @Override
        public NSSInput getInput(DissolutionChamberRecipe recipe) {
            Object2IntOpenHashMap ingMap = new Object2IntOpenHashMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupData = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
            for (Ingredient input : recipe.input) {
                this.convertIngredient(Ingredient.of((ItemStack[])input.getItems()), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
            }
            if (recipe.inputFluid != null) {
                this.convertFluidIngredient(recipe.inputFluid.amount(), List.of(recipe.inputFluid.getFluids()), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
            }
            return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData, true);
        }
    }

    @RecipeTypeMapper(requiredMods={"industrialforegoing"}, priority=1)
    public static class IFCrusherMapper
    extends ARecipeTypeMapper<CrusherRecipe> {
        @Override
        public String getName() {
            return IndustrialForegoingAddon.NAME("Crusher");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModuleCore.CRUSHER_TYPE.get();
        }

        @Override
        public NSSOutput getOutput(CrusherRecipe recipe) {
            return this.mapOutput(recipe.output.getItems());
        }

        @Override
        protected List<Ingredient> getIngredients(CrusherRecipe recipe) {
            return Collections.singletonList(recipe.input);
        }
    }
}

