/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.blakebr0.mysticalagriculture.api.crafting.IAwakeningRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.IInfusionRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.IReprocessorRecipe;
import com.blakebr0.mysticalagriculture.init.ModBlocks;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class MysticalAgricultureAddon {
    public static final String MODID = "mysticalagriculture";

    public static String NAME(String name) {
        return "MysticalAgriculture" + name + "Mapper";
    }

    @ConversionProvider(value="mysticalagriculture")
    public static class MysticalAgricultureConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            ((CustomConversionBuilder)builder.comment("default conversions for Mystical Agriculture")).before((ItemLike)ModItems.PROSPERITY_SHARD.get(), 128L).before((ItemLike)ModItems.INFERIUM_ESSENCE.get(), 32L).before((ItemLike)ModItems.SOULIUM_DUST.get(), 128L).before((ItemLike)ModItems.COGNIZANT_DUST.get(), 16384L).before((ItemLike)ModBlocks.SOULSTONE_COBBLE.get(), 16L);
        }
    }

    @RecipeTypeMapper(requiredMods={"mysticalagriculture"}, priority=1)
    public static class MAReprocessorMapper
    extends ARecipeTypeMapper<IReprocessorRecipe> {
        @Override
        public String getName() {
            return MysticalAgricultureAddon.NAME("Reprocessor");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.REPROCESSOR.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"mysticalagriculture"}, priority=1)
    public static class MAInfusionMapper
    extends ARecipeTypeMapper<IInfusionRecipe> {
        @Override
        public String getName() {
            return MysticalAgricultureAddon.NAME("Infusion");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.INFUSION.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"mysticalagriculture"}, priority=1)
    public static class MAAwakeningMapper
    extends ARecipeTypeMapper<IAwakeningRecipe> {
        @Override
        public String getName() {
            return MysticalAgricultureAddon.NAME("Awakening");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ModRecipeTypes.AWAKENING.get();
        }

        @Override
        public NSSInput getInput(IAwakeningRecipe recipe) {
            NonNullList ingredients = recipe.getIngredients();
            Object2IntOpenHashMap ingMap = new Object2IntOpenHashMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>> fakeGroupData = new ArrayList<Tuple<NormalizedSimpleStack, List<Object2IntMap<NormalizedSimpleStack>>>>();
            this.convertIngredient(recipe.getAltarIngredient(), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
            for (ItemStack essence : recipe.getEssences()) {
                this.convertItemStack(essence, (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
            }
            this.convertIngredient((Ingredient)ingredients.get(1), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
            this.convertIngredient((Ingredient)ingredients.get(3), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
            this.convertIngredient((Ingredient)ingredients.get(5), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
            this.convertIngredient((Ingredient)ingredients.get(7), (Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData);
            return new NSSInput((Object2IntMap<NormalizedSimpleStack>)ingMap, fakeGroupData, true);
        }
    }
}

